/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;

public enum AstCode {
    Nop,
    AConstNull,
    __IConstM1,
    __IConst0,
    __IConst1,
    __IConst2,
    __IConst3,
    __IConst4,
    __IConst5,
    __LConst0,
    __LConst1,
    __FConst0,
    __FConst1,
    __FConst2,
    __DConst0,
    __DConst1,
    __BIPush,
    __SIPush,
    LdC,
    __LdCW,
    __LdC2W,
    __ILoad,
    __LLoad,
    __FLoad,
    __DLoad,
    __ALoad,
    __ILoad0,
    __ILoad1,
    __ILoad2,
    __ILoad3,
    __LLoad0,
    __LLoad1,
    __LLoad2,
    __LLoad3,
    __FLoad0,
    __FLoad1,
    __FLoad2,
    __FLoad3,
    __DLoad0,
    __DLoad1,
    __DLoad2,
    __DLoad3,
    __ALoad0,
    __ALoad1,
    __ALoad2,
    __ALoad3,
    __IALoad,
    __LALoad,
    __FALoad,
    __DALoad,
    __AALoad,
    __BALoad,
    __CALoad,
    __SALoad,
    __IStore,
    __LStore,
    __FStore,
    __DStore,
    __AStore,
    __IStore0,
    __IStore1,
    __IStore2,
    __IStore3,
    __LStore0,
    __LStore1,
    __LStore2,
    __LStore3,
    __FStore0,
    __FStore1,
    __FStore2,
    __FStore3,
    __DStore0,
    __DStore1,
    __DStore2,
    __DStore3,
    __AStore0,
    __AStore1,
    __AStore2,
    __AStore3,
    __IAStore,
    __LAStore,
    __FAStore,
    __DAStore,
    __AAStore,
    __BAStore,
    __CAStore,
    __SAStore,
    Pop,
    Pop2,
    Dup,
    DupX1,
    DupX2,
    Dup2,
    Dup2X1,
    Dup2X2,
    Swap,
    __IAdd,
    __LAdd,
    __FAdd,
    __DAdd,
    __ISub,
    __LSub,
    __FSub,
    __DSub,
    __IMul,
    __LMul,
    __FMul,
    __DMul,
    __IDiv,
    __LDiv,
    __FDiv,
    __DDiv,
    __IRem,
    __LRem,
    __FRem,
    __DRem,
    __INeg,
    __LNeg,
    __FNeg,
    __DNeg,
    __IShl,
    __LShl,
    __IShr,
    __LShr,
    __IUShr,
    __LUShr,
    __IAnd,
    __LAnd,
    __IOr,
    __LOr,
    __IXor,
    __LXor,
    __IInc,
    I2L,
    I2F,
    I2D,
    L2I,
    L2F,
    L2D,
    F2I,
    F2L,
    F2D,
    D2I,
    D2L,
    D2F,
    I2B,
    I2C,
    I2S,
    __LCmp,
    __FCmpL,
    __FCmpG,
    __DCmpL,
    __DCmpG,
    __IfEq,
    __IfNe,
    __IfLt,
    __IfGe,
    __IfGt,
    __IfLe,
    __IfICmpEq,
    __IfICmpNe,
    __IfICmpLt,
    __IfICmpGe,
    __IfICmpGt,
    __IfICmpLe,
    __IfACmpEq,
    __IfACmpNe,
    Goto,
    Jsr,
    Ret,
    __TableSwitch,
    __LookupSwitch,
    __IReturn,
    __LReturn,
    __FReturn,
    __DReturn,
    __AReturn,
    __Return,
    GetStatic,
    PutStatic,
    GetField,
    PutField,
    InvokeVirtual,
    InvokeSpecial,
    InvokeStatic,
    InvokeInterface,
    InvokeDynamic,
    __New,
    __NewArray,
    __ANewArray,
    ArrayLength,
    AThrow,
    CheckCast,
    InstanceOf,
    MonitorEnter,
    MonitorExit,
    MultiANewArray,
    __IfNull,
    __IfNonNull,
    __GotoW,
    __JsrW,
    Breakpoint,
    __ILoadW,
    __LLoadW,
    __FLoadW,
    __DLoadW,
    __ALoadW,
    __IStoreW,
    __LStoreW,
    __FStoreW,
    __DStoreW,
    __AStoreW,
    __IIncW,
    __RetW,
    Leave,
    EndFinally,
    Load,
    Store,
    LoadElement,
    StoreElement,
    Add,
    Sub,
    Mul,
    Div,
    Rem,
    Neg,
    Shl,
    Shr,
    UShr,
    And,
    Or,
    Not,
    Xor,
    Inc,
    CmpEq,
    CmpNe,
    CmpLt,
    CmpGe,
    CmpGt,
    CmpLe,
    IfTrue,
    Return,
    NewArray,
    LoadException,
    LogicalNot,
    LogicalAnd,
    LogicalOr,
    InitObject,
    InitArray,
    Switch,
    Wrap,
    Bind,
    TernaryOp,
    LoopOrSwitchBreak,
    LoopContinue,
    CompoundAssignment,
    PreIncrement,
    PostIncrement,
    Box,
    Unbox,
    DefaultValue;

    private static final OpCode[] STANDARD_CODES;

    public final String getName() {
        return StringUtilities.trimAndRemoveLeft(this.name().toLowerCase(), "__");
    }

    public final boolean isLoad() {
        switch (this) {
            case Load: 
            case Ret: 
            case Inc: {
                return true;
            }
        }
        return false;
    }

    public final boolean isFieldRead() {
        switch (this) {
            case GetStatic: 
            case GetField: {
                return true;
            }
        }
        return false;
    }

    public final boolean isFieldWrite() {
        switch (this) {
            case PutStatic: 
            case PutField: {
                return true;
            }
        }
        return false;
    }

    public final boolean isStore() {
        switch (this) {
            case Inc: 
            case Store: 
            case PreIncrement: 
            case PostIncrement: {
                return true;
            }
        }
        return false;
    }

    public final boolean isDup() {
        switch (this) {
            case Dup: 
            case DupX1: 
            case DupX2: 
            case Dup2: 
            case Dup2X1: 
            case Dup2X2: {
                return true;
            }
        }
        return false;
    }

    public final boolean isComparison() {
        switch (this) {
            case CmpEq: 
            case CmpNe: 
            case CmpLe: 
            case CmpGt: 
            case CmpGe: 
            case CmpLt: {
                return true;
            }
        }
        return false;
    }

    public final boolean isLogical() {
        switch (this) {
            case LogicalNot: 
            case LogicalAnd: 
            case LogicalOr: {
                return true;
            }
        }
        return false;
    }

    public final boolean isShortCircuiting() {
        switch (this) {
            case LogicalAnd: 
            case LogicalOr: {
                return true;
            }
        }
        return false;
    }

    public final boolean isWriteOperation() {
        switch (this) {
            case PutStatic: 
            case PutField: 
            case Store: 
            case StoreElement: {
                return true;
            }
        }
        return false;
    }

    public final AstCode reverse() {
        switch (this) {
            case CmpEq: {
                return CmpNe;
            }
            case CmpNe: {
                return CmpEq;
            }
            case CmpLe: {
                return CmpGt;
            }
            case CmpGt: {
                return CmpLe;
            }
            case CmpGe: {
                return CmpLt;
            }
            case CmpLt: {
                return CmpGe;
            }
            case LogicalAnd: {
                return LogicalOr;
            }
            case LogicalOr: {
                return LogicalAnd;
            }
        }
        return this;
    }

    public final boolean isConditionalControlFlow() {
        int ordinal = this.ordinal();
        if (ordinal < STANDARD_CODES.length) {
            OpCode standardCode = STANDARD_CODES[ordinal];
            return standardCode.isBranch() && !standardCode.isUnconditionalBranch();
        }
        return this == IfTrue;
    }

    public final boolean isUnconditionalControlFlow() {
        switch (this) {
            case LoopContinue: 
            case LoopOrSwitchBreak: 
            case Return: 
            case Leave: 
            case Switch: 
            case EndFinally: {
                return true;
            }
        }
        int ordinal = this.ordinal();
        if (ordinal < STANDARD_CODES.length) {
            OpCode standardCode = STANDARD_CODES[ordinal];
            return standardCode.isUnconditionalBranch();
        }
        return false;
    }

    public static boolean expandMacro(StrongBox<AstCode> code, StrongBox<Object> operand, MethodBody body, int offset) {
        AstCode op = code.get();
        switch (op) {
            case __IConstM1: {
                code.set((Object)LdC);
                operand.set(-1);
                return true;
            }
            case __IConst0: {
                code.set((Object)LdC);
                operand.set(0);
                return true;
            }
            case __IConst1: {
                code.set((Object)LdC);
                operand.set(1);
                return true;
            }
            case __IConst2: {
                code.set((Object)LdC);
                operand.set(2);
                return true;
            }
            case __IConst3: {
                code.set((Object)LdC);
                operand.set(3);
                return true;
            }
            case __IConst4: {
                code.set((Object)LdC);
                operand.set(4);
                return true;
            }
            case __IConst5: {
                code.set((Object)LdC);
                operand.set(5);
                return true;
            }
            case __LConst0: {
                code.set((Object)LdC);
                operand.set(0L);
                return true;
            }
            case __LConst1: {
                code.set((Object)LdC);
                operand.set(1L);
                return true;
            }
            case __FConst0: {
                code.set((Object)LdC);
                operand.set(Float.valueOf(0.0f));
                return true;
            }
            case __FConst1: {
                code.set((Object)LdC);
                operand.set(Float.valueOf(1.0f));
                return true;
            }
            case __FConst2: {
                code.set((Object)LdC);
                operand.set(Float.valueOf(2.0f));
                return true;
            }
            case __DConst0: {
                code.set((Object)LdC);
                operand.set(0.0);
                return true;
            }
            case __DConst1: {
                code.set((Object)LdC);
                operand.set(1.0);
                return true;
            }
            case __BIPush: 
            case __SIPush: {
                code.set((Object)LdC);
                operand.set(((Number)operand.get()).intValue());
                return true;
            }
            case __LdCW: 
            case __LdC2W: {
                code.set((Object)LdC);
                return true;
            }
            case __JsrW: {
                code.set((Object)Jsr);
                return true;
            }
            case __RetW: {
                code.set((Object)Ret);
                return true;
            }
            case __IInc: 
            case __IIncW: {
                code.set((Object)Inc);
                return true;
            }
            case __IReturn: 
            case __LReturn: 
            case __FReturn: 
            case __DReturn: 
            case __AReturn: 
            case __Return: {
                code.set((Object)Return);
                return true;
            }
            case __NewArray: 
            case __ANewArray: {
                code.set((Object)NewArray);
                return true;
            }
            case __ILoad: 
            case __LLoad: 
            case __FLoad: 
            case __DLoad: 
            case __ALoad: 
            case __ALoadW: 
            case __ILoadW: 
            case __FLoadW: 
            case __LLoadW: 
            case __DLoadW: {
                code.set((Object)Load);
                return true;
            }
            case __ILoad0: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ILoad1: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ILoad2: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ILoad3: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LLoad0: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LLoad1: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LLoad2: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LLoad3: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FLoad0: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FLoad1: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FLoad2: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FLoad3: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DLoad0: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DLoad1: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DLoad2: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DLoad3: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ALoad0: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ALoad1: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ALoad2: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __ALoad3: {
                code.set((Object)Load);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __IALoad: 
            case __LALoad: 
            case __FALoad: 
            case __DALoad: 
            case __AALoad: 
            case __BALoad: 
            case __CALoad: 
            case __SALoad: {
                code.set((Object)LoadElement);
                return true;
            }
            case __GotoW: {
                code.set((Object)Goto);
                return true;
            }
            case __IStore: 
            case __LStore: 
            case __FStore: 
            case __DStore: 
            case __AStore: 
            case __AStoreW: 
            case __IStoreW: 
            case __LStoreW: 
            case __FStoreW: 
            case __DStoreW: {
                code.set((Object)Store);
                return true;
            }
            case __IStore0: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __IStore1: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __IStore2: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __IStore3: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LStore0: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LStore1: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LStore2: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __LStore3: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FStore0: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FStore1: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FStore2: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __FStore3: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DStore0: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DStore1: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DStore2: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __DStore3: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __AStore0: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(0, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __AStore1: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(1, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __AStore2: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(2, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __AStore3: {
                code.set((Object)Store);
                operand.set(body.getVariables().reference(3, STANDARD_CODES[op.ordinal()], offset));
                return true;
            }
            case __IAStore: 
            case __LAStore: 
            case __FAStore: 
            case __DAStore: 
            case __AAStore: 
            case __BAStore: 
            case __CAStore: 
            case __SAStore: {
                code.set((Object)StoreElement);
                return true;
            }
            case __IAdd: 
            case __LAdd: 
            case __FAdd: 
            case __DAdd: {
                code.set((Object)Add);
                return true;
            }
            case __ISub: 
            case __LSub: 
            case __FSub: 
            case __DSub: {
                code.set((Object)Sub);
                return true;
            }
            case __IMul: 
            case __LMul: 
            case __FMul: 
            case __DMul: {
                code.set((Object)Mul);
                return true;
            }
            case __IDiv: 
            case __LDiv: 
            case __FDiv: 
            case __DDiv: {
                code.set((Object)Div);
                return true;
            }
            case __IRem: 
            case __LRem: 
            case __FRem: 
            case __DRem: {
                code.set((Object)Rem);
                return true;
            }
            case __INeg: 
            case __LNeg: 
            case __FNeg: 
            case __DNeg: {
                code.set((Object)Neg);
                return true;
            }
            case __IShl: 
            case __LShl: {
                code.set((Object)Shl);
                return true;
            }
            case __IShr: 
            case __LShr: {
                code.set((Object)Shr);
                return true;
            }
            case __IUShr: 
            case __LUShr: {
                code.set((Object)UShr);
                return true;
            }
            case __IAnd: 
            case __LAnd: {
                code.set((Object)And);
                return true;
            }
            case __IOr: 
            case __LOr: {
                code.set((Object)Or);
                return true;
            }
            case __IXor: 
            case __LXor: {
                code.set((Object)Xor);
                return true;
            }
            case __LookupSwitch: 
            case __TableSwitch: {
                code.set((Object)Switch);
                return true;
            }
        }
        return false;
    }

    static {
        STANDARD_CODES = OpCode.values();
    }
}

