/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import java.util.List;

public final class InsertOverrideAnnotationsTransform
extends ContextTrackingVisitor<Void> {
    private static final String OVERRIDE_ANNOTATION_NAME = "java/lang/Override";
    private final AstBuilder _astBuilder;

    public InsertOverrideAnnotationsTransform(DecompilerContext context) {
        super(context);
        this._astBuilder = context.getUserData(Keys.AST_BUILDER);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void _) {
        this.tryAddOverrideAnnotation(node);
        return (Void)super.visitMethodDeclaration(node, _);
    }

    private void tryAddOverrideAnnotation(MethodDeclaration node) {
        TypeReference annotationType;
        boolean foundOverride = false;
        for (Annotation annotation : node.getAnnotations()) {
            annotationType = annotation.getType().getUserData(Keys.TYPE_REFERENCE);
            if (!StringUtilities.equals(annotationType.getInternalName(), OVERRIDE_ANNOTATION_NAME)) continue;
            foundOverride = true;
            break;
        }
        if (foundOverride) {
            return;
        }
        final MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
        if (method.isStatic() || method.isConstructor() || method.isTypeInitializer()) {
            return;
        }
        TypeDefinition declaringType = method.getDeclaringType();
        if (declaringType.getCompilerMajorVersion() < CompilerTarget.JDK1_6.majorVersion) {
            return;
        }
        annotationType = new MetadataParser(declaringType).parseTypeDescriptor(OVERRIDE_ANNOTATION_NAME);
        List<MethodReference> candidates = MetadataHelper.findMethods(declaringType, (Predicate<? super MethodReference>)new Predicate<MethodReference>(){

            @Override
            public boolean test(MethodReference reference) {
                return StringUtilities.equals(reference.getName(), method.getName());
            }
        }, false, true);
        for (MethodReference candidate : candidates) {
            if (!MetadataHelper.isOverride(method, candidate)) continue;
            Annotation annotation = new Annotation();
            if (this._astBuilder != null) {
                annotation.setType(this._astBuilder.convertType(annotationType));
            } else {
                annotation.setType(new SimpleType(annotationType.getSimpleName()));
            }
            node.getAnnotations().add(annotation);
            break;
        }
    }
}

