/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.ir.attributes.InnerClassEntry;
import com.strobel.assembler.ir.attributes.InnerClassesAttribute;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.GenericParameterCollection;
import com.strobel.assembler.metadata.IClassSignature;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.assembler.metadata.signatures.BottomSignature;
import com.strobel.assembler.metadata.signatures.FieldTypeSignature;
import com.strobel.assembler.metadata.signatures.MetadataFactory;
import com.strobel.assembler.metadata.signatures.Reifier;
import com.strobel.assembler.metadata.signatures.SimpleClassTypeSignature;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class CoreMetadataFactory
implements MetadataFactory {
    private final TypeDefinition _owner;
    private final IMetadataResolver _resolver;
    private final IGenericContext _scope;
    private final Stack<GenericParameter> _tempScope;

    private CoreMetadataFactory(TypeDefinition owner, IMetadataResolver resolver, IGenericContext scope) {
        this._owner = owner;
        this._resolver = resolver;
        this._scope = scope;
        this._tempScope = new Stack();
    }

    public static CoreMetadataFactory make(TypeDefinition owner, IGenericContext scope) {
        return new CoreMetadataFactory(VerifyArgument.notNull(owner, "owner"), owner.getResolver(), scope);
    }

    public static CoreMetadataFactory make(IMetadataResolver resolver, IGenericContext scope) {
        return new CoreMetadataFactory(null, resolver, scope);
    }

    private IGenericContext getScope() {
        return this._scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericParameter makeTypeVariable(String name, FieldTypeSignature[] bounds) {
        GenericParameter genericParameter = new GenericParameter(name);
        if (ArrayUtilities.isNullOrEmpty(bounds)) {
            return genericParameter;
        }
        this._tempScope.push(genericParameter);
        try {
            TypeReference extendsBound = this.makeTypeBound(bounds);
            genericParameter.setExtendsBound(extendsBound);
            GenericParameter genericParameter2 = genericParameter;
            return genericParameter2;
        }
        finally {
            this._tempScope.pop();
        }
    }

    @Override
    public WildcardType makeWildcard(FieldTypeSignature superBound, FieldTypeSignature extendsBound) {
        if (superBound == null || superBound == BottomSignature.make()) {
            if (extendsBound == null || extendsBound instanceof SimpleClassTypeSignature && StringUtilities.equals("java.lang.Object", ((SimpleClassTypeSignature)extendsBound).getName())) {
                return WildcardType.unbounded();
            }
            return WildcardType.makeExtends(this.makeTypeBound(extendsBound));
        }
        return WildcardType.makeSuper(this.makeTypeBound(superBound));
    }

    protected TypeReference makeTypeBound(FieldTypeSignature ... bounds) {
        TypeReference baseType;
        Reifier reifier = null;
        if (ArrayUtilities.isNullOrEmpty(bounds)) {
            return null;
        }
        if (bounds[0] != BottomSignature.make()) {
            reifier = Reifier.make(this);
            bounds[0].accept(reifier);
            baseType = reifier.getResult();
            assert (baseType != null);
        } else {
            baseType = null;
        }
        if (bounds.length == 1) {
            return baseType;
        }
        if (reifier == null) {
            reifier = Reifier.make(this);
        }
        if (bounds.length == 2 && baseType == null) {
            bounds[1].accept(reifier);
            TypeReference singleInterface = reifier.getResult();
            assert (singleInterface != null);
            return singleInterface;
        }
        TypeReference[] it = new TypeReference[bounds.length - 1];
        for (int i = 0; i < it.length; ++i) {
            bounds[i + 1].accept(reifier);
            it[i] = reifier.getResult();
            assert (it[i] != null);
        }
        List<TypeReference> interfaceTypes = ArrayUtilities.asUnmodifiableList(it);
        return new CompoundTypeReference(baseType, interfaceTypes);
    }

    @Override
    public TypeReference makeParameterizedType(TypeReference declaration, TypeReference owner, TypeReference ... typeArguments) {
        if (typeArguments.length == 0) {
            return declaration;
        }
        return declaration.makeGenericType(typeArguments);
    }

    @Override
    public GenericParameter findTypeVariable(String name) {
        for (int i = this._tempScope.size() - 1; i >= 0; --i) {
            GenericParameter genericParameter = (GenericParameter)this._tempScope.get(i);
            if (genericParameter == null || !StringUtilities.equals(genericParameter.getName(), name)) continue;
            return genericParameter;
        }
        IGenericContext scope = this.getScope();
        if (scope != null) {
            return scope.findTypeVariable(name);
        }
        return null;
    }

    private InnerClassEntry findInnerClassEntry(String name) {
        if (this._owner == null) {
            return null;
        }
        String internalName = name.replace('.', '/');
        Object attribute = SourceAttribute.find("InnerClasses", this._owner.getSourceAttributes());
        if (attribute instanceof InnerClassesAttribute) {
            List<InnerClassEntry> entries = ((InnerClassesAttribute)attribute).getEntries();
            for (InnerClassEntry entry : entries) {
                if (!StringUtilities.equals(entry.getInnerClassName(), internalName)) continue;
                return entry;
            }
        }
        return null;
    }

    @Override
    public TypeReference makeNamedType(String name) {
        int packageEnd;
        int length = name.length();
        InnerClassEntry entry = this.findInnerClassEntry(name);
        if (entry != null) {
            TypeReference declaringType;
            String shortName;
            String innerClassName = entry.getInnerClassName();
            int packageEnd2 = innerClassName.lastIndexOf(47);
            String string = shortName = StringUtilities.isNullOrEmpty(entry.getShortName()) ? null : entry.getShortName();
            if (!StringUtilities.isNullOrEmpty(entry.getOuterClassName())) {
                declaringType = this.makeNamedType(entry.getOuterClassName().replace('/', '.'));
            } else {
                int lastDollarIndex = name.lastIndexOf(36);
                while (lastDollarIndex >= 1 && lastDollarIndex < length && name.charAt(lastDollarIndex - 1) == '$') {
                    if (lastDollarIndex > 1) {
                        lastDollarIndex = name.lastIndexOf(lastDollarIndex, lastDollarIndex - 2);
                        continue;
                    }
                    lastDollarIndex = -1;
                }
                if (lastDollarIndex == length - 1) {
                    lastDollarIndex = -1;
                }
                declaringType = lastDollarIndex < 0 ? (this._owner != null && this._owner.getCompilerTarget().compareTo(CompilerTarget.JDK1_4) < 0 ? this._owner : null) : this.makeNamedType(name.substring(0, lastDollarIndex).replace('/', '.'));
            }
            if (declaringType != null) {
                return new UnresolvedType(declaringType, packageEnd2 < 0 ? innerClassName : innerClassName.substring(packageEnd2 + 1), shortName);
            }
        }
        if ((packageEnd = name.lastIndexOf(46)) < 0) {
            return new UnresolvedType("", name, null);
        }
        return new UnresolvedType(packageEnd < 0 ? "" : name.substring(0, packageEnd), packageEnd < 0 ? name : name.substring(packageEnd + 1), null);
    }

    @Override
    public TypeReference makeArrayType(TypeReference componentType) {
        return componentType.makeArrayType();
    }

    @Override
    public TypeReference makeByte() {
        return BuiltinTypes.Byte;
    }

    @Override
    public TypeReference makeBoolean() {
        return BuiltinTypes.Boolean;
    }

    @Override
    public TypeReference makeShort() {
        return BuiltinTypes.Short;
    }

    @Override
    public TypeReference makeChar() {
        return BuiltinTypes.Character;
    }

    @Override
    public TypeReference makeInt() {
        return BuiltinTypes.Integer;
    }

    @Override
    public TypeReference makeLong() {
        return BuiltinTypes.Long;
    }

    @Override
    public TypeReference makeFloat() {
        return BuiltinTypes.Float;
    }

    @Override
    public TypeReference makeDouble() {
        return BuiltinTypes.Double;
    }

    @Override
    public TypeReference makeVoid() {
        return BuiltinTypes.Void;
    }

    @Override
    public IMethodSignature makeMethodSignature(TypeReference returnType, List<TypeReference> parameterTypes, List<GenericParameter> genericParameters, List<TypeReference> thrownTypes) {
        return new MethodSignature(parameterTypes, returnType, genericParameters, thrownTypes);
    }

    @Override
    public IClassSignature makeClassSignature(TypeReference baseType, List<TypeReference> interfaceTypes, List<GenericParameter> genericParameters) {
        return new ClassSignature(baseType, interfaceTypes, genericParameters);
    }

    private final class UnresolvedGenericType
    extends TypeReference
    implements IGenericInstance {
        private final TypeReference _genericDefinition;
        private final List<TypeReference> _typeParameters;
        private String _signature;

        UnresolvedGenericType(TypeReference genericDefinition, List<TypeReference> typeParameters) {
            this._genericDefinition = genericDefinition;
            this._typeParameters = typeParameters;
        }

        @Override
        public TypeReference getElementType() {
            return null;
        }

        @Override
        public <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
            return visitor.visitParameterizedType(this, parameter);
        }

        @Override
        public String getName() {
            return this._genericDefinition.getName();
        }

        @Override
        public String getPackageName() {
            return this._genericDefinition.getPackageName();
        }

        @Override
        public TypeReference getDeclaringType() {
            return this._genericDefinition.getDeclaringType();
        }

        @Override
        public String getSimpleName() {
            return this._genericDefinition.getSimpleName();
        }

        @Override
        public String getFullName() {
            return this._genericDefinition.getFullName();
        }

        @Override
        public String getInternalName() {
            return this._genericDefinition.getInternalName();
        }

        @Override
        public String getSignature() {
            if (this._signature == null) {
                this._signature = super.getSignature();
            }
            return this._signature;
        }

        @Override
        public String getErasedSignature() {
            return this._genericDefinition.getErasedSignature();
        }

        @Override
        public boolean isGenericDefinition() {
            return false;
        }

        @Override
        public boolean isGenericType() {
            return true;
        }

        @Override
        public List<GenericParameter> getGenericParameters() {
            TypeDefinition resolvedDefinition;
            if (!this._genericDefinition.isGenericDefinition() && (resolvedDefinition = this._genericDefinition.resolve()) != null) {
                return resolvedDefinition.getGenericParameters();
            }
            return this._genericDefinition.getGenericParameters();
        }

        @Override
        public boolean hasTypeArguments() {
            return true;
        }

        @Override
        public List<TypeReference> getTypeArguments() {
            return this._typeParameters;
        }

        @Override
        public IGenericParameterProvider getGenericDefinition() {
            return this._genericDefinition;
        }

        @Override
        public TypeReference getUnderlyingType() {
            return this._genericDefinition;
        }

        @Override
        public TypeDefinition resolve() {
            return CoreMetadataFactory.this._resolver.resolve(this);
        }

        @Override
        public FieldDefinition resolve(FieldReference field) {
            return CoreMetadataFactory.this._resolver.resolve(field);
        }

        @Override
        public MethodDefinition resolve(MethodReference method) {
            return CoreMetadataFactory.this._resolver.resolve(method);
        }

        @Override
        public TypeDefinition resolve(TypeReference type) {
            return CoreMetadataFactory.this._resolver.resolve(type);
        }
    }

    private final class UnresolvedType
    extends TypeReference {
        private final String _name;
        private final String _shortName;
        private final String _packageName;
        private final GenericParameterCollection _genericParameters;
        private String _fullName;
        private String _internalName;
        private String _signature;
        private String _erasedSignature;

        UnresolvedType(TypeReference declaringType, String name, String shortName) {
            this._name = VerifyArgument.notNull(name, "name");
            this._shortName = shortName;
            this.setDeclaringType(VerifyArgument.notNull(declaringType, "declaringType"));
            this._packageName = declaringType.getPackageName();
            this._genericParameters = new GenericParameterCollection(this);
            this._genericParameters.freeze();
        }

        UnresolvedType(String packageName, String name, String shortName) {
            this._packageName = VerifyArgument.notNull(packageName, "packageName");
            this._name = VerifyArgument.notNull(name, "name");
            this._shortName = shortName;
            this._genericParameters = new GenericParameterCollection(this);
            this._genericParameters.freeze();
        }

        UnresolvedType(TypeReference declaringType, String name, String shortName, List<GenericParameter> genericParameters) {
            this._name = VerifyArgument.notNull(name, "name");
            this._shortName = shortName;
            this.setDeclaringType(VerifyArgument.notNull(declaringType, "declaringType"));
            this._packageName = declaringType.getPackageName();
            this._genericParameters = new GenericParameterCollection(this);
            for (GenericParameter genericParameter : genericParameters) {
                this._genericParameters.add(genericParameter);
            }
            this._genericParameters.freeze();
        }

        UnresolvedType(String packageName, String name, String shortName, List<GenericParameter> genericParameters) {
            this._packageName = VerifyArgument.notNull(packageName, "packageName");
            this._name = VerifyArgument.notNull(name, "name");
            this._shortName = shortName;
            this._genericParameters = new GenericParameterCollection(this);
            for (GenericParameter genericParameter : genericParameters) {
                this._genericParameters.add(genericParameter);
            }
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getPackageName() {
            return this._packageName;
        }

        @Override
        public String getFullName() {
            if (this._fullName == null) {
                this._fullName = super.getFullName();
            }
            return this._fullName;
        }

        @Override
        public String getErasedSignature() {
            if (this._erasedSignature == null) {
                this._erasedSignature = super.getErasedSignature();
            }
            return this._erasedSignature;
        }

        @Override
        public String getSignature() {
            if (this._signature == null) {
                this._signature = super.getSignature();
            }
            return this._signature;
        }

        @Override
        public String getInternalName() {
            if (this._internalName == null) {
                this._internalName = super.getInternalName();
            }
            return this._internalName;
        }

        @Override
        public <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
            return visitor.visitClassType(this, parameter);
        }

        @Override
        public String getSimpleName() {
            return this._shortName != null ? this._shortName : this._name;
        }

        @Override
        public boolean isGenericDefinition() {
            return this.hasGenericParameters();
        }

        @Override
        public List<GenericParameter> getGenericParameters() {
            return this._genericParameters;
        }

        @Override
        public TypeReference makeGenericType(TypeReference ... typeArguments) {
            VerifyArgument.noNullElementsAndNotEmpty(typeArguments, "typeArguments");
            TypeReference[] adjustedTypeArguments = Arrays.copyOf(typeArguments, typeArguments.length);
            if (UnresolvedType.checkRecursive(this, ArrayUtilities.asUnmodifiableList(adjustedTypeArguments))) {
                for (int i = 0; i < adjustedTypeArguments.length; ++i) {
                    TypeReference t = adjustedTypeArguments[i];
                    adjustedTypeArguments[i] = t.isGenericType() ? t.getRawType() : t;
                }
            }
            return new UnresolvedGenericType(this, ArrayUtilities.asUnmodifiableList(adjustedTypeArguments));
        }

        @Override
        public TypeDefinition resolve() {
            return CoreMetadataFactory.this._resolver.resolve(this);
        }

        @Override
        public FieldDefinition resolve(FieldReference field) {
            return CoreMetadataFactory.this._resolver.resolve(field);
        }

        @Override
        public MethodDefinition resolve(MethodReference method) {
            return CoreMetadataFactory.this._resolver.resolve(method);
        }

        @Override
        public TypeDefinition resolve(TypeReference type) {
            return CoreMetadataFactory.this._resolver.resolve(type);
        }
    }

    private static final class MethodSignature
    implements IMethodSignature {
        private final List<ParameterDefinition> _parameters;
        private final TypeReference _returnType;
        private final List<GenericParameter> _genericParameters;
        private final List<TypeReference> _thrownTypes;

        MethodSignature(List<TypeReference> parameterTypes, TypeReference returnType, List<GenericParameter> genericParameters, List<TypeReference> thrownTypes) {
            VerifyArgument.notNull(parameterTypes, "parameterTypes");
            VerifyArgument.notNull(returnType, "returnType");
            VerifyArgument.notNull(genericParameters, "genericParameters");
            VerifyArgument.notNull(thrownTypes, "thrownTypes");
            ParameterDefinition[] parameters = new ParameterDefinition[parameterTypes.size()];
            int i = 0;
            int slot = 0;
            int n = parameters.length;
            while (i < n) {
                TypeReference parameterType = parameterTypes.get(i);
                parameters[i] = new ParameterDefinition(slot, parameterType);
                if (parameterType.getSimpleType().isDoubleWord()) {
                    ++slot;
                }
                ++i;
                ++slot;
            }
            this._parameters = ArrayUtilities.asUnmodifiableList(parameters);
            this._returnType = returnType;
            this._genericParameters = genericParameters;
            this._thrownTypes = thrownTypes;
        }

        @Override
        public boolean hasParameters() {
            return !this._parameters.isEmpty();
        }

        @Override
        public List<ParameterDefinition> getParameters() {
            return this._parameters;
        }

        @Override
        public TypeReference getReturnType() {
            return this._returnType;
        }

        @Override
        public List<TypeReference> getThrownTypes() {
            return this._thrownTypes;
        }

        @Override
        public boolean hasGenericParameters() {
            return !this._genericParameters.isEmpty();
        }

        @Override
        public boolean isGenericDefinition() {
            return !this._genericParameters.isEmpty();
        }

        @Override
        public List<GenericParameter> getGenericParameters() {
            return this._genericParameters;
        }

        @Override
        public GenericParameter findTypeVariable(String name) {
            for (GenericParameter genericParameter : this.getGenericParameters()) {
                if (!StringUtilities.equals(genericParameter.getName(), name)) continue;
                return genericParameter;
            }
            return null;
        }
    }

    private static final class ClassSignature
    implements IClassSignature {
        private final TypeReference _baseType;
        private final List<TypeReference> _interfaceTypes;
        private final List<GenericParameter> _genericParameters;

        private ClassSignature(TypeReference baseType, List<TypeReference> interfaceTypes, List<GenericParameter> genericParameters) {
            this._baseType = VerifyArgument.notNull(baseType, "baseType");
            this._interfaceTypes = VerifyArgument.noNullElements(interfaceTypes, "interfaceTypes");
            this._genericParameters = VerifyArgument.noNullElements(genericParameters, "genericParameters");
        }

        @Override
        public TypeReference getBaseType() {
            return this._baseType;
        }

        @Override
        public List<TypeReference> getExplicitInterfaces() {
            return this._interfaceTypes;
        }

        @Override
        public boolean hasGenericParameters() {
            return !this._genericParameters.isEmpty();
        }

        @Override
        public boolean isGenericDefinition() {
            return false;
        }

        @Override
        public List<GenericParameter> getGenericParameters() {
            return this._genericParameters;
        }
    }
}

