/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.GenericParameterType;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.util.List;

public final class GenericParameter
extends TypeDefinition {
    private int _position;
    private GenericParameterType _type = GenericParameterType.Type;
    private IGenericParameterProvider _owner;
    private TypeReference _extendsBound;

    public GenericParameter(String name) {
        this._extendsBound = BuiltinTypes.Object;
        this.setName(name != null ? name : "");
    }

    public GenericParameter(String name, TypeReference extendsBound) {
        this._extendsBound = VerifyArgument.notNull(extendsBound, "extendsBound");
        this.setName(name != null ? name : "");
    }

    protected final void setPosition(int position) {
        this._position = position;
    }

    protected final void setOwner(IGenericParameterProvider owner) {
        this._owner = owner;
        this._type = owner instanceof MethodReference ? GenericParameterType.Method : GenericParameterType.Type;
    }

    protected final void setExtendsBound(TypeReference extendsBound) {
        this._extendsBound = extendsBound;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (!StringUtilities.isNullOrEmpty(name)) {
            return name;
        }
        return "T" + this._position;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getInternalName() {
        return this.getName();
    }

    @Override
    public TypeReference getUnderlyingType() {
        TypeReference extendsBound = this.getExtendsBound();
        return extendsBound != null ? extendsBound : BuiltinTypes.Object;
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitGenericParameter(this, parameter);
    }

    @Override
    public boolean isUnbounded() {
        return !this.hasExtendsBound();
    }

    @Override
    public boolean isGenericParameter() {
        return true;
    }

    @Override
    public boolean containsGenericParameters() {
        return true;
    }

    @Override
    public TypeReference getDeclaringType() {
        IGenericParameterProvider owner = this._owner;
        if (owner instanceof TypeReference) {
            return (TypeReference)owner;
        }
        return null;
    }

    public int getPosition() {
        return this._position;
    }

    public GenericParameterType getType() {
        return this._type;
    }

    public IGenericParameterProvider getOwner() {
        return this._owner;
    }

    @Override
    public boolean hasExtendsBound() {
        return this._extendsBound != null && !MetadataResolver.areEquivalent(this._extendsBound, BuiltinTypes.Object);
    }

    @Override
    public TypeReference getExtendsBound() {
        return this._extendsBound;
    }

    @Override
    public boolean hasAnnotations() {
        return !this.getAnnotations().isEmpty();
    }

    @Override
    public TypeDefinition resolve() {
        TypeDefinition resolvedOwner;
        if (this._owner instanceof TypeReference && !(this._owner instanceof TypeDefinition) && (resolvedOwner = ((TypeReference)this._owner).resolve()) != null) {
            List<GenericParameter> genericParameters = resolvedOwner.getGenericParameters();
            if (this._position >= 0 && this._position < genericParameters.size()) {
                return genericParameters.get(this._position);
            }
        }
        return null;
    }

    @Override
    protected StringBuilder appendDescription(StringBuilder sb) {
        sb.append(this.getFullName());
        TypeReference upperBound = this.getExtendsBound();
        if (upperBound != null && !upperBound.equals(BuiltinTypes.Object)) {
            sb.append(" extends ");
            if (upperBound.isGenericParameter() || upperBound.equals(this.getDeclaringType())) {
                return sb.append(upperBound.getFullName());
            }
            return upperBound.appendErasedDescription(sb);
        }
        return sb;
    }

    @Override
    protected StringBuilder appendBriefDescription(StringBuilder sb) {
        sb.append(this.getFullName());
        TypeReference upperBound = this.getExtendsBound();
        if (upperBound != null && !upperBound.equals(BuiltinTypes.Object)) {
            sb.append(" extends ");
            if (upperBound.isGenericParameter() || upperBound.equals(this.getDeclaringType())) {
                return sb.append(upperBound.getName());
            }
            return upperBound.appendErasedDescription(sb);
        }
        return sb;
    }

    @Override
    protected StringBuilder appendErasedDescription(StringBuilder sb) {
        return this.getExtendsBound().appendErasedDescription(sb);
    }

    @Override
    protected StringBuilder appendSignature(StringBuilder sb) {
        return sb.append('T').append(this.getName()).append(';');
    }

    @Override
    protected StringBuilder appendErasedSignature(StringBuilder sb) {
        return this.getExtendsBound().appendErasedSignature(sb);
    }

    @Override
    protected StringBuilder appendSimpleDescription(StringBuilder sb) {
        sb.append(this.getFullName());
        TypeReference upperBound = this.getExtendsBound();
        if (upperBound != null && !upperBound.equals(BuiltinTypes.Object)) {
            sb.append(" extends ");
            if (upperBound.isGenericParameter() || upperBound.equals(this.getOwner())) {
                return sb.append(upperBound.getSimpleName());
            }
            return upperBound.appendSimpleDescription(sb);
        }
        return sb;
    }
}

