/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.service.indexer;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.TypePath;
import groovyjarjarasm.asm.signature.SignatureReader;
import groovyjarjarasm.asm.signature.SignatureVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jd.gui.api.API;
import jd.gui.api.model.Container;
import jd.gui.api.model.Indexes;
import jd.gui.spi.Indexer;

public class ClassFileIndexerProvider
implements Indexer {
    protected Set<String> typeDeclarationSet = new HashSet<String>();
    protected Set<String> constructorDeclarationSet = new HashSet<String>();
    protected Set<String> methodDeclarationSet = new HashSet<String>();
    protected Set<String> fieldDeclarationSet = new HashSet<String>();
    protected Set<String> typeReferenceSet = new HashSet<String>();
    protected Set<String> constructorReferenceSet = new HashSet<String>();
    protected Set<String> methodReferenceSet = new HashSet<String>();
    protected Set<String> fieldReferenceSet = new HashSet<String>();
    protected Set<String> stringSet = new HashSet<String>();
    protected Set<String> superTypeNameSet = new HashSet<String>();
    protected Set<String> descriptorSet = new HashSet<String>();
    protected ClassIndexer classIndexer = new ClassIndexer(this.typeDeclarationSet, this.constructorDeclarationSet, this.methodDeclarationSet, this.fieldDeclarationSet, this.typeReferenceSet, this.superTypeNameSet, this.descriptorSet);
    protected SignatureIndexer signatureIndexer = new SignatureIndexer(this.typeReferenceSet);
    protected String[] types = new String[]{"*:file:*.class"};

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public Pattern getPathPattern() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(API api, Container.Entry entry, Indexes indexes) {
        this.typeDeclarationSet.clear();
        this.constructorDeclarationSet.clear();
        this.methodDeclarationSet.clear();
        this.fieldDeclarationSet.clear();
        this.typeReferenceSet.clear();
        this.constructorReferenceSet.clear();
        this.methodReferenceSet.clear();
        this.fieldReferenceSet.clear();
        this.stringSet.clear();
        this.superTypeNameSet.clear();
        this.descriptorSet.clear();
        InputStream inputStream = null;
        try {
            inputStream = entry.getInputStream();
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept(this.classIndexer, 7);
            for (String descriptor : this.descriptorSet) {
                new SignatureReader(descriptor).accept(this.signatureIndexer);
            }
            char[] buffer = new char[classReader.getMaxStringLength()];
            block18: for (int i = classReader.getItemCount() - 1; i > 0; --i) {
                int startIndex = classReader.getItem(i);
                if (startIndex == 0) continue;
                int tag = classReader.readByte(startIndex - 1);
                switch (tag) {
                    case 7: {
                        String className = classReader.readUTF8(startIndex, buffer);
                        if (className.startsWith("[")) {
                            new SignatureReader(className).acceptType(this.signatureIndexer);
                            continue block18;
                        }
                        this.typeReferenceSet.add(className);
                        continue block18;
                    }
                    case 8: {
                        String str = classReader.readUTF8(startIndex, buffer);
                        this.stringSet.add(str);
                        continue block18;
                    }
                    case 9: {
                        int nameAndTypeItem = classReader.readUnsignedShort(startIndex + 2);
                        int nameAndTypeIndex = classReader.getItem(nameAndTypeItem);
                        tag = classReader.readByte(nameAndTypeIndex - 1);
                        if (tag != 12) continue block18;
                        String fieldName = classReader.readUTF8(nameAndTypeIndex, buffer);
                        this.fieldReferenceSet.add(fieldName);
                        continue block18;
                    }
                    case 10: 
                    case 11: {
                        String className;
                        int nameAndTypeItem = classReader.readUnsignedShort(startIndex + 2);
                        int nameAndTypeIndex = classReader.getItem(nameAndTypeItem);
                        tag = classReader.readByte(nameAndTypeIndex - 1);
                        if (tag != 12) continue block18;
                        String methodName = classReader.readUTF8(nameAndTypeIndex, buffer);
                        if ("<init>".equals(methodName)) {
                            int classItem = classReader.readUnsignedShort(startIndex);
                            int classIndex = classReader.getItem(classItem);
                            className = classReader.readUTF8(classIndex, buffer);
                            this.constructorReferenceSet.add(className);
                            continue block18;
                        }
                        this.methodReferenceSet.add(methodName);
                    }
                }
            }
            String typeName = this.classIndexer.name;
            ClassFileIndexerProvider.addToIndex(indexes, "typeDeclarations", this.typeDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "constructorDeclarations", this.constructorDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "methodDeclarations", this.methodDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "fieldDeclarations", this.fieldDeclarationSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "typeReferences", this.typeReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "constructorReferences", this.constructorReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "methodReferences", this.methodReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "fieldReferences", this.fieldReferenceSet, entry);
            ClassFileIndexerProvider.addToIndex(indexes, "strings", this.stringSet, entry);
            if (this.superTypeNameSet.size() > 0) {
                Map<String, Collection> index = indexes.getIndex("subTypeNames");
                for (String superTypeName : this.superTypeNameSet) {
                    index.get(superTypeName).add(typeName);
                }
            }
        }
        catch (Exception ignore) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected static void addToIndex(Indexes indexes, String indexName, Set<String> set, Container.Entry entry) {
        if (set.size() > 0) {
            Map<String, Collection> index = indexes.getIndex(indexName);
            for (String key : set) {
                index.get(key).add(entry);
            }
        }
    }

    protected static class MethodIndexer
    extends MethodVisitor {
        protected Set<String> descriptorSet;
        protected AnnotationIndexer annotationIndexer;

        public MethodIndexer(Set<String> descriptorSet, AnnotationIndexer annotationIndexer) {
            super(327680);
            this.descriptorSet = descriptorSet;
            this.annotationIndexer = annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }
    }

    protected static class FieldIndexer
    extends FieldVisitor {
        protected Set<String> descriptorSet;
        protected AnnotationIndexer annotationIndexer;

        public FieldIndexer(Set<String> descriptorSet, AnnotationIndexer annotationInexer) {
            super(327680);
            this.descriptorSet = descriptorSet;
            this.annotationIndexer = annotationInexer;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }
    }

    protected static class AnnotationIndexer
    extends AnnotationVisitor {
        protected Set<String> descriptorSet;

        public AnnotationIndexer(Set<String> descriptorSet) {
            super(327680);
            this.descriptorSet = descriptorSet;
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.descriptorSet.add(desc);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.descriptorSet.add(desc);
            return this;
        }
    }

    protected static class SignatureIndexer
    extends SignatureVisitor {
        protected Set<String> typeReferenceSet;

        SignatureIndexer(Set<String> typeReferenceSet) {
            super(327680);
            this.typeReferenceSet = typeReferenceSet;
        }

        @Override
        public void visitClassType(String name) {
            this.typeReferenceSet.add(name);
        }
    }

    protected static class ClassIndexer
    extends ClassVisitor {
        protected Set<String> typeDeclarationSet;
        protected Set<String> constructorDeclarationSet;
        protected Set<String> methodDeclarationSet;
        protected Set<String> fieldDeclarationSet;
        protected Set<String> typeReferenceSet;
        protected Set<String> superTypeNameSet;
        protected Set<String> descriptorSet;
        protected AnnotationIndexer annotationIndexer;
        protected FieldIndexer fieldIndexer;
        protected MethodIndexer methodIndexer;
        protected String name;

        public ClassIndexer(Set<String> typeDeclarationSet, Set<String> constructorDeclarationSet, Set<String> methodDeclarationSet, Set<String> fieldDeclarationSet, Set<String> typeReferenceSet, Set<String> superTypeNameSet, Set<String> descriptorSet) {
            super(327680);
            this.typeDeclarationSet = typeDeclarationSet;
            this.constructorDeclarationSet = constructorDeclarationSet;
            this.methodDeclarationSet = methodDeclarationSet;
            this.fieldDeclarationSet = fieldDeclarationSet;
            this.typeReferenceSet = typeReferenceSet;
            this.superTypeNameSet = superTypeNameSet;
            this.descriptorSet = descriptorSet;
            this.annotationIndexer = new AnnotationIndexer(descriptorSet);
            this.fieldIndexer = new FieldIndexer(descriptorSet, this.annotationIndexer);
            this.methodIndexer = new MethodIndexer(descriptorSet, this.annotationIndexer);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            this.typeDeclarationSet.add(name);
            this.superTypeNameSet.add(superName);
            if (interfaces != null) {
                for (int i = interfaces.length - 1; i >= 0; --i) {
                    this.superTypeNameSet.add(interfaces[i]);
                }
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.fieldDeclarationSet.add(name);
            this.descriptorSet.add(signature == null ? desc : signature);
            return this.fieldIndexer;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<init>".equals(name)) {
                this.constructorDeclarationSet.add(this.name);
            } else if (!"<clinit>".equals(name)) {
                this.methodDeclarationSet.add(name);
            }
            this.descriptorSet.add(signature == null ? desc : signature);
            if (exceptions != null) {
                for (int i = exceptions.length - 1; i >= 0; --i) {
                    this.typeReferenceSet.add(exceptions[i]);
                }
            }
            return this.methodIndexer;
        }
    }
}

