/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.service.type;

import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.tree.ClassNode;
import groovyjarjarasm.asm.tree.FieldNode;
import groovyjarjarasm.asm.tree.InnerClassNode;
import groovyjarjarasm.asm.tree.MethodNode;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jd.gui.api.API;
import jd.gui.api.model.Container;
import jd.gui.api.model.Type;
import jd.gui.spi.TypeFactory;

public class ClassFileTypeFactoryProvider
implements TypeFactory {
    protected String[] types = new String[]{"*:file:*.class"};

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public Pattern getPathPattern() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Type make(API api, Container.Entry entry, String fragment) {
        try (InputStream is = entry.getInputStream();){
            ClassReader classReader = new ClassReader(is);
            if (fragment != null && fragment.length() > 0) {
                int index = fragment.indexOf(45);
                if (index != -1) {
                    fragment = fragment.substring(0, index);
                }
                if (!classReader.getClassName().equals(fragment)) {
                    String entryTypePath = classReader.getClassName() + ".class";
                    String fragmentTypePath = fragment + ".class";
                    while (true) {
                        if (entry.getPath().endsWith(entryTypePath)) {
                            Throwable throwable;
                            String pathToFound = entry.getPath().substring(0, entry.getPath().length() - entryTypePath.length()) + fragmentTypePath;
                            Container.Entry entryFound = null;
                            for (Container.Entry e : entry.getParent().getChildren()) {
                                if (!e.getPath().equals(pathToFound)) continue;
                                entryFound = e;
                                break;
                            }
                            if (entryFound == null) {
                                Iterator<Container.Entry> i$ = null;
                                return i$;
                            }
                            entry = entryFound;
                            try {
                                throwable = null;
                                try (InputStream is2 = entry.getInputStream();){
                                    classReader = new ClassReader(is2);
                                    break;
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                            }
                            catch (IOException ignore) {
                                throwable = null;
                                if (is == null) return throwable;
                                if (var5_6 == null) {
                                    is.close();
                                    return throwable;
                                }
                                try {
                                    is.close();
                                    return throwable;
                                }
                                catch (Throwable x2) {
                                    var5_6.addSuppressed(x2);
                                    return throwable;
                                }
                            }
                        }
                        int firstPackageSeparatorIndex = entryTypePath.indexOf(47);
                        if (firstPackageSeparatorIndex == -1) {
                            Type type = null;
                            return type;
                        }
                        entryTypePath = entryTypePath.substring(firstPackageSeparatorIndex + 1);
                        fragmentTypePath = fragmentTypePath.substring(fragmentTypePath.indexOf(47) + 1);
                    }
                }
            }
            JavaType javaType = new JavaType(entry, classReader);
            return javaType;
        }
        catch (IOException ignore) {
            return null;
        }
    }

    static {
        JavaType.class.getName();
    }

    static class JavaType
    implements Type {
        ClassNode classNode = new ClassNode();
        Container.Entry entry;
        int access;
        String name;
        String shortName;
        String superName;
        String outerName;
        String displayTypeName;
        String displayInnerTypeName;
        String displayPackageName;
        List<Type> innerTypes;
        List<Type.Field> fields;
        List<Type.Method> methods;
        protected static final ImageIcon abstractOverlayIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/abstract_ovr.png"));
        protected static final ImageIcon finalOverlayIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/final_ovr.png"));
        protected static final ImageIcon staticOverlayIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/static_ovr.png"));
        protected static final ImageIcon classIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/class_default_obj.png"));
        protected static final ImageIcon publicClassIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/class_obj.png"));
        protected static final ImageIcon protectedClassIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/class_protected_obj.png"));
        protected static final ImageIcon privateClassIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/class_private_obj.png"));
        protected static final ImageIcon interfaceIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/int_default_obj.png"));
        protected static final ImageIcon publicInterfaceIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/int_obj.png"));
        protected static final ImageIcon protectedInterfaceIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/int_protected_obj.png"));
        protected static final ImageIcon privateInterfaceIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/int_private_obj.png"));
        protected static final ImageIcon annotationIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/annotation_obj.png"));
        protected static final ImageIcon enumIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/enum_obj.png"));
        protected static final ImageIcon fieldIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/field_default_obj.png"));
        protected static final ImageIcon publicFieldIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/field_public_obj.png"));
        protected static final ImageIcon protectedFieldIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/field_protected_obj.png"));
        protected static final ImageIcon privateFieldIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/field_private_obj.png"));
        protected static final ImageIcon methodIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/methdef_obj.png"));
        protected static final ImageIcon publicMethodIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/methpub_obj.png"));
        protected static final ImageIcon protedtedMethodIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/methpro_obj.png"));
        protected static final ImageIcon privateMethodIcon = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("images/methpri_obj.png"));
        protected static final ImageIcon[] defaultClassIcons = new ImageIcon[]{classIcon, publicClassIcon, protectedClassIcon, privateClassIcon};
        protected static final ImageIcon[] defaultInterfaceIcons = new ImageIcon[]{interfaceIcon, publicInterfaceIcon, protectedInterfaceIcon, privateInterfaceIcon};
        protected static final ImageIcon[] defaultFieldIcons = new ImageIcon[]{fieldIcon, publicFieldIcon, protectedFieldIcon, privateFieldIcon};
        protected static final ImageIcon[] defaultMethodIcons = new ImageIcon[]{methodIcon, publicMethodIcon, protedtedMethodIcon, privateMethodIcon};
        protected static final ImageIcon[] staticClassIcons = JavaType.mergeIcons(defaultClassIcons, staticOverlayIcon, 100, 0);
        protected static final ImageIcon[] staticInterfaceIcons = JavaType.mergeIcons(defaultInterfaceIcons, staticOverlayIcon, 100, 0);
        protected static final ImageIcon[] staticFieldIcons = JavaType.mergeIcons(defaultFieldIcons, staticOverlayIcon, 100, 0);
        protected static final ImageIcon[] staticMethodIcons = JavaType.mergeIcons(defaultMethodIcons, staticOverlayIcon, 100, 0);
        protected static final ImageIcon[] finalStaticClassIcons = JavaType.mergeIcons(staticClassIcons, finalOverlayIcon, 0, 0);
        protected static final ImageIcon[] finalStaticInterfaceIcons = JavaType.mergeIcons(staticInterfaceIcons, finalOverlayIcon, 0, 0);
        protected static final ImageIcon[] finalStaticFieldIcons = JavaType.mergeIcons(staticFieldIcons, finalOverlayIcon, 0, 0);
        protected static final ImageIcon[] finalStaticMethodIcons = JavaType.mergeIcons(staticMethodIcons, finalOverlayIcon, 0, 0);
        protected static final ImageIcon[] classIcons = JavaType.mergeIcons(finalStaticClassIcons, abstractOverlayIcon, 0, 100);
        protected static final ImageIcon[] interfaceIcons = JavaType.mergeIcons(finalStaticInterfaceIcons, abstractOverlayIcon, 0, 100);
        protected static final ImageIcon[] fieldIcons = JavaType.mergeIcons(finalStaticFieldIcons, abstractOverlayIcon, 0, 100);
        protected static final ImageIcon[] methodIcons = JavaType.mergeIcons(finalStaticMethodIcons, abstractOverlayIcon, 0, 100);

        JavaType(Container.Entry entry, ClassReader classReader) {
            int lastPackageSeparatorIndex;
            int indexSeparator;
            this.entry = entry;
            classReader.accept(this.classNode, 7);
            this.access = this.classNode.access;
            this.name = this.classNode.name;
            this.superName = (this.access & 0x200) != 0 && "java/lang/Object".equals(this.classNode.superName) ? null : this.classNode.superName;
            this.outerName = null;
            this.displayInnerTypeName = null;
            int indexDollar = this.name.lastIndexOf(36);
            if (indexDollar != -1 && indexDollar > (indexSeparator = this.name.lastIndexOf(47))) {
                for (InnerClassNode innerClassNode : this.classNode.innerClasses) {
                    if (!this.name.equals(innerClassNode.name) || innerClassNode.outerName == null) continue;
                    this.outerName = innerClassNode.outerName;
                    this.displayInnerTypeName = this.name.substring(this.outerName.length() + 1);
                }
            }
            if ((lastPackageSeparatorIndex = this.name.lastIndexOf(47)) == -1) {
                this.displayPackageName = "";
                this.shortName = this.name;
                this.displayTypeName = this.outerName != null ? null : this.shortName;
            } else {
                this.displayPackageName = this.name.substring(0, lastPackageSeparatorIndex).replace('/', '.');
                this.shortName = this.name.substring(lastPackageSeparatorIndex + 1);
                this.displayTypeName = this.outerName != null ? null : this.shortName;
            }
            this.innerTypes = null;
            this.fields = null;
            this.methods = null;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getSuperName() {
            return this.superName;
        }

        @Override
        public String getOuterName() {
            return this.outerName;
        }

        public Container.Entry getOuterEntry() {
            return this.outerName == null ? null : this.getEntry(this.outerName);
        }

        @Override
        public String getDisplayPackageName() {
            return this.displayPackageName;
        }

        @Override
        public String getDisplayTypeName() {
            if (this.displayTypeName == null) {
                this.displayTypeName = this.getDisplayTypeName(this.outerName, this.displayPackageName.length()) + '.' + this.displayInnerTypeName;
            }
            return this.displayTypeName;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String getDisplayTypeName(String name, int packageLength) {
            String string;
            Container.Entry outerEntry;
            int indexDollar = name.lastIndexOf(36);
            if (indexDollar > packageLength && (outerEntry = this.getEntry(name)) != null) {
                try (InputStream is = outerEntry.getInputStream();){
                    ClassReader classReader = new ClassReader(is);
                    ClassNode classNode = new ClassNode();
                    classReader.accept(classNode, 7);
                    for (InnerClassNode innerClassNode : classNode.innerClasses) {
                        if (!name.equals(innerClassNode.name)) continue;
                        String string2 = this.getDisplayTypeName(innerClassNode.outerName, packageLength) + '.' + innerClassNode.innerName;
                        return string2;
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (packageLength > 0) {
                string = name.substring(packageLength + 1);
                return string;
            }
            string = name;
            return string;
        }

        @Override
        public String getDisplayInnerTypeName() {
            return this.displayInnerTypeName;
        }

        @Override
        public Icon getIcon() {
            return JavaType.getIcon(this.access);
        }

        public List<Type> getInnerTypes() {
            if (this.innerTypes == null) {
                this.innerTypes = new ArrayList<Type>(this.classNode.innerClasses.size());
                for (InnerClassNode innerClassNode : this.classNode.innerClasses) {
                    Container.Entry innerEntry;
                    if ((innerClassNode.access & 0x1040) != 0 || !this.name.equals(innerClassNode.outerName) || (innerEntry = this.getEntry(innerClassNode.name)) == null) continue;
                    try {
                        InputStream is = innerEntry.getInputStream();
                        Throwable throwable = null;
                        try {
                            ClassReader classReader = new ClassReader(is);
                            this.innerTypes.add(new JavaType(innerEntry, classReader));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    catch (IOException ignore) {}
                }
            }
            return this.innerTypes;
        }

        protected Container.Entry getEntry(String typeName) {
            String pathToFound = typeName + ".class";
            for (Container.Entry e : this.entry.getParent().getChildren()) {
                if (!e.getPath().equals(pathToFound)) continue;
                return e;
            }
            return null;
        }

        public List<Type.Field> getFields() {
            if (this.fields == null) {
                this.fields = new ArrayList<Type.Field>(this.classNode.fields.size());
                for (final FieldNode fieldNode : this.classNode.fields) {
                    if ((fieldNode.access & 0x5000) != 0) continue;
                    this.fields.add(new Type.Field(){

                        @Override
                        public int getFlags() {
                            return fieldNode.access;
                        }

                        @Override
                        public String getName() {
                            return fieldNode.name;
                        }

                        @Override
                        public String getDescriptor() {
                            return fieldNode.desc;
                        }

                        @Override
                        public Icon getIcon() {
                            return fieldIcons[JavaType.accessToIndex(fieldNode.access)];
                        }
                    });
                }
            }
            return this.fields;
        }

        public List<Type.Method> getMethods() {
            if (this.methods == null) {
                this.methods = new ArrayList<Type.Method>(this.classNode.methods.size());
                for (final MethodNode methodNode : this.classNode.methods) {
                    if ((methodNode.access & 0x5040) != 0) continue;
                    this.methods.add(new Type.Method(){

                        @Override
                        public int getFlags() {
                            return methodNode.access;
                        }

                        @Override
                        public String getName() {
                            return methodNode.name;
                        }

                        @Override
                        public String getDescriptor() {
                            return methodNode.desc;
                        }

                        @Override
                        public Icon getIcon() {
                            return methodIcons[JavaType.accessToIndex(methodNode.access)];
                        }
                    });
                }
            }
            return this.methods;
        }

        protected static ImageIcon getIcon(int access) {
            if ((access & 0x2000) != 0) {
                return annotationIcon;
            }
            if ((access & 0x200) != 0) {
                return interfaceIcons[JavaType.accessToIndex(access)];
            }
            if ((access & 0x4000) != 0) {
                return enumIcon;
            }
            return classIcons[JavaType.accessToIndex(access)];
        }

        protected static int accessToIndex(int access) {
            int index = 0;
            if ((access & 8) != 0) {
                index += 4;
            }
            if ((access & 0x10) != 0) {
                index += 8;
            }
            if ((access & 0x400) != 0) {
                index += 16;
            }
            if ((access & 1) != 0) {
                return index + 1;
            }
            if ((access & 4) != 0) {
                return index + 2;
            }
            if ((access & 2) != 0) {
                return index + 3;
            }
            return index;
        }

        protected static ImageIcon mergeIcons(ImageIcon background, ImageIcon overlay, int x, int y) {
            int w = background.getIconWidth();
            int h = background.getIconHeight();
            BufferedImage image = new BufferedImage(w, h, 2);
            if (x + overlay.getIconWidth() > w) {
                x = w - overlay.getIconWidth();
            }
            if (y + overlay.getIconHeight() > h) {
                y = h - overlay.getIconHeight();
            }
            Graphics2D g2 = image.createGraphics();
            g2.drawImage(background.getImage(), 0, 0, null);
            g2.drawImage(overlay.getImage(), x, y, null);
            g2.dispose();
            return new ImageIcon(image);
        }

        protected static ImageIcon[] mergeIcons(ImageIcon[] backgrounds, ImageIcon overlay, int x, int y) {
            int length = backgrounds.length;
            ImageIcon[] result = new ImageIcon[length * 2];
            System.arraycopy(backgrounds, 0, result, 0, length);
            for (int i = 0; i < length; ++i) {
                result[length + i] = JavaType.mergeIcons(backgrounds[i], overlay, x, y);
            }
            return result;
        }
    }
}

