/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import com.jhe.hexed.JHexEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class JHexEditorASCII
extends JComponent
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 5505374841731053461L;
    private JHexEditor he;

    public JHexEditorASCII(JHexEditor he) {
        this.he = he;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(he);
    }

    @Override
    public Dimension getPreferredSize() {
        this.debug("getPreferredSize()");
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        this.debug("getMinimumSize()");
        Dimension d = new Dimension();
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        int h = fn.getHeight();
        int nl = this.he.getLineas();
        d.setSize((fn.stringWidth(" ") + 1) * 16 + this.he.border * 2 + 1, h * nl + this.he.border * 2 + 1);
        return d;
    }

    @Override
    public void paint(Graphics g) {
        this.debug("paint(" + g + ")");
        this.debug("cursor=" + this.he.cursor + " buff.length=" + this.he.buff.length);
        Dimension d = this.getMinimumSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        g.setFont(JHexEditor.font);
        int ini = this.he.getInicio() * 16;
        int fin = ini + this.he.getLineas() * 16;
        if (fin > this.he.buff.length) {
            fin = this.he.buff.length;
        }
        int x = 0;
        int y = 0;
        for (int n = ini; n < fin; ++n) {
            if (n == this.he.cursor) {
                g.setColor(Color.blue);
                if (this.hasFocus()) {
                    this.he.fondo(g, x, y, 1);
                } else {
                    this.he.cuadro(g, x, y, 1);
                }
                if (this.hasFocus()) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.black);
                }
            } else {
                g.setColor(Color.black);
            }
            String s = String.valueOf(this.he.buff[n]);
            if (this.he.buff[n] < 20 || this.he.buff[n] > 126) {
                s = "\u0010";
            }
            this.he.printString(g, s, x++, y);
            if (x != 16) continue;
            x = 0;
            ++y;
        }
    }

    private void debug(String s) {
        if (this.he.DEBUG) {
            System.out.println("JHexEditorASCII ==> " + s);
        }
    }

    public int calcularPosicionRaton(int x, int y) {
        FontMetrics fn = this.getFontMetrics(JHexEditor.font);
        this.debug("x=" + (x /= fn.stringWidth(" ") + 1) + " ,y=" + (y /= fn.getHeight()));
        return x + (y + this.he.getInicio()) * 16;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.debug("mouseClicked(" + e + ")");
        this.he.cursor = this.calcularPosicionRaton(e.getX(), e.getY());
        this.requestFocus();
        this.he.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.debug("keyPressed(" + e + ")");
        this.he.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.debug("keyReleased(" + e + ")");
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

