/*
 * Decompiled with CFR 0.152.
 */
package jd.cli;

import java.io.File;
import java.io.PrintStream;
import jd.cli.loader.DirectoryLoader;
import jd.cli.preferences.CommonPreferences;
import jd.cli.printer.text.PlainTextPrinter;
import jd.cli.util.ClassFileUtil;
import jd.core.loader.Loader;
import jd.core.preferences.Preferences;
import jd.core.printer.Printer;
import jd.core.process.DecompilerImpl;

public class Main {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: ...");
        } else {
            try {
                String pathToClass = args[0].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                String directoryPath = ClassFileUtil.ExtractDirectoryPath(pathToClass);
                if (directoryPath == null) {
                    return;
                }
                String internalPath = ClassFileUtil.ExtractInternalPath(directoryPath, pathToClass);
                if (internalPath == null) {
                    return;
                }
                CommonPreferences preferences = new CommonPreferences();
                DirectoryLoader loader = new DirectoryLoader(new File(directoryPath));
                PrintStream ps = new PrintStream("test.txt");
                PlainTextPrinter printer = new PlainTextPrinter(preferences, ps);
                DecompilerImpl decompiler = new DecompilerImpl();
                decompiler.decompile((Preferences)preferences, (Loader)loader, (Printer)printer, internalPath);
                System.out.println("done.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

