/*
 * Decompiled with CFR 0.152.
 */
package jd.cli.loader;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jd.cli.loader.BaseLoader;
import jd.cli.loader.DirectoryLoader;
import jd.cli.loader.JarLoader;
import jd.core.loader.LoaderException;

public class LoaderManager {
    protected static final String JAR_SUFFIX = ".jar";
    protected static final String ZIP_SUFFIX = ".zip";
    protected Map<String, BaseLoader> map = new ConcurrentHashMap<String, BaseLoader>();

    public BaseLoader getLoader(String codebase) throws LoaderException {
        File file = new File(codebase);
        String key = file.getAbsolutePath();
        BaseLoader loader = this.map.get(key);
        if (loader == null) {
            if (file.exists()) {
                loader = this.newLoader(key, file);
            }
        } else if (file.exists()) {
            if (file.lastModified() != loader.getLastModified() || file.isFile() != loader.isFile()) {
                loader = this.newLoader(key, file);
            }
        } else {
            this.map.remove(key);
        }
        return loader;
    }

    protected BaseLoader newLoader(String key, File file) throws LoaderException {
        BaseLoader loader = null;
        if (file.isFile()) {
            if (LoaderManager.endsWithIgnoreCase(key, JAR_SUFFIX) || LoaderManager.endsWithIgnoreCase(key, ZIP_SUFFIX)) {
                loader = new JarLoader(file);
                this.map.put(key, loader);
            }
        } else if (file.isDirectory()) {
            loader = new DirectoryLoader(file);
            this.map.put(key, loader);
        }
        return loader;
    }

    protected static boolean endsWithIgnoreCase(String s, String suffix) {
        int suffixLength = suffix.length();
        int index = s.length() - suffixLength;
        return s.regionMatches(true, index, suffix, 0, suffixLength);
    }
}

