/*
 * Decompiled with CFR 0.152.
 */
package jd.cli.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import jd.core.model.classfile.constant.Constant;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantUtf8;
import jd.core.process.deserializer.ClassFormatException;

public class ClassFileUtil {
    private ClassFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ExtractDirectoryPath(String pathToClass) throws Exception {
        FilterInputStream dis = null;
        String directoryPath = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(pathToClass)));
            int magic = ((DataInputStream)dis).readInt();
            if (magic != -889275714) {
                throw new ClassFormatException("Invalid Java .class file");
            }
            ((DataInputStream)dis).readUnsignedShort();
            ((DataInputStream)dis).readUnsignedShort();
            Constant[] constants = ClassFileUtil.DeserializeConstants((DataInputStream)dis);
            ((DataInputStream)dis).readUnsignedShort();
            int this_class = ((DataInputStream)dis).readUnsignedShort();
            Constant c = constants[this_class];
            if (c == null || c.tag != 7) {
                throw new ClassFormatException("Invalid contant pool");
            }
            c = constants[((ConstantClass)c).name_index];
            if (c == null || c.tag != 1) {
                throw new ClassFormatException("Invalid contant pool");
            }
            String internalClassName = ((ConstantUtf8)c).bytes;
            String pathSuffix = internalClassName.replace('/', File.separatorChar) + ".class";
            int index = pathToClass.indexOf(pathSuffix);
            if (index < 0) {
                throw new ClassFormatException("Invalid internal class name");
            }
            directoryPath = pathToClass.substring(0, index);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return directoryPath;
    }

    public static String ExtractInternalPath(String directoryPath, String pathToClass) {
        if (directoryPath == null || pathToClass == null || !pathToClass.startsWith(directoryPath)) {
            return null;
        }
        String s = pathToClass.substring(directoryPath.length());
        return s.replace(File.separatorChar, '/');
    }

    private static Constant[] DeserializeConstants(DataInputStream dis) throws IOException {
        int count = dis.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Constant[] constants = new Constant[count];
        block9: for (int i = 1; i < count; ++i) {
            byte tag = dis.readByte();
            switch (tag) {
                case 7: {
                    constants[i] = new ConstantClass(tag, dis.readUnsignedShort());
                    continue block9;
                }
                case 1: {
                    constants[i] = new ConstantUtf8(tag, dis.readUTF());
                    continue block9;
                }
                case 5: 
                case 6: {
                    dis.readInt();
                    dis.readInt();
                    ++i;
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    dis.readUnsignedShort();
                    dis.readUnsignedShort();
                    continue block9;
                }
                case 3: 
                case 4: {
                    dis.readInt();
                    continue block9;
                }
                case 8: {
                    dis.readUnsignedShort();
                    continue block9;
                }
                case 15: 
                case 16: 
                case 18: {
                    throw new IllegalArgumentException("JD-GUI does not support Java 8 as of yet");
                }
                default: {
                    throw new ClassFormatException("Invalid constant pool entry");
                }
            }
        }
        return constants;
    }
}

