/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.cfg.query.InsnQuery;
import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.util.TreeBuilder;
import org.objectweb.asm.commons.util.Assembly;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class Block
implements Comparable<Block> {
    public static boolean PRINT_INSNS = true;
    public MethodNode owner = null;
    public final Label label;
    public final List<AbstractInsnNode> instructions = new LinkedList<AbstractInsnNode>();
    public final List<Block> preds = new ArrayList<Block>();
    public Block next;
    public Block target;
    public Stack<AbstractInsnNode> stack = new Stack();
    private NodeTree tree;
    private int index = -1;

    public Block(Label label) {
        this.label = label;
        this.instructions.add(new LabelNode(label));
    }

    public NodeTree tree() {
        if (this.tree != null) {
            return this.tree;
        }
        this.tree = new TreeBuilder().build(this);
        return this.tree;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEmpty() {
        return this.preds.isEmpty() && this.instructions.size() <= 1;
    }

    public int count(int opcode) {
        int count = 0;
        for (AbstractInsnNode ain : this.instructions) {
            if (ain.opcode() != opcode) continue;
            ++count;
        }
        return count;
    }

    public int count(InsnQuery query) {
        int count = 0;
        for (AbstractInsnNode ain : this.instructions) {
            if (!query.matches(ain)) continue;
            ++count;
        }
        return count;
    }

    public AbstractInsnNode get(int opcode, int index) {
        int i = 0;
        for (AbstractInsnNode ain : this.instructions) {
            if (ain.opcode() != opcode) continue;
            if (i == index) {
                return ain;
            }
            ++i;
        }
        return null;
    }

    public AbstractInsnNode get(int opcode) {
        return this.get(opcode, 0);
    }

    public AbstractInsnNode get(InsnQuery query, int index) {
        int i = 0;
        for (AbstractInsnNode ain : this.instructions) {
            if (!query.matches(ain)) continue;
            if (i == index) {
                return ain;
            }
            ++i;
        }
        return null;
    }

    public AbstractInsnNode get(InsnQuery query) {
        return this.get(query, 0);
    }

    @Override
    public int compareTo(Block block) {
        return this.index > block.index ? 1 : -1;
    }

    public int size() {
        return this.instructions.size() - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.headerString()).append(String.format(" (len=%d)", this.size()));
        if (PRINT_INSNS && this.size() > 0) {
            sb.append(System.lineSeparator());
            Iterator<AbstractInsnNode> it = this.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode ain = it.next();
                if (ain instanceof LabelNode) continue;
                if (it.hasNext()) {
                    sb.append(String.format("   %s%n", Assembly.toString(ain)));
                    continue;
                }
                sb.append(String.format("   %s", Assembly.toString(ain)));
            }
        }
        sb.append(System.lineSeparator());
        for (Block b : this.preds) {
            sb.append("   pred: ").append(b.headerString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String headerString() {
        return String.format("Block #%d", this.index);
    }
}

