/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.commons.cfg.Block;

public class Digraph<V, E>
implements Iterable<V> {
    private final Map<V, Set<E>> graph = new HashMap<V, Set<E>>();

    public Set<E> edgeAt(int index) {
        return (Set)this.graph.values().toArray()[index];
    }

    public int size() {
        return this.graph.size();
    }

    public boolean containsVertex(V vertex) {
        return this.graph.containsKey(vertex);
    }

    public boolean containsEdge(V vertex, E edge) {
        return this.graph.containsKey(vertex) && this.graph.get(vertex).contains(edge);
    }

    public boolean addVertex(V vertex) {
        if (this.graph.containsKey(vertex)) {
            return false;
        }
        this.graph.put(vertex, new HashSet());
        return true;
    }

    public void addEdge(V start, E dest) {
        if (!this.graph.containsKey(start)) {
            return;
        }
        this.graph.get(start).add(dest);
    }

    public void removeEdge(V start, E dest) {
        if (!this.graph.containsKey(start)) {
            return;
        }
        this.graph.get(start).remove(dest);
    }

    public Set<E> edgesFrom(V node) {
        return Collections.unmodifiableSet(this.graph.get(node));
    }

    public void graph(Digraph<V, E> graph) {
        this.graph.putAll(graph.graph);
    }

    @Override
    public final Iterator<V> iterator() {
        return this.graph.keySet().iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<V> it = this.graph.keySet().iterator();
        while (it.hasNext()) {
            V v = it.next();
            sb.append(String.format("%s", v));
            Set<E> set = this.graph.get(v);
            if (set.size() > 0) {
                sb.append(System.lineSeparator());
                Iterator<E> it2 = set.iterator();
                while (it2.hasNext()) {
                    E e = it2.next();
                    sb.append("     > ").append(this.toString(e));
                    if (!it2.hasNext()) continue;
                    sb.append(System.lineSeparator());
                }
            }
            if (!it.hasNext()) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toString(E e) {
        String s = null;
        s = e instanceof Block ? ((Block)e).headerString() : e.toString();
        return s;
    }

    public String toString(Set<E> set) {
        Iterator<E> it = set.iterator();
        if (!it.hasNext()) {
            return "emtpy";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            E e = it.next();
            String s = null;
            s = e instanceof Block ? ((Block)e).headerString() : e.toString();
            sb.append(e == this ? "(this Collection)" : s);
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(',').append(' ');
        }
    }

    public Map<V, Set<E>> graph() {
        return this.graph;
    }

    public void flush() {
        this.graph.clear();
    }
}

