/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.cfg.BlockVisitor;
import org.objectweb.asm.commons.cfg.tree.node.AbstractNode;
import org.objectweb.asm.commons.cfg.tree.node.ArithmeticNode;
import org.objectweb.asm.commons.cfg.tree.node.ConstantNode;
import org.objectweb.asm.commons.cfg.tree.node.ConversionNode;
import org.objectweb.asm.commons.cfg.tree.node.FieldMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.IincNode;
import org.objectweb.asm.commons.cfg.tree.node.JumpNode;
import org.objectweb.asm.commons.cfg.tree.node.MethodMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.NumberNode;
import org.objectweb.asm.commons.cfg.tree.node.TypeNode;
import org.objectweb.asm.commons.cfg.tree.node.VariableNode;

public abstract class NodeVisitor
implements Opcodes {
    private NodeVisitor nv;
    private BlockVisitor bv;

    public boolean validate() {
        return this.bv == null || this.bv.validate();
    }

    public NodeVisitor() {
        this.nv = null;
    }

    public NodeVisitor(BlockVisitor bv) {
        this.bv = bv;
    }

    public NodeVisitor(NodeVisitor nv) {
        this.nv = nv;
    }

    public void visitAny(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitAny(n);
        }
    }

    public void visit(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visit(n);
        }
    }

    public void visitCode() {
        if (this.nv != null) {
            this.nv.visitCode();
        }
    }

    public void visitEnd() {
        if (this.nv != null) {
            this.nv.visitEnd();
        }
    }

    public void visitField(FieldMemberNode fmn) {
        if (this.nv != null) {
            this.nv.visitField(fmn);
        }
    }

    public void visitFrame(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitFrame(n);
        }
    }

    public void visitIinc(IincNode in) {
        if (this.nv != null) {
            this.nv.visitIinc(in);
        }
    }

    public void visitJump(JumpNode jn) {
        if (this.nv != null) {
            this.nv.visitJump(jn);
        }
    }

    public void visitLabel(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitLabel(n);
        }
    }

    public void visitConversion(ConversionNode cn) {
        if (this.nv != null) {
            this.nv.visitConversion(cn);
        }
    }

    public void visitConstant(ConstantNode cn) {
        if (this.nv != null) {
            this.nv.visitConstant(cn);
        }
    }

    public void visitNumber(NumberNode nn) {
        if (this.nv != null) {
            this.nv.visitNumber(nn);
        }
    }

    public void visitOperation(ArithmeticNode an) {
        if (this.nv != null) {
            this.nv.visitOperation(an);
        }
    }

    public void visitVariable(VariableNode vn) {
        if (this.nv != null) {
            this.nv.visitVariable(vn);
        }
    }

    public void visitLine(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitLine(n);
        }
    }

    public void visitLookupSwitch(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitLookupSwitch(n);
        }
    }

    public void visitMethod(MethodMemberNode mmn) {
        if (this.nv != null) {
            this.nv.visitMethod(mmn);
        }
    }

    public void visitMultiANewArray(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitMultiANewArray(n);
        }
    }

    public void visitTableSwitch(AbstractNode n) {
        if (this.nv != null) {
            this.nv.visitTableSwitch(n);
        }
    }

    public void visitType(TypeNode tn) {
        if (this.nv != null) {
            this.nv.visitType(tn);
        }
    }
}

