/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.NodeVisitor;
import org.objectweb.asm.commons.cfg.tree.Tree;
import org.objectweb.asm.commons.cfg.tree.node.ArithmeticNode;
import org.objectweb.asm.commons.cfg.tree.node.ConstantNode;
import org.objectweb.asm.commons.cfg.tree.node.ConversionNode;
import org.objectweb.asm.commons.cfg.tree.node.FieldMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.IincNode;
import org.objectweb.asm.commons.cfg.tree.node.JumpNode;
import org.objectweb.asm.commons.cfg.tree.node.MethodMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.NumberNode;
import org.objectweb.asm.commons.cfg.tree.node.ReferenceNode;
import org.objectweb.asm.commons.cfg.tree.node.TypeNode;
import org.objectweb.asm.commons.cfg.tree.node.VariableNode;
import org.objectweb.asm.commons.util.Assembly;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AbstractNode
extends Tree<AbstractNode>
implements Opcodes {
    public static final String CHILD = ">";
    public static final String NUMBER = "#";
    public static final String[] QUERIES = new String[]{"#"};
    public static final String ARITHMETIC_NODE = "ARITHMETIC";
    public static final String[] NODE_QUERIES = new String[]{"ARITHMETIC"};
    public static final Class<?> ARITHMETIC_NODE_CLASS = ArithmeticNode.class;
    public static final Class<?>[] NODE_QUERY_CLASSES = new Class[]{ARITHMETIC_NODE_CLASS};
    public int collapsed;
    public int producing;
    private NodeTree tree;
    private AbstractInsnNode insn;
    private int produceCount;
    private boolean handler;
    private AbstractInsnNode[] instructions;

    public AbstractNode(NodeTree tree, AbstractInsnNode insn, int collapsed, int producing) {
        this.tree = tree;
        this.insn = insn;
        this.collapsed = collapsed;
        this.producing = this.produceCount = producing;
    }

    public ClassNode caller() {
        return this.tree.method().owner;
    }

    public void accept(NodeVisitor nv) {
        nv.visitAny(this);
        switch (this.insn.type()) {
            case 0: {
                if (this.opcode() >= 2 && this.opcode() <= 15) {
                    nv.visitNumber((NumberNode)this);
                    break;
                }
                if (this.opcode() >= 133 && this.opcode() <= 147) {
                    nv.visitConversion((ConversionNode)this);
                    break;
                }
                if (this.opcode() >= 96 && this.opcode() <= 131) {
                    nv.visitOperation((ArithmeticNode)this);
                    break;
                }
                nv.visit(this);
                break;
            }
            case 1: {
                nv.visitNumber((NumberNode)this);
                break;
            }
            case 2: {
                nv.visitVariable((VariableNode)this);
                break;
            }
            case 3: {
                nv.visitType((TypeNode)this);
                break;
            }
            case 4: {
                nv.visitField((FieldMemberNode)this);
                break;
            }
            case 5: {
                nv.visitMethod((MethodMemberNode)this);
                break;
            }
            case 7: {
                nv.visitJump((JumpNode)this);
                break;
            }
            case 8: {
                nv.visitLabel(this);
                break;
            }
            case 9: {
                Object cst = ((LdcInsnNode)this.insn()).cst;
                if (cst != null && cst instanceof Number) {
                    nv.visitNumber((NumberNode)this);
                    break;
                }
                nv.visitConstant((ConstantNode)this);
                break;
            }
            case 10: {
                nv.visitIinc((IincNode)this);
                break;
            }
            case 11: {
                nv.visitTableSwitch(this);
                break;
            }
            case 12: {
                nv.visitLookupSwitch(this);
                break;
            }
            case 13: {
                nv.visitMultiANewArray(this);
                break;
            }
            case 14: {
                nv.visitFrame(this);
                break;
            }
            case 15: {
                nv.visitLine(this);
            }
        }
    }

    public AbstractInsnNode[] collapse() {
        if (this.instructions != null) {
            return this.instructions;
        }
        this.instructions = new AbstractInsnNode[this.total()];
        int i = 0;
        for (AbstractNode n : this) {
            AbstractInsnNode[] nodes = n.collapse();
            System.arraycopy(nodes, 0, this.instructions, i, nodes.length);
            i += nodes.length;
        }
        if (this.instructions.length - i != 1) {
            throw new RuntimeException();
        }
        this.instructions[i] = this.insn();
        return this.instructions;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AbstractNode && Assembly.instructionsEqual(((AbstractNode)obj).insn(), this.insn());
    }

    public AbstractInsnNode insn() {
        return this.insn;
    }

    public boolean isHandler() {
        return this.handler;
    }

    public MethodNode method() {
        return this.tree.method();
    }

    public int opcode() {
        return this.insn != null ? this.insn.opcode() : -1;
    }

    public void pop() {
        ((AbstractNode)this.parent()).remove(this);
    }

    public boolean hasFirst() {
        return this.first() != null;
    }

    public AbstractNode first() {
        return this.child(0);
    }

    public AbstractNode child(int idx) {
        int i = 0;
        for (AbstractNode n : this) {
            if (i == idx) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public AbstractNode[] producing() {
        AbstractNode[] nodes = new AbstractNode[this.size()];
        int i = 0;
        for (AbstractNode n : this) {
            if (n.produceCount <= 0) continue;
            nodes[i++] = n;
        }
        return Arrays.copyOf(nodes, i);
    }

    public void delete() {
        ((AbstractNode)this.parent()).remove(this);
    }

    public void setHandler(boolean handler) {
        this.handler = handler;
    }

    public void setInstruction(AbstractInsnNode insn) {
        this.insn = insn;
    }

    @Override
    public String toString() {
        return this.toString(1);
    }

    protected String toString(int tab) {
        StringBuilder sb = new StringBuilder();
        sb.append(Assembly.toString(this.insn));
        for (AbstractNode n : this) {
            sb.append('\n');
            for (int i = 0; i < tab; ++i) {
                sb.append('\t');
            }
            sb.append(n.toString(tab + 1));
        }
        return sb.toString();
    }

    public int total() {
        int size = 1;
        for (AbstractNode n : this) {
            size += n.total();
        }
        return size;
    }

    public int children() {
        return this.producing().length;
    }

    public NodeTree tree() {
        return this.tree;
    }

    public int index() {
        return this.method().instructions.indexOf(this.insn());
    }

    public AbstractNode first(int opcode) {
        for (AbstractNode n : this) {
            if (n.opcode() != opcode) continue;
            return n;
        }
        return null;
    }

    public AbstractNode find(int opcode, int index) {
        int i = 0;
        for (AbstractNode n : this) {
            if (n.opcode() != opcode || i++ != index) continue;
            return n;
        }
        return null;
    }

    public <T extends AbstractNode> T first(Class<? extends AbstractNode> clazz) {
        for (AbstractNode n : this) {
            if (!n.getClass().equals(clazz)) continue;
            return (T)n;
        }
        return null;
    }

    public NumberNode firstNumber() {
        return (NumberNode)this.first(NumberNode.class);
    }

    public ArithmeticNode firstOperation() {
        return (ArithmeticNode)this.first(ArithmeticNode.class);
    }

    public ReferenceNode firstReference() {
        return (ReferenceNode)this.first(ReferenceNode.class);
    }

    public FieldMemberNode firstField() {
        for (AbstractNode n : this) {
            if (!(n instanceof ReferenceNode) || !(n.insn() instanceof FieldInsnNode)) continue;
            return (FieldMemberNode)n;
        }
        return null;
    }

    public MethodMemberNode firstMethod() {
        for (AbstractNode n : this) {
            if (!(n instanceof ReferenceNode) || !(n.insn() instanceof MethodInsnNode)) continue;
            return (MethodMemberNode)n;
        }
        return null;
    }

    public VariableNode firstVariable() {
        return (VariableNode)this.first(VariableNode.class);
    }

    public ConstantNode firstConstant() {
        return (ConstantNode)this.first(ConstantNode.class);
    }

    public TypeNode firstType() {
        return (TypeNode)this.first(TypeNode.class);
    }

    public JumpNode firstJump() {
        return (JumpNode)this.first(JumpNode.class);
    }

    public <T extends AbstractNode> T next(Class<? extends AbstractNode> clazz, int max) {
        int i = 0;
        AbstractNode next = this;
        while ((next = (AbstractNode)next.next()) != null && i++ < max) {
            if (!next.getClass().equals(clazz)) continue;
            return (T)next;
        }
        return null;
    }

    public NumberNode nextNumber() {
        return (NumberNode)this.next(NumberNode.class, 3);
    }

    public ArithmeticNode nextOperation() {
        return (ArithmeticNode)this.next(ArithmeticNode.class, 3);
    }

    public FieldMemberNode nextField(int max) {
        return (FieldMemberNode)this.next(FieldMemberNode.class, max);
    }

    public FieldMemberNode nextField() {
        return this.nextField(1);
    }

    public MethodMemberNode nextMethod(int max) {
        return (MethodMemberNode)this.next(MethodMemberNode.class, max);
    }

    public ReferenceNode nextMethod() {
        return this.nextMethod(1);
    }

    public JumpNode nextJump(int max) {
        return (JumpNode)this.next(JumpNode.class, max);
    }

    public JumpNode nextJump() {
        return this.nextJump(1);
    }

    public VariableNode nextVariable(int max) {
        return (VariableNode)this.next(VariableNode.class, max);
    }

    public VariableNode nextVariable() {
        return this.nextVariable(1);
    }

    public ConstantNode nextConstant(int max) {
        return (ConstantNode)this.next(ConstantNode.class, max);
    }

    public ConstantNode nextConstant() {
        return this.nextConstant(1);
    }

    public TypeNode nextType(int max) {
        return (TypeNode)this.next(TypeNode.class, max);
    }

    public TypeNode nextType() {
        return this.nextType(1);
    }

    public AbstractNode next(int opcode, int max) {
        int i = 0;
        AbstractNode next = this;
        while ((next = (AbstractNode)next.next()) != null && i++ < max) {
            if (next.opcode() != opcode) continue;
            return next;
        }
        return null;
    }

    public AbstractNode next(int opcode) {
        return this.next(opcode, 5);
    }

    public AbstractNode previous(int opcode, int max) {
        int i = 0;
        AbstractNode prev = this;
        while ((prev = (AbstractNode)prev.previous()) != null && i++ < max) {
            if (prev.opcode() != opcode) continue;
            return prev;
        }
        return null;
    }

    public AbstractNode previous(int opcode) {
        return this.previous(opcode, 5);
    }

    public List<AbstractNode> findChildren(int opcode) {
        ArrayList<AbstractNode> children = new ArrayList<AbstractNode>();
        for (AbstractNode n : this) {
            if (n.opcode() != opcode) continue;
            children.add(n);
        }
        return !children.isEmpty() ? children : null;
    }

    public List<AbstractNode> layerAll(int ... opcodes) {
        List<AbstractNode> children = this.findChildren(opcodes[0]);
        if (children == null) {
            return null;
        }
        if (opcodes.length == 1) {
            return children;
        }
        for (int i = 1; i < opcodes.length; ++i) {
            ArrayList<AbstractNode> next = new ArrayList<AbstractNode>();
            for (AbstractNode n : children) {
                List<AbstractNode> match = n.findChildren(opcodes[i]);
                if (match == null) continue;
                next.addAll(match);
            }
            if (next.isEmpty()) {
                return null;
            }
            children.clear();
            children.addAll(next);
        }
        return children;
    }

    public AbstractNode layer(int ... opcodes) {
        List<AbstractNode> nodes = this.layerAll(opcodes);
        return nodes != null ? nodes.get(0) : null;
    }

    public AbstractNode preLayer(int ... opcodes) {
        AbstractNode node = this;
        for (int opcode : opcodes) {
            if ((node = (AbstractNode)node.parent()) != null && node.opcode() == opcode) continue;
            return null;
        }
        return node;
    }

    public boolean hasChild(int opcode) {
        return this.first(opcode) != null;
    }

    public String opname() {
        try {
            return Assembly.OPCODES[this.opcode()];
        }
        catch (IndexOutOfBoundsException e) {
            try {
                return this.insn().getClass().getSimpleName();
            }
            catch (Exception err) {
                return this.insn().toString();
            }
        }
    }
}

