/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree.node;

import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.node.AbstractNode;
import org.objectweb.asm.commons.cfg.tree.node.TargetNode;
import org.objectweb.asm.commons.util.Assembly;
import org.objectweb.asm.tree.JumpInsnNode;

public class JumpNode
extends AbstractNode {
    private TargetNode target;

    public JumpNode(NodeTree tree, JumpInsnNode insn, int collapsed, int producing) {
        super(tree, insn, collapsed, producing);
    }

    @Override
    public JumpInsnNode insn() {
        return (JumpInsnNode)super.insn();
    }

    public AbstractNode resolve() {
        return this.target.resolve();
    }

    public void setTarget(TargetNode target) {
        if (this.target != null) {
            this.target.removeTargeter(this);
        }
        if (target != null) {
            target.addTargeter(this);
            this.insn().label = target.label();
        } else {
            this.insn().label = null;
        }
        this.target = target;
    }

    public TargetNode target() {
        return this.target;
    }

    @Override
    protected String toString(int tab) {
        StringBuilder sb = new StringBuilder();
        sb.append(Assembly.toString(this.insn()));
        sb.append(' ').append('>').append(' ');
        sb.append(this.target);
        for (AbstractNode n : this) {
            sb.append('\n');
            for (int i = 0; i < tab; ++i) {
                sb.append('\t');
            }
            sb.append(n.toString(tab + 1));
        }
        return sb.toString();
    }
}

