/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree.node;

import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.node.AbstractNode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public class NumberNode
extends AbstractNode {
    public NumberNode(NodeTree tree, AbstractInsnNode insn, int collapsed, int producing) {
        super(tree, insn, collapsed, producing);
    }

    public int number() {
        AbstractInsnNode insn = this.insn();
        int op = insn.opcode();
        switch (op) {
            case 16: 
            case 17: 
            case 188: {
                return ((IntInsnNode)insn).operand;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return op - 3;
            }
            case 9: 
            case 10: {
                return op - 9;
            }
            case 11: 
            case 12: 
            case 13: {
                return op - 11;
            }
            case 14: 
            case 15: {
                return op - 14;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (!(cst instanceof Number)) break;
                return ((Number)cst).intValue();
            }
        }
        return -1;
    }

    public void setNumber(int number) {
        AbstractInsnNode ain = this.insn();
        if (ain instanceof IntInsnNode) {
            ((IntInsnNode)this.insn()).operand = number;
            ((IntInsnNode)ain).operand = number;
        } else if (ain instanceof LdcInsnNode) {
            ((LdcInsnNode)this.insn()).cst = number;
            ((LdcInsnNode)ain).cst = number;
        }
    }

    public void setNumber(Number num) {
        AbstractInsnNode ain = this.insn();
        if (!(ain instanceof LdcInsnNode)) {
            this.setInstruction(new LdcInsnNode(num));
        } else {
            ((LdcInsnNode)ain).cst = num;
        }
    }

    @Override
    public String toString() {
        return this.insn().toString();
    }
}

