/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree.node;

import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.node.AbstractNode;
import org.objectweb.asm.commons.cfg.tree.node.FieldMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.MethodMemberNode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ReferenceNode
extends AbstractNode {
    public ReferenceNode(NodeTree tree, AbstractInsnNode insn, int collapsed, int producing) {
        super(tree, insn, collapsed, producing);
    }

    public boolean isStatic() {
        return this.opcode() == 178 || this.opcode() == 179 || this.opcode() == 184;
    }

    public String key() {
        AbstractInsnNode ain = this.insn();
        if (ain instanceof FieldInsnNode) {
            FieldInsnNode fin = (FieldInsnNode)ain;
            return fin.owner + "." + fin.name;
        }
        if (ain instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)ain;
            return min.owner + "." + min.name + min.desc;
        }
        return null;
    }

    public String owner() {
        AbstractInsnNode insn = this.insn();
        if (this instanceof FieldMemberNode) {
            return ((FieldInsnNode)insn).owner;
        }
        if (this instanceof MethodMemberNode) {
            return ((MethodInsnNode)insn).owner;
        }
        return null;
    }

    public String name() {
        AbstractInsnNode ain = this.insn();
        if (ain instanceof FieldInsnNode) {
            return ((FieldInsnNode)ain).name;
        }
        if (ain instanceof MethodInsnNode) {
            return ((MethodInsnNode)ain).name;
        }
        return null;
    }

    public String desc() {
        AbstractInsnNode ain = this.insn();
        if (this instanceof FieldMemberNode) {
            return ((FieldInsnNode)ain).desc;
        }
        if (this instanceof MethodMemberNode) {
            return ((MethodInsnNode)ain).desc;
        }
        return null;
    }

    public boolean referenced(MethodNode mn) {
        for (AbstractInsnNode ain : mn.instructions.toArray()) {
            if (ain instanceof FieldInsnNode) {
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!this.key().equals(fin.owner + "." + fin.name)) continue;
                return true;
            }
            if (!(ain instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!this.key().equals(min.owner + "." + min.name + min.desc)) continue;
            return true;
        }
        return false;
    }
}

