/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree.node;

import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.node.AbstractNode;
import org.objectweb.asm.commons.cfg.tree.node.JumpNode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class TargetNode
extends AbstractNode {
    private final List<JumpNode> nodes = new LinkedList<JumpNode>();

    public TargetNode(NodeTree tree, AbstractInsnNode insn, int collapsed, int producing) {
        super(tree, insn, collapsed, producing);
    }

    public void addTargeter(JumpNode jn) {
        this.nodes.add(jn);
    }

    public LabelNode label() {
        return (LabelNode)this.insn();
    }

    public void removeTargeter(JumpNode jn) {
        this.nodes.remove(jn);
    }

    public AbstractNode resolve() {
        AbstractNode n;
        for (n = this; n != null && n.opcode() == -1; n = (AbstractNode)n.next()) {
        }
        return n == null ? (AbstractNode)this.parent() : n;
    }

    public JumpNode[] targeters() {
        return this.nodes.toArray(new JumpNode[this.nodes.size()]);
    }

    @Override
    public String toString(int tab) {
        return "Target@" + Integer.toHexString(this.label().hashCode());
    }
}

