/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class CommandLineInput {
    private static final Options options = new Options();
    private static final CommandLineParser parser = new DefaultParser();
    public static int STOP = -1;
    public static int OPEN_FILE = 0;
    public static int CLI = 1;
    private CommandLine parsed;

    public CommandLineInput(String[] args) throws ParseException {
        this.parsed = parser.parse(options, args);
    }

    public boolean containsCommand() {
        return this.parsed.hasOption("help") || this.parsed.hasOption("list") || this.parsed.hasOption("decompiler") || this.parsed.hasOption("i") || this.parsed.hasOption("o") || this.parsed.hasOption("t") || this.parsed.hasOption("nowait");
    }

    public int parseCommandLine() {
        if (!this.containsCommand()) {
            return OPEN_FILE;
        }
        try {
            if (this.parsed.hasOption("list")) {
                System.out.println("Procyon");
                System.out.println("CFR");
                System.out.println("FernFlower");
                System.out.println("Krakatau");
                System.out.println("Krakatau-Bytecode");
                System.out.println("JD-GUI");
                System.out.println("Smali");
                return STOP;
            }
            if (this.parsed.hasOption("help")) {
                for (String s : new String[]{"-help                         Displays the help menu", "-list                         Displays the available decompilers", "-decompiler <decompiler>      Selects the decompiler, procyon by default", "-i <input file>               Selects the input file", "-o <output file>              Selects the output file", "-t <target classname>         Must either be the fully qualified classname or \"all\" to decompile all as zip", "-nowait                       Doesn't wait for the user to read the CLI messages"}) {
                    System.out.println(s);
                }
                return STOP;
            }
            if (this.parsed.getOptionValue("i") == null) {
                System.err.println("Set the input with -i");
                return STOP;
            }
            if (this.parsed.getOptionValue("o") == null) {
                System.err.println("Set the output with -o");
                return STOP;
            }
            if (this.parsed.getOptionValue("t") == null) {
                System.err.println("Set the target with -t");
                return STOP;
            }
            File input = new File(this.parsed.getOptionValue("i"));
            File output = new File(this.parsed.getOptionValue("o"));
            String decompiler = this.parsed.getOptionValue("decompiler");
            if (!input.exists()) {
                System.err.println(input.getAbsolutePath() + " does not exist.");
                return STOP;
            }
            if (output.exists()) {
                System.err.println("WARNING: Deleted old " + output.getAbsolutePath() + ".");
                output.delete();
            }
            if (!(decompiler == null || decompiler.equalsIgnoreCase("procyon") || decompiler.equalsIgnoreCase("cfr") || decompiler.equalsIgnoreCase("fernflower") || decompiler.equalsIgnoreCase("krakatau") || decompiler.equalsIgnoreCase("krakatau-bytecode") || decompiler.equalsIgnoreCase("jd-gui") || decompiler.equalsIgnoreCase("smali"))) {
                System.out.println("Error, no decompiler called '" + decompiler + "' found. Type -decompiler-list for the list");
            }
            if (!this.parsed.hasOption("nowait")) {
                Thread.sleep(5000L);
            }
            return CLI;
        }
        catch (Exception e) {
            new ExceptionUI(e);
            return OPEN_FILE;
        }
    }

    public void executeCommandLine() {
        try {
            File input = new File(this.parsed.getOptionValue("i"));
            File output = new File(this.parsed.getOptionValue("o"));
            String target = this.parsed.getOptionValue("t");
            Decompiler use = null;
            if (this.parsed.getOptionValue("decompiler") == null) {
                System.out.println("You can define another decompiler by appending -decompiler \"name\", by default procyon has been set.");
                use = Decompiler.PROCYON;
            } else {
                use = Decompiler.getByName(this.parsed.getOptionValue("decompiler"));
                if (use == null) {
                    System.out.println("Decompiler not found. By default Procyon has been set.");
                    use = Decompiler.PROCYON;
                }
            }
            System.out.println("Decompiling " + input.getAbsolutePath() + " with " + use.getName());
            BytecodeViewer.openFiles(new File[]{input}, false);
            String containerName = BytecodeViewer.files.get((int)0).name;
            Thread.sleep(5000L);
            if (target.equalsIgnoreCase("all")) {
                use.decompileToZip(output.getAbsolutePath());
            } else {
                try {
                    ClassNode cn = BytecodeViewer.getClassNode(containerName, target);
                    byte[] bytes = BytecodeViewer.getClassBytes(containerName, target);
                    String contents = use.decompileClassNode(cn, bytes);
                    FileUtils.write((File)output, (CharSequence)contents, (String)"UTF-8", (boolean)false);
                }
                catch (Exception e) {
                    new ExceptionUI(e);
                }
            }
            System.out.println("Finished.");
            System.out.println("Bytecode Viewer CLI v3.0.0 by @Konloch - http://bytecodeviewer.com");
            System.exit(0);
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    static {
        options.addOption(new Option("help", null, false, "prints the help menu."));
        options.addOption(new Option("list", null, false, "lists all the available decompilers for BCV 3.0.0."));
        options.addOption(new Option("decompiler", null, true, "sets the decompiler, procyon by default."));
        options.addOption(new Option("i", null, true, "sets the input."));
        options.addOption(new Option("o", null, true, "sets the output."));
        options.addOption(new Option("t", null, true, "sets the target class to decompile, append all to decomp all as zip."));
        options.addOption(new Option("nowait", null, true, "won't wait the 5 seconds to allow the user to read the CLI."));
    }
}

