/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class FileContainer {
    public File file;
    public String name;
    public HashMap<String, byte[]> files = new HashMap();
    private Map<String, ClassNode> classes = new HashMap<String, ClassNode>();

    public FileContainer(File f) {
        this.file = f;
        this.name = f.getName();
    }

    public ClassNode getClassNode(String name) {
        byte[] bytes;
        if (!this.classes.containsKey(name) && (bytes = this.files.get(name + ".class")) != null) {
            ClassReader reader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            reader.accept(classNode, 8);
            this.classes.put(name, classNode);
        }
        return this.classes.get(name);
    }

    public Map<String, byte[]> getData() {
        return this.files;
    }

    public boolean remove(ClassNode classNode) {
        return this.classes.remove(classNode.name) != null;
    }

    @Deprecated
    public void add(ClassNode classNode) {
        this.classes.put(classNode.name, classNode);
    }

    @Deprecated
    public Collection<ClassNode> values() {
        return this.classes.values();
    }
}

