/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.FileContainer;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;

public class JarUtils {
    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(File jarFile) throws IOException {
        ZipEntry entry;
        FileContainer container = new FileContainer(jarFile);
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        ZipInputStream jis = new ZipInputStream(new FileInputStream(jarFile));
        while ((entry = jis.getNextEntry()) != null) {
            try {
                String name = entry.getName();
                byte[] bytes = JarUtils.getBytes(jis);
                if (files.containsKey(name)) continue;
                if (!name.endsWith(".class")) {
                    if (entry.isDirectory()) continue;
                    files.put(name, bytes);
                    continue;
                }
                files.put(name, bytes);
            }
            catch (Exception e) {
                new ExceptionUI(e);
            }
            finally {
                jis.closeEntry();
            }
        }
        jis.close();
        container.files = files;
        BytecodeViewer.files.add(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ClassNode> loadClasses(File jarFile) throws IOException {
        ZipEntry entry;
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
        ZipInputStream jis = new ZipInputStream(new FileInputStream(jarFile));
        while ((entry = jis.getNextEntry()) != null) {
            try {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                byte[] bytes = JarUtils.getBytes(jis);
                String cafebabe = String.format("%02X%02X%02X%02X", bytes[0], bytes[1], bytes[2], bytes[3]);
                if (cafebabe.toLowerCase().equals("cafebabe")) {
                    try {
                        ClassNode cn = JarUtils.getNode(bytes);
                        classes.add(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                System.out.println(jarFile + ">" + name + ": Header does not start with CAFEBABE, ignoring.");
            }
            catch (Exception e) {
                new ExceptionUI(e);
            }
            finally {
                jis.closeEntry();
            }
        }
        jis.close();
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, byte[]> loadResources(File zipFile) throws IOException {
        ZipEntry entry;
        if (!zipFile.exists()) {
            return null;
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        ZipInputStream jis = new ZipInputStream(new FileInputStream(zipFile));
        while ((entry = jis.getNextEntry()) != null) {
            try {
                String name = entry.getName();
                if (name.endsWith(".class") || name.endsWith(".dex")) continue;
                if (!entry.isDirectory()) {
                    files.put(name, JarUtils.getBytes(jis));
                }
                jis.closeEntry();
            }
            catch (Exception e) {
                new ExceptionUI(e);
            }
            finally {
                jis.closeEntry();
            }
        }
        jis.close();
        return files;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int a = 0;
        while ((a = is.read(buffer)) != -1) {
            baos.write(buffer, 0, a);
        }
        baos.close();
        buffer = null;
        return baos.toByteArray();
    }

    public static ClassNode getNode(byte[] bytez) {
        ClassReader cr = new ClassReader(bytez);
        ClassNode cn = new ClassNode();
        try {
            cr.accept(cn, 8);
        }
        catch (Exception e) {
            try {
                cr.accept(cn, 4);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        cr = null;
        return cn;
    }

    public static void saveAsJar(ArrayList<ClassNode> nodeList, String path, String manifest) {
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(path));){
            for (ClassNode cn : nodeList) {
                ClassWriter cw = new ClassWriter(0);
                cn.accept(cw);
                out.putNextEntry(new ZipEntry(cn.name + ".class"));
                out.write(cw.toByteArray());
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            out.write((manifest.trim() + "\r\n\r\n").getBytes());
            out.closeEntry();
            for (FileContainer container : BytecodeViewer.files) {
                for (Map.Entry<String, byte[]> entry : container.files.entrySet()) {
                    String filename = entry.getKey();
                    if (filename.startsWith("META-INF")) continue;
                    out.putNextEntry(new ZipEntry(filename));
                    out.write(entry.getValue());
                    out.closeEntry();
                }
            }
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
    }

    public static void saveAsJarClassesOnly(ArrayList<ClassNode> nodeList, String path) {
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(path));){
            ArrayList<String> noDupe = new ArrayList<String>();
            for (ClassNode cn : nodeList) {
                ClassWriter cw = new ClassWriter(0);
                cn.accept(cw);
                String name = cn.name + ".class";
                if (noDupe.contains(name)) continue;
                noDupe.add(name);
                out.putNextEntry(new ZipEntry(name));
                out.write(cw.toByteArray());
                out.closeEntry();
            }
            noDupe.clear();
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
    }

    public static void saveAsJarClassesOnly(Map<String, byte[]> nodeList, String path) {
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(path));){
            ArrayList<String> noDupe = new ArrayList<String>();
            for (Map.Entry<String, byte[]> cn : nodeList.entrySet()) {
                String name = cn.getKey();
                if (noDupe.contains(name)) continue;
                noDupe.add(name);
                out.putNextEntry(new ZipEntry(name));
                out.write(cn.getValue());
                out.closeEntry();
            }
            noDupe.clear();
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
    }

    public static void saveAsJar(Map<String, byte[]> nodeList, String path) {
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(path));){
            ArrayList<String> noDupe = new ArrayList<String>();
            for (Map.Entry<String, byte[]> entry : nodeList.entrySet()) {
                String name = entry.getKey();
                if (noDupe.contains(name)) continue;
                noDupe.add(name);
                out.putNextEntry(new ZipEntry(name));
                out.write(entry.getValue());
                out.closeEntry();
            }
            for (FileContainer container : BytecodeViewer.files) {
                for (Map.Entry<String, byte[]> entry : container.files.entrySet()) {
                    String filename = entry.getKey();
                    if (filename.startsWith("META-INF") || noDupe.contains(filename)) continue;
                    noDupe.add(filename);
                    out.putNextEntry(new ZipEntry(filename));
                    out.write(entry.getValue());
                    out.closeEntry();
                }
            }
            noDupe.clear();
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
    }
}

