/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.api;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public final class ClassNodeLoader
extends ClassLoader {
    private HashMap<String, ClassNode> classes = new HashMap();

    public ClassNodeLoader() {
        super(ClassLoader.getSystemClassLoader());
    }

    public void addClass(ClassNode cn) {
        this.classes.put(cn.name.replace("/", "."), cn);
    }

    public boolean contains(String name) {
        return this.classes.get(name) != null;
    }

    public Collection<ClassNode> getAll() {
        return this.classes.values();
    }

    public void clear() {
        this.classes.clear();
    }

    public Collection<Class<?>> getAllClasses() {
        ArrayList classes = new ArrayList();
        for (String s : this.classes.keySet()) {
            try {
                classes.add(this.loadClass(s));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    public ClassNode get(String name) {
        return this.classes.get(name);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            return this.nodeToClass(this.classes.get(name));
        }
        return super.findClass(name);
    }

    public Class<?> nodeToClass(ClassNode node) {
        if (super.findLoadedClass(node.name.replace("/", ".")) != null) {
            return this.findLoadedClass(node.name.replace("/", "."));
        }
        ClassWriter cw = new ClassWriter(1);
        try {
            node.accept(cw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] b = cw.toByteArray();
        return this.defineClass(node.name.replaceAll("/", "."), b, 0, b.length, this.getDomain());
    }

    private ProtectionDomain getDomain() {
        CodeSource code = new CodeSource(null, (Certificate[])null);
        return new ProtectionDomain(code, this.getPermissions());
    }

    private Permissions getPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }
}

