/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.FileUtils;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.Settings;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.compilers.Compiler;

public class KrakatauAssembler
extends Compiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compile(String contents, String name) {
        if (Settings.PYTHON2_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set your Python (or PyPy for speed) 2.7 executable path.");
            BytecodeViewer.viewer.pythonC();
        }
        if (Settings.PYTHON2_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set Python!");
            return null;
        }
        String origName = name;
        name = MiscUtils.randomString(20);
        File tempD = new File(BytecodeViewer.tempDir, BytecodeViewer.fs + MiscUtils.randomString(32) + BytecodeViewer.fs);
        tempD.mkdir();
        File tempJ = new File(tempD.getAbsolutePath() + BytecodeViewer.fs + name + ".j");
        try {
            FileUtils.write((File)tempJ, (CharSequence)contents, (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File tempDirectory = new File(BytecodeViewer.tempDir, BytecodeViewer.fs + MiscUtils.randomString(32) + BytecodeViewer.fs);
        tempDirectory.mkdir();
        File tempJar = new File(BytecodeViewer.tempDir, BytecodeViewer.fs + "temp" + MiscUtils.randomString(32) + ".jar");
        JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), tempJar.getAbsolutePath());
        BytecodeViewer.sm.stopBlocking();
        String log = "";
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(Settings.PYTHON2_LOCATION.get(), "-O", BytecodeViewer.krakatauDirectory.getAbsolutePath() + BytecodeViewer.fs + "assemble.py", "-out", tempDirectory.getAbsolutePath(), tempJ.getAbsolutePath());
            Process process = pb.start();
            BytecodeViewer.createdProcesses.add(process);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                log = log + BytecodeViewer.nl + line;
            }
            br.close();
            log = log + BytecodeViewer.nl + BytecodeViewer.nl + "Error:" + BytecodeViewer.nl + BytecodeViewer.nl;
            is = process.getErrorStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                log = log + BytecodeViewer.nl + line;
            }
            br.close();
            int exitValue = process.waitFor();
            log = log + BytecodeViewer.nl + BytecodeViewer.nl + "Exit Value is " + exitValue;
            System.out.println(log);
            byte[] b = FileUtils.readFileToByteArray((File)new File(tempDirectory.getAbsolutePath() + BytecodeViewer.fs + origName + ".class"));
            tempDirectory.delete();
            tempJar.delete();
            byte[] byArray = b;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            new ExceptionUI(log);
        }
        finally {
            BytecodeViewer.sm.setBlocking();
        }
        return null;
    }
}

