/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.DecompilerSettings;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.CFRDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.FernFlowerDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.JDGUIDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.KrakatauDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.KrakatauDisassembler;
import the.bytecode.club.bytecodeviewer.decompilers.ProcyonDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.SmaliDisassembler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.ClassNodeDecompiler;

public abstract class Decompiler {
    private static final Map<String, Decompiler> BY_NAME = new HashMap<String, Decompiler>();
    public static final Decompiler BYTECODE = new ClassNodeDecompiler();
    public static final Decompiler FERNFLOWER = new FernFlowerDecompiler();
    public static final Decompiler PROCYON = new ProcyonDecompiler();
    public static final Decompiler CFR = new CFRDecompiler();
    public static final Decompiler KRAKATAU = new KrakatauDecompiler();
    public static final Decompiler JDGUI = new JDGUIDecompiler();
    public static final Decompiler KRAKATAU_DA = new KrakatauDisassembler();
    public static final Decompiler SMALI = new SmaliDisassembler();
    public static final Decompiler HEXCODE = new Decompiler(){

        @Override
        public String decompileClassNode(ClassNode cn, byte[] b) {
            throw new IllegalArgumentException();
        }

        @Override
        public void decompileToZip(String zipName) {
            throw new IllegalArgumentException();
        }

        @Override
        public String getName() {
            return "Hexcode";
        }

        @Override
        public DecompilerSettings getSettings() {
            throw new IllegalArgumentException();
        }
    };
    protected DecompilerSettings settings = new DecompilerSettings(this);

    public Decompiler() {
        BY_NAME.put(this.getName().toLowerCase().replace(' ', '-'), this);
    }

    public abstract String decompileClassNode(ClassNode var1, byte[] var2);

    public abstract void decompileToZip(String var1);

    public abstract String getName();

    public DecompilerSettings getSettings() {
        return this.settings;
    }

    protected String parseException(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        e.printStackTrace();
        String exception = "Bytecode Viewer Version: 3.0.0" + BytecodeViewer.nl + BytecodeViewer.nl + sw.toString();
        return this.getName() + " encountered a problem! Send the stacktrace to Konloch at http://the.bytecode.club or konloch@gmail.com" + BytecodeViewer.nl + BytecodeViewer.nl + "Suggested Fix: Click refresh class, if it fails again try another decompiler." + BytecodeViewer.nl + BytecodeViewer.nl + exception;
    }

    protected void handleException(Exception e) {
        new ExceptionUI(e);
    }

    protected byte[] fixBytes(byte[] in) {
        ClassReader reader = new ClassReader(in);
        ClassNode node = new ClassNode();
        reader.accept(node, 8);
        ClassWriter writer = new ClassWriter(1);
        node.accept(writer);
        return writer.toByteArray();
    }

    public static void ensureInitted() {
    }

    public static Decompiler getByName(String name) {
        return BY_NAME.get(name.toLowerCase().replace(' ', '-'));
    }

    public static Collection<Decompiler> getAllDecompilers() {
        return Collections.unmodifiableCollection(BY_NAME.values());
    }
}

