/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jd.cli.preferences.CommonPreferences;
import jd.cli.printer.text.PlainTextPrinter;
import jd.core.loader.Loader;
import jd.core.loader.LoaderException;
import jd.core.preferences.Preferences;
import jd.core.printer.Printer;
import jd.core.process.DecompilerImpl;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class JDGUIDecompiler
extends Decompiler {
    @Override
    public String getName() {
        return "JDGUI";
    }

    @Override
    public String decompileClassNode(ClassNode cn, byte[] b) {
        try {
            if (cn.version < 49) {
                b = this.fixBytes(b);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.decompile(b, outputStream);
            return outputStream.toString("UTF-8");
        }
        catch (Exception e) {
            return this.parseException(e);
        }
    }

    @Override
    public void decompileToZip(String zipName) {
        File output = new File(zipName);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(output));){
            for (Map.Entry<String, byte[]> entry : BytecodeViewer.getLoadedBytes().entrySet()) {
                String name = entry.getKey();
                if (name.endsWith(".class")) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        this.decompile(entry.getValue(), out);
                        zipOutputStream.putNextEntry(new ZipEntry(name.substring(0, name.length() - 6) + ".java"));
                        zipOutputStream.write(out.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        zipOutputStream.putNextEntry(new ZipEntry(name));
                        zipOutputStream.write(entry.getValue());
                    }
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry(name));
                    zipOutputStream.write(entry.getValue());
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void decompile(final byte[] data, OutputStream to) throws LoaderException, UnsupportedEncodingException {
        CommonPreferences preferences = new CommonPreferences(){

            @Override
            public boolean isShowLineNumbers() {
                return true;
            }

            @Override
            public boolean isMergeEmptyLines() {
                return true;
            }
        };
        Loader customLoader = new Loader(){

            public DataInputStream load(String s) throws LoaderException {
                return new DataInputStream(new ByteArrayInputStream(data));
            }

            public boolean canLoad(String s) {
                return true;
            }
        };
        new DecompilerImpl().decompile((Preferences)preferences, customLoader, (Printer)new PlainTextPrinter(preferences, new PrintStream(to, false, "UTF-8")), "BytecodeViewer.class");
    }
}

