/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers;

import com.beust.jcommander.JCommander;
import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.CommandLineOptions;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.Languages;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.DecompilerSettings;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class ProcyonDecompiler
extends Decompiler {
    public ProcyonDecompiler() {
        for (Settings setting : Settings.values()) {
            this.settings.registerSetting(setting);
        }
    }

    @Override
    public String getName() {
        return "Procyon";
    }

    public DecompilerSettings getDecompilerSettings() {
        CommandLineOptions options = new CommandLineOptions();
        JCommander jCommander = new JCommander((Object)options);
        String[] args = new String[Settings.values().length * 2];
        int index = 0;
        for (Settings setting : Settings.values()) {
            args[index++] = "--" + setting.getParam();
            args[index++] = String.valueOf(this.getSettings().isSelected(setting));
        }
        jCommander.parse(args);
        DecompilerSettings settings = new DecompilerSettings();
        settings.setFlattenSwitchBlocks(options.getFlattenSwitchBlocks());
        settings.setForceExplicitImports(!options.getCollapseImports());
        settings.setForceExplicitTypeArguments(options.getForceExplicitTypeArguments());
        settings.setRetainRedundantCasts(options.getRetainRedundantCasts());
        settings.setShowSyntheticMembers(options.getShowSyntheticMembers());
        settings.setExcludeNestedTypes(options.getExcludeNestedTypes());
        settings.setOutputDirectory(options.getOutputDirectory());
        settings.setIncludeLineNumbersInBytecode(options.getIncludeLineNumbers());
        settings.setRetainPointlessSwitches(options.getRetainPointlessSwitches());
        settings.setUnicodeOutputEnabled(options.isUnicodeOutputEnabled());
        settings.setMergeVariables(options.getMergeVariables());
        settings.setShowDebugLineNumbers(options.getShowDebugLineNumbers());
        settings.setSimplifyMemberReferences(options.getSimplifyMemberReferences());
        settings.setDisableForEachTransforms(options.getDisableForEachTransforms());
        settings.setTypeLoader((ITypeLoader)new InputTypeLoader());
        if (options.isRawBytecode()) {
            settings.setLanguage(Languages.bytecode());
        } else if (options.isBytecodeAst()) {
            settings.setLanguage(options.isUnoptimized() ? Languages.bytecodeAstUnoptimized() : Languages.bytecodeAst());
        }
        return settings;
    }

    @Override
    public String decompileClassNode(final ClassNode cn, byte[] b) {
        try {
            if (cn.version < 49) {
                b = this.fixBytes(b);
            }
            final byte[] bytesToUse = b;
            final Map<String, byte[]> loadedClasses = BytecodeViewer.getLoadedBytes();
            DecompilerSettings settings = this.getDecompilerSettings();
            MetadataSystem metadataSystem = new MetadataSystem(new ITypeLoader(){
                private InputTypeLoader backLoader = new InputTypeLoader();

                public boolean tryLoadType(String s, Buffer buffer) {
                    if (s.equals(cn.name)) {
                        buffer.putByteArray(bytesToUse, 0, bytesToUse.length);
                        buffer.position(0);
                        return true;
                    }
                    byte[] toUse = (byte[])loadedClasses.get(s + ".class");
                    if (toUse != null) {
                        buffer.putByteArray(toUse, 0, toUse.length);
                        buffer.position(0);
                        return true;
                    }
                    return this.backLoader.tryLoadType(s, buffer);
                }
            });
            TypeReference type = metadataSystem.lookupType(cn.name);
            DecompilationOptions decompilationOptions = new DecompilationOptions();
            decompilationOptions.setSettings(DecompilerSettings.javaDefaults());
            decompilationOptions.setFullDecompilation(true);
            TypeDefinition resolvedType = null;
            if (type == null || (resolvedType = type.resolve()) == null) {
                throw new Exception("Unable to resolve type.");
            }
            StringWriter stringwriter = new StringWriter();
            settings.getLanguage().decompileType(resolvedType, (ITextOutput)new PlainTextOutput((Writer)stringwriter), decompilationOptions);
            String decompiledSource = stringwriter.toString();
            return decompiledSource;
        }
        catch (Throwable e) {
            return this.parseException(e);
        }
    }

    @Override
    public void decompileToZip(String zipName) {
        File tempZip = new File(BytecodeViewer.tempDir, "temp.jar");
        if (tempZip.exists()) {
            tempZip.delete();
        }
        JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), tempZip.getAbsolutePath());
        try {
            this.doSaveJarDecompiled(tempZip, new File(zipName));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSaveJarDecompiled(File inFile, File outFile) throws Exception {
        try (JarFile jfile = new JarFile(inFile);
             FileOutputStream dest = new FileOutputStream(outFile);
             BufferedOutputStream buffDest = new BufferedOutputStream(dest);
             ZipOutputStream out = new ZipOutputStream(buffDest);){
            byte[] data = new byte[1024];
            DecompilerSettings settings = this.getDecompilerSettings();
            MetadataSystem metadataSystem = new MetadataSystem((ITypeLoader)new JarTypeLoader(jfile));
            DecompilationOptions decompilationOptions = new DecompilationOptions();
            decompilationOptions.setSettings(settings);
            decompilationOptions.setFullDecompilation(true);
            Enumeration<JarEntry> ent = jfile.entries();
            HashSet<JarEntry> history = new HashSet<JarEntry>();
            while (ent.hasMoreElements()) {
                JarEntry etn;
                JarEntry entry = ent.nextElement();
                if (entry.getName().endsWith(".class")) {
                    etn = new JarEntry(entry.getName().replace(".class", ".java"));
                    if (!history.add(etn)) continue;
                    out.putNextEntry(etn);
                    try {
                        String internalName = StringUtilities.removeRight((String)entry.getName(), (String)".class");
                        TypeReference type = metadataSystem.lookupType(internalName);
                        TypeDefinition resolvedType = null;
                        if (type == null || (resolvedType = type.resolve()) == null) {
                            throw new Exception("Unable to resolve type.");
                        }
                        OutputStreamWriter writer = new OutputStreamWriter(out);
                        settings.getLanguage().decompileType(resolvedType, (ITextOutput)new PlainTextOutput((Writer)writer), decompilationOptions);
                        ((Writer)writer).flush();
                        continue;
                    }
                    finally {
                        out.closeEntry();
                        continue;
                    }
                }
                try {
                    etn = new JarEntry(entry.getName());
                    if (history.add(etn)) continue;
                    history.add(etn);
                    out.putNextEntry(etn);
                    try {
                        InputStream in = jfile.getInputStream(entry);
                        if (in == null) continue;
                        try {
                            int count;
                            while ((count = in.read(data, 0, 1024)) != -1) {
                                out.write(data, 0, count);
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                catch (ZipException ze) {
                    if (ze.getMessage().contains("duplicate")) continue;
                    throw ze;
                    return;
                }
            }
        }
    }

    public static enum Settings implements DecompilerSettings.Setting
    {
        SHOW_DEBUG_LINE_NUMBERS("debug-line-numbers", "Show Debug Line Numbers"),
        SIMPLIFY_MEMBER_REFERENCES("simplify-member-references", "Simplify Member References"),
        MERGE_VARIABLES("merge-variables", "Merge Variables"),
        UNICODE_OUTPUT("unicode", "Allow Unicode Output"),
        RETAIN_POINTLESS_SWITCHES("retain-pointless-switches", "Retain pointless switches"),
        INCLUDE_LINE_NUMBERS_IN_BYTECODE("with-line-numbers", "Include line numbers in bytecode"),
        RETAIN_REDUNDANT_CASTS("retain-explicit-casts", "Retain redundant casts"),
        SHOW_SYNTHETIC_MEMBERS("show-synthetic", "Show synthetic members"),
        FORCE_EXPLICIT_TYPE_ARGS("explicit-type-arguments", "Force explicit type arguments"),
        FORCE_EXPLICIT_IMPORTS("explicit-imports", "Force explicit imports"),
        FLATTEN_SWITCH_BLOCKS("flatten-switch-blocks", "Flatten switch blocks"),
        EXCLUDE_NESTED_TYPES("exclude-nested", "Exclude nested types");

        private String name;
        private String param;
        private boolean on;

        private Settings(String param, String name) {
            this(param, name, false);
        }

        private Settings(String param, String name, boolean on) {
            this.name = name;
            this.param = param;
            this.on = on;
        }

        @Override
        public String getText() {
            return this.name;
        }

        @Override
        public boolean isDefaultOn() {
            return this.on;
        }

        @Override
        public String getParam() {
            return this.param;
        }
    }
}

