/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jf.baksmali.main;
import org.objectweb.asm.tree.ClassNode;
import org.zeroturnaround.zip.ZipUtil;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.Dex2Jar;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class SmaliDisassembler
extends Decompiler {
    @Override
    public String getName() {
        return "Smali";
    }

    @Override
    public String decompileClassNode(ClassNode cn, byte[] b) {
        String fileStart = BytecodeViewer.tempDir.getAbsolutePath() + BytecodeViewer.fs + "temp";
        String start = MiscUtils.getUniqueName(fileStart, ".class");
        File tempClass = new File(start + ".class");
        File tempZip = new File(start + ".jar");
        File tempDex = new File(start + ".dex");
        File tempSmali = new File(start + "-smali");
        try {
            FileOutputStream fos = new FileOutputStream(tempClass);
            fos.write(b);
            fos.close();
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
        ZipUtil.packEntry((File)tempClass, (File)tempZip);
        Dex2Jar.saveAsDex(tempZip, tempDex);
        try {
            main.main(new String[]{"-o", tempSmali.getAbsolutePath(), "-x", tempDex.getAbsolutePath()});
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        File outputSmali = null;
        boolean found = false;
        File current = tempSmali;
        while (!found) {
            File f = current.listFiles()[0];
            if (f.isDirectory()) {
                current = f;
                continue;
            }
            outputSmali = f;
            found = true;
        }
        try {
            return FileUtils.readFileToString(outputSmali, (String)"UTF-8");
        }
        catch (Exception e) {
            new ExceptionUI(e);
            return null;
        }
    }

    @Override
    public void decompileToZip(String zipName) {
    }
}

