/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers.bytecode;

import java.util.ArrayList;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.DecompilerSettings;
import the.bytecode.club.bytecodeviewer.FileContainer;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.FieldNodeDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.MethodNodeDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.PrefixedStringBuilder;

public class ClassNodeDecompiler
extends Decompiler {
    public ClassNodeDecompiler() {
        for (Settings setting : Settings.values()) {
            this.settings.registerSetting(setting);
        }
    }

    @Override
    public String getName() {
        return "Bytecode";
    }

    @Override
    public String decompileClassNode(ClassNode cn, byte[] b) {
        String containerName = null;
        for (FileContainer container : BytecodeViewer.files) {
            String name = cn.name + ".class";
            if (!container.getData().containsKey(name) || container.getClassNode(name) != cn) continue;
            containerName = container.name;
        }
        System.out.println(containerName);
        return ClassNodeDecompiler.decompile(new PrefixedStringBuilder(), new ArrayList<String>(), containerName, cn).toString();
    }

    protected static PrefixedStringBuilder decompile(PrefixedStringBuilder sb, ArrayList<String> decompiledClasses, String containerName, ClassNode cn) {
        int amountOfInterfaces;
        ArrayList<String> unableToDecompile = new ArrayList<String>();
        decompiledClasses.add(cn.name);
        sb.append(ClassNodeDecompiler.getAccessString(cn.access));
        sb.append(" ");
        sb.append(cn.name);
        if (cn.superName != null && !cn.superName.equals("java/lang/Object")) {
            sb.append(" extends ");
            sb.append(cn.superName);
        }
        if ((amountOfInterfaces = cn.interfaces.size()) > 0) {
            sb.append(" implements ");
            sb.append(cn.interfaces.get(0));
            if (amountOfInterfaces > 1) {
                // empty if block
            }
            for (int i = 1; i < amountOfInterfaces; ++i) {
                sb.append(", ");
                sb.append(cn.interfaces.get(i));
            }
        }
        sb.append(" {");
        sb.append(BytecodeViewer.nl);
        for (FieldNode fieldNode : cn.fields) {
            sb.append(BytecodeViewer.nl);
            sb.append("     ");
            FieldNodeDecompiler.decompile(sb, fieldNode);
        }
        if (cn.fields.size() > 0) {
            sb.append(BytecodeViewer.nl);
        }
        for (MethodNode methodNode : cn.methods) {
            sb.append(BytecodeViewer.nl);
            MethodNodeDecompiler.decompile(sb, methodNode, cn);
        }
        for (Object object : cn.innerClasses) {
            InnerClassNode innerClassNode = (InnerClassNode)object;
            String innerClassName = innerClassNode.name;
            if (innerClassName == null || decompiledClasses.contains(innerClassName)) continue;
            decompiledClasses.add(innerClassName);
            ClassNode cn1 = BytecodeViewer.getClassNode(containerName, innerClassName);
            if (cn1 != null) {
                sb.appendPrefix("     ");
                sb.append(BytecodeViewer.nl + BytecodeViewer.nl);
                sb = ClassNodeDecompiler.decompile(sb, decompiledClasses, containerName, cn1);
                sb.trimPrefix(5);
                sb.append(BytecodeViewer.nl);
                continue;
            }
            unableToDecompile.add(innerClassName);
        }
        if (!unableToDecompile.isEmpty()) {
            sb.append("//the following inner classes couldn't be decompiled: ");
            for (String string : unableToDecompile) {
                sb.append(string);
                sb.append(" ");
            }
            sb.append(BytecodeViewer.nl);
        }
        sb.append("}");
        return sb;
    }

    public static String getAccessString(int access) {
        ArrayList<String> tokens = new ArrayList<String>();
        if ((access & 1) != 0) {
            tokens.add("public");
        }
        if ((access & 2) != 0) {
            tokens.add("private");
        }
        if ((access & 4) != 0) {
            tokens.add("protected");
        }
        if ((access & 0x10) != 0) {
            tokens.add("final");
        }
        if ((access & 0x1000) != 0) {
            tokens.add("synthetic");
        }
        if ((access & 0x400) != 0) {
            tokens.add("abstract");
        }
        if ((access & 0x200) != 0) {
            tokens.add("interface");
        }
        if ((access & 0x4000) != 0) {
            tokens.add("enum");
        }
        if ((access & 0x2000) != 0) {
            tokens.add("annotation");
        }
        if (!(tokens.contains("interface") || tokens.contains("enum") || tokens.contains("annotation"))) {
            tokens.add("class");
        }
        if (tokens.size() == 0) {
            return "[Error parsing]";
        }
        StringBuilder sb = new StringBuilder((String)tokens.get(0));
        for (int i = 1; i < tokens.size(); ++i) {
            sb.append(" ");
            sb.append((String)tokens.get(i));
        }
        return sb.toString();
    }

    @Override
    public void decompileToZip(String zipName) {
    }

    public static enum Settings implements DecompilerSettings.Setting
    {
        DEBUG_HELPERS("debug-helpers", "Debug Helpers", true),
        APPEND_BRACKETS_TO_LABELS("append-brackets-to-labels", "Append Brackets to Labels", true);

        private String name;
        private String param;
        private boolean on;

        private Settings(String param, String name) {
            this(param, name, false);
        }

        private Settings(String param, String name, boolean on) {
            this.name = name;
            this.param = param;
            this.on = on;
        }

        @Override
        public String getText() {
            return this.name;
        }

        @Override
        public boolean isDefaultOn() {
            return this.on;
        }

        @Override
        public String getParam() {
            return this.param;
        }
    }
}

