/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers.bytecode;

import eu.bibl.banalysis.asm.desc.OpcodeInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.ClassNodeDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.InstructionPattern;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.InstructionSearcher;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.TypeAndName;

public class InstructionPrinter {
    protected MethodNode mNode;
    private TypeAndName[] args;
    protected int[] pattern;
    protected boolean match;
    protected InstructionSearcher searcher;
    protected List<AbstractInsnNode> matchedInsns;
    protected Map<LabelNode, Integer> labels;

    public InstructionPrinter(MethodNode m, TypeAndName[] args) {
        this.args = args;
        this.mNode = m;
        this.labels = new HashMap<LabelNode, Integer>();
        this.match = false;
    }

    public InstructionPrinter(MethodNode m, InstructionPattern pattern, TypeAndName[] args) {
        this.args = args;
        this.mNode = m;
        this.labels = new HashMap<LabelNode, Integer>();
        this.searcher = new InstructionSearcher(m.instructions, pattern);
        this.match = this.searcher.search();
        if (this.match) {
            for (AbstractInsnNode[] ains : this.searcher.getMatches()) {
                for (AbstractInsnNode ain : ains) {
                    this.matchedInsns.add(ain);
                }
            }
        }
    }

    public ArrayList<String> createPrint() {
        ArrayList<String> info = new ArrayList<String>();
        ListIterator<AbstractInsnNode> it = this.mNode.instructions.iterator();
        boolean firstLabel = false;
        while (it.hasNext()) {
            AbstractInsnNode ain = it.next();
            String line = "";
            if (ain instanceof VarInsnNode) {
                line = this.printVarInsnNode((VarInsnNode)ain, it);
            } else if (ain instanceof IntInsnNode) {
                line = this.printIntInsnNode((IntInsnNode)ain, it);
            } else if (ain instanceof FieldInsnNode) {
                line = this.printFieldInsnNode((FieldInsnNode)ain, it);
            } else if (ain instanceof MethodInsnNode) {
                line = this.printMethodInsnNode((MethodInsnNode)ain, it);
            } else if (ain instanceof LdcInsnNode) {
                line = this.printLdcInsnNode((LdcInsnNode)ain, it);
            } else if (ain instanceof InsnNode) {
                line = this.printInsnNode((InsnNode)ain, it);
            } else if (ain instanceof JumpInsnNode) {
                line = this.printJumpInsnNode((JumpInsnNode)ain, it);
            } else if (ain instanceof LineNumberNode) {
                line = this.printLineNumberNode((LineNumberNode)ain, it);
            } else if (ain instanceof LabelNode) {
                if (firstLabel && Decompiler.BYTECODE.getSettings().isSelected(ClassNodeDecompiler.Settings.APPEND_BRACKETS_TO_LABELS)) {
                    info.add("}");
                }
                line = this.printLabelnode((LabelNode)ain);
                if (Decompiler.BYTECODE.getSettings().isSelected(ClassNodeDecompiler.Settings.APPEND_BRACKETS_TO_LABELS)) {
                    if (!firstLabel) {
                        firstLabel = true;
                    }
                    line = line + " {";
                }
            } else {
                line = ain instanceof TypeInsnNode ? this.printTypeInsnNode((TypeInsnNode)ain) : (ain instanceof FrameNode ? "" : (ain instanceof IincInsnNode ? this.printIincInsnNode((IincInsnNode)ain) : (ain instanceof TableSwitchInsnNode ? this.printTableSwitchInsnNode((TableSwitchInsnNode)ain) : (ain instanceof LookupSwitchInsnNode ? this.printLookupSwitchInsnNode((LookupSwitchInsnNode)ain) : (ain instanceof InvokeDynamicInsnNode ? this.printInvokeDynamicInsNode((InvokeDynamicInsnNode)ain) : line + "UNADDED OPCODE: " + this.nameOpcode(ain.opcode()) + " " + ain.toString())))));
            }
            if (line.equals("")) continue;
            if (this.match && this.matchedInsns.contains(ain)) {
                line = "   -> " + line;
            }
            info.add(line);
        }
        if (firstLabel && Decompiler.BYTECODE.getSettings().isSelected(ClassNodeDecompiler.Settings.APPEND_BRACKETS_TO_LABELS)) {
            info.add("}");
        }
        return info;
    }

    protected String printVarInsnNode(VarInsnNode vin, ListIterator<?> it) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameOpcode(vin.opcode()));
        sb.append(vin.var);
        if (Decompiler.BYTECODE.getSettings().isSelected(ClassNodeDecompiler.Settings.DEBUG_HELPERS)) {
            if (vin.var == 0 && !Modifier.isStatic(this.mNode.access)) {
                sb.append(" // reference to self");
            } else {
                int refIndex = vin.var - (Modifier.isStatic(this.mNode.access) ? 0 : 1);
                if (refIndex >= 0 && refIndex < this.args.length - 1) {
                    sb.append(" // reference to " + this.args[refIndex].name);
                }
            }
        }
        return sb.toString();
    }

    protected String printIntInsnNode(IntInsnNode iin, ListIterator<?> it) {
        return this.nameOpcode(iin.opcode()) + " " + iin.operand;
    }

    protected String printFieldInsnNode(FieldInsnNode fin, ListIterator<?> it) {
        String desc = Type.getType(fin.desc).getClassName();
        if (desc == null || desc.equals("null")) {
            desc = fin.desc;
        }
        return this.nameOpcode(fin.opcode()) + " " + fin.owner + "." + fin.name + ":" + desc;
    }

    protected String printMethodInsnNode(MethodInsnNode min, ListIterator<?> it) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameOpcode(min.opcode()) + " " + min.owner + " " + min.name + "(");
        String desc = min.desc;
        try {
            if (Type.getType(min.desc) != null) {
                desc = Type.getType(min.desc).getClassName();
            }
            if (desc == null || desc.equals("null")) {
                desc = min.desc;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(desc);
        sb.append(");");
        return sb.toString();
    }

    protected String printLdcInsnNode(LdcInsnNode ldc, ListIterator<?> it) {
        if (ldc.cst instanceof String) {
            return this.nameOpcode(ldc.opcode()) + " \"" + StringEscapeUtils.escapeJava((String)ldc.cst.toString()) + "\" (" + ldc.cst.getClass().getCanonicalName() + ")";
        }
        return this.nameOpcode(ldc.opcode()) + " " + StringEscapeUtils.escapeJava((String)ldc.cst.toString()) + " (" + ldc.cst.getClass().getCanonicalName() + ")";
    }

    protected String printInsnNode(InsnNode in, ListIterator<?> it) {
        return this.nameOpcode(in.opcode());
    }

    protected String printJumpInsnNode(JumpInsnNode jin, ListIterator<?> it) {
        String line = this.nameOpcode(jin.opcode()) + " L" + this.resolveLabel(jin.label);
        return line;
    }

    protected String printLineNumberNode(LineNumberNode lin, ListIterator<?> it) {
        return "";
    }

    protected String printLabelnode(LabelNode label) {
        return "L" + this.resolveLabel(label);
    }

    protected String printTypeInsnNode(TypeInsnNode tin) {
        try {
            String desc = tin.desc;
            try {
                if (Type.getType(tin.desc) != null) {
                    desc = Type.getType(tin.desc).getClassName();
                }
                if (desc == null || desc.equals("null")) {
                    desc = tin.desc;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return this.nameOpcode(tin.opcode()) + " " + desc;
        }
        catch (Exception e) {
            new ExceptionUI(e);
            return "//error";
        }
    }

    protected String printIincInsnNode(IincInsnNode iin) {
        return this.nameOpcode(iin.opcode()) + " " + iin.var + " " + iin.incr;
    }

    protected String printTableSwitchInsnNode(TableSwitchInsnNode tin) {
        String line = this.nameOpcode(tin.opcode()) + " \n";
        List<LabelNode> labels = tin.labels;
        int count = 0;
        for (int i = tin.min; i < tin.max + 1; ++i) {
            line = line + "                val: " + i + " -> L" + this.resolveLabel(labels.get(count++)) + "\n";
        }
        line = line + "                default -> L" + this.resolveLabel(tin.dflt) + "";
        return line;
    }

    protected String printLookupSwitchInsnNode(LookupSwitchInsnNode lin) {
        String line = this.nameOpcode(lin.opcode()) + ": \n";
        List<Integer> keys = lin.keys;
        List<LabelNode> labels = lin.labels;
        for (int i = 0; i < keys.size(); ++i) {
            int key = keys.get(i);
            LabelNode label = labels.get(i);
            line = line + "                val: " + key + " -> L" + this.resolveLabel(label) + "\n";
        }
        line = line + "                default -> L" + this.resolveLabel(lin.dflt) + "";
        return line;
    }

    protected String printInvokeDynamicInsNode(InvokeDynamicInsnNode idin) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nameOpcode(idin.opcode()) + " " + idin.bsm.getName() + "(");
        String desc = idin.desc;
        String partedDesc = idin.desc.substring(2);
        try {
            if (Type.getType(partedDesc) != null) {
                desc = Type.getType(partedDesc).getClassName();
            }
            if (desc == null || desc.equals("null")) {
                desc = idin.desc;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(desc);
        sb.append(");");
        return sb.toString();
    }

    protected String nameOpcode(int opcode) {
        return "    " + ((String)OpcodeInfo.OPCODES.get(opcode)).toLowerCase();
    }

    protected int resolveLabel(LabelNode label) {
        if (this.labels.containsKey(label)) {
            return this.labels.get(label);
        }
        int newLabelIndex = this.labels.size() + 1;
        this.labels.put(label, newLabelIndex);
        return newLabelIndex;
    }

    public static void saveTo(File file, InstructionPrinter printer) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            for (String s : printer.createPrint()) {
                bw.write(s);
                bw.newLine();
            }
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
    }
}

