/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.ClassNodeDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.InstructionPrinter;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.PrefixedStringBuilder;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.TypeAndName;

public class MethodNodeDecompiler {
    public static PrefixedStringBuilder decompile(PrefixedStringBuilder sb, MethodNode m, ClassNode cn) {
        int amountOfThrows;
        int i;
        String package_ = null;
        String class_ = null;
        if (cn.name.contains("/")) {
            package_ = cn.name.substring(0, cn.name.lastIndexOf("/"));
            class_ = cn.name.substring(cn.name.lastIndexOf("/") + 1);
        } else {
            class_ = cn.name;
        }
        String s = MethodNodeDecompiler.getAccessString(m.access);
        sb.append("     ");
        sb.append(s);
        if (s.length() > 0) {
            sb.append(" ");
        }
        if (m.name.equals("<init>")) {
            sb.append(class_);
        } else if (!m.name.equals("<clinit>")) {
            sb.append(m.name);
        }
        TypeAndName[] args = new TypeAndName[]{};
        if (!m.name.equals("<clinit>")) {
            sb.append("(");
            Type[] argTypes = Type.getArgumentTypes(m.desc);
            args = new TypeAndName[argTypes.length];
            for (i = 0; i < argTypes.length; ++i) {
                String argName;
                Type type = argTypes[i];
                TypeAndName tan = new TypeAndName();
                tan.name = argName = "arg" + i;
                tan.type = type;
                args[i] = tan;
                sb.append(type.getClassName() + " " + argName + (i < argTypes.length - 1 ? ", " : ""));
            }
            sb.append(")");
        }
        if ((amountOfThrows = m.exceptions.size()) > 0) {
            sb.append(" throws ");
            sb.append(m.exceptions.get(0));
            for (i = 1; i < amountOfThrows; ++i) {
                sb.append(", ");
                sb.append(m.exceptions.get(i));
            }
        }
        if (s.contains("abstract")) {
            sb.append(" {}");
            sb.append(" //");
            sb.append(m.desc);
            sb.append(BytecodeViewer.nl);
        } else {
            sb.append(" {");
            if (Decompiler.BYTECODE.getSettings().isSelected(ClassNodeDecompiler.Settings.DEBUG_HELPERS)) {
                if (m.name.equals("<clinit>")) {
                    sb.append(" // <clinit>");
                } else if (m.name.equals("<init>")) {
                    sb.append(" // <init>");
                }
            }
            sb.append(" //");
            sb.append(m.desc);
            sb.append(BytecodeViewer.nl);
            if (m.signature != null) {
                sb.append("         <sig:").append(m.signature).append(">");
            }
            if (m.annotationDefault != null) {
                sb.append(m.annotationDefault);
                sb.append("\n");
            }
            InstructionPrinter insnPrinter = new InstructionPrinter(m, args);
            MethodNodeDecompiler.addAttrList(m.attrs, "attr", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.invisibleAnnotations, "invisAnno", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.invisibleAnnotations, "invisLocalVarAnno", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.invisibleTypeAnnotations, "invisTypeAnno", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.localVariables, "localVar", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.visibleAnnotations, "visAnno", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.visibleLocalVariableAnnotations, "visLocalVarAnno", sb, insnPrinter);
            MethodNodeDecompiler.addAttrList(m.visibleTypeAnnotations, "visTypeAnno", sb, insnPrinter);
            Iterator<Object> iterator = m.tryCatchBlocks.iterator();
            while (iterator.hasNext()) {
                TryCatchBlockNode o;
                TryCatchBlockNode tcbn = o = iterator.next();
                sb.append("         ");
                sb.append("TryCatch: L");
                sb.append(insnPrinter.resolveLabel(tcbn.start));
                sb.append(" to L");
                sb.append(insnPrinter.resolveLabel(tcbn.end));
                sb.append(" handled by L");
                sb.append(insnPrinter.resolveLabel(tcbn.handler));
                sb.append(": ");
                if (tcbn.type != null) {
                    sb.append(tcbn.type);
                } else {
                    sb.append("Type is null.");
                }
                sb.append(BytecodeViewer.nl);
            }
            for (String insn : insnPrinter.createPrint()) {
                sb.append("         ");
                sb.append(insn);
                sb.append(BytecodeViewer.nl);
            }
            sb.append("     }" + BytecodeViewer.nl);
        }
        return sb;
    }

    private static void addAttrList(List<?> list, String name, PrefixedStringBuilder sb, InstructionPrinter insnPrinter) {
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            for (Object o : list) {
                sb.append("         <");
                sb.append(name);
                sb.append(":");
                sb.append(MethodNodeDecompiler.printAttr(o, insnPrinter));
                sb.append(">");
                sb.append("\n");
            }
            sb.append("\n");
        }
    }

    private static String printAttr(Object o, InstructionPrinter insnPrinter) {
        if (o instanceof LocalVariableNode) {
            LocalVariableNode lvn = (LocalVariableNode)o;
            return "index=" + lvn.index + " , name=" + lvn.name + " , desc=" + lvn.desc + ", sig=" + lvn.signature + ", start=L" + insnPrinter.resolveLabel(lvn.start) + ", end=L" + insnPrinter.resolveLabel(lvn.end);
        }
        if (o instanceof AnnotationNode) {
            AnnotationNode an = (AnnotationNode)o;
            StringBuilder sb = new StringBuilder();
            sb.append("desc = ");
            sb.append(an.desc);
            sb.append(" , values = ");
            if (an.values != null) {
                sb.append(Arrays.toString(an.values.toArray()));
            } else {
                sb.append("[]");
            }
            return sb.toString();
        }
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private static String getAccessString(int access) {
        ArrayList<String> tokens = new ArrayList<String>();
        if ((access & 1) != 0) {
            tokens.add("public");
        }
        if ((access & 2) != 0) {
            tokens.add("private");
        }
        if ((access & 4) != 0) {
            tokens.add("protected");
        }
        if ((access & 8) != 0) {
            tokens.add("static");
        }
        if ((access & 0x400) != 0) {
            tokens.add("abstract");
        }
        if ((access & 0x10) != 0) {
            tokens.add("final");
        }
        if ((access & 0x20) != 0) {
            tokens.add("synchronized");
        }
        if ((access & 0x100) != 0) {
            tokens.add("native");
        }
        if ((access & 0x800) != 0) {
            tokens.add("strictfp");
        }
        if ((access & 0x40) != 0) {
            tokens.add("bridge");
        }
        if ((access & 0x80) != 0) {
            tokens.add("varargs");
        }
        if (tokens.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder((String)tokens.get(0));
        for (int i = 1; i < tokens.size(); ++i) {
            sb.append(" ");
            sb.append((String)tokens.get(i));
        }
        return sb.toString();
    }
}

