/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import com.jhe.hexed.JHexEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.Resources;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.gui.MainViewerGUI;
import the.bytecode.club.bytecodeviewer.gui.Methods;
import the.bytecode.club.bytecodeviewer.gui.PaneUpdaterThread;
import the.bytecode.club.bytecodeviewer.gui.Viewer;

public class ClassViewer
extends Viewer {
    private static final long serialVersionUID = -8650495368920680024L;
    private final MainViewerGUI gui = BytecodeViewer.viewer;
    private List<Thread> decompileThreads = new ArrayList<Thread>();
    JSplitPane sp;
    JSplitPane sp2;
    public List<Decompiler> decompilers = Arrays.asList(null, null, null);
    public List<JPanel> panels = Arrays.asList(new JPanel(new BorderLayout()), new JPanel(new BorderLayout()), new JPanel(new BorderLayout()));
    public List<JPanel> searches = Arrays.asList(new JPanel(new BorderLayout()), new JPanel(new BorderLayout()), new JPanel(new BorderLayout()));
    public List<JCheckBox> exacts = Arrays.asList(new JCheckBox("Exact"), new JCheckBox("Exact"), new JCheckBox("Exact"));
    public List<JTextField> fields = Arrays.asList(new JTextField(), new JTextField(), new JTextField());
    public List<Methods> methods = Arrays.asList(new Methods(), new Methods(), new Methods());
    public List<Integer> activeLines = Arrays.asList(0, 0, 0);
    public List<RSyntaxTextArea> javas = Arrays.asList(null, null, null);
    public List<RSyntaxTextArea> smalis = Arrays.asList(null, null, null);
    public List<RSyntaxTextArea> krakataus = Arrays.asList(null, null, null);
    private DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 62, 150));

    public void setPanes() {
        for (int i = 0; i < this.gui.allPanes.size(); ++i) {
            ButtonGroup group = this.gui.allPanes.get(i);
            for (Map.Entry<JRadioButtonMenuItem, Decompiler> entry : this.gui.allDecompilers.get(group).entrySet()) {
                if (!group.isSelected(entry.getKey().getModel())) continue;
                this.decompilers.set(i, entry.getValue());
            }
        }
    }

    public boolean isPaneEditable(int pane) {
        this.setPanes();
        ButtonGroup buttonGroup = this.gui.allPanes.get(pane);
        Decompiler selected = this.decompilers.get(pane);
        return buttonGroup != null && this.gui.editButtons.get(buttonGroup) != null && this.gui.editButtons.get(buttonGroup).get(selected) != null && this.gui.editButtons.get(buttonGroup).get(selected).isSelected();
    }

    public void requestFocus(int pane) {
        this.fields.get(pane).requestFocus();
    }

    public void updatePane(int pane, RSyntaxTextArea text, Decompiler decompiler) {
        if (decompiler == Decompiler.KRAKATAU_DA) {
            this.krakataus.set(pane, text);
        } else if (decompiler == Decompiler.SMALI) {
            this.smalis.set(pane, text);
        } else {
            this.javas.set(pane, text);
        }
    }

    public static JSplitPane setDividerLocation(final JSplitPane splitter, final double proportion) {
        if (splitter.isShowing()) {
            if (splitter.getWidth() > 0 && splitter.getHeight() > 0) {
                splitter.setDividerLocation(proportion);
            } else {
                splitter.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent ce) {
                        splitter.removeComponentListener(this);
                        ClassViewer.setDividerLocation(splitter, proportion);
                    }
                });
            }
        } else {
            splitter.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && splitter.isShowing()) {
                        splitter.removeHierarchyListener(this);
                        ClassViewer.setDividerLocation(splitter, proportion);
                    }
                }
            });
        }
        return splitter;
    }

    public static void selectMethod(RSyntaxTextArea area, int methodLine) {
        if (methodLine != area.getCaretLineNumber()) {
            ClassViewer.setCaretLine(area, methodLine);
            ClassViewer.setViewLine(area, methodLine);
        }
    }

    public static void selectMethod(ClassViewer classViewer, int paneId, Methods.Method method) {
        int methodLine;
        Methods methods;
        RSyntaxTextArea area = classViewer.javas.get(paneId);
        if (area != null && (methods = classViewer.methods.get(paneId)) != null && (methodLine = methods.findMethod(method)) != -1) {
            ClassViewer.selectMethod(area, methodLine);
        }
    }

    public static String getLineText(RSyntaxTextArea area, int line) {
        try {
            if (line < area.getLineCount()) {
                int start = area.getLineStartOffset(line);
                int end = area.getLineEndOffset(line);
                return area.getText(start, end - start).trim();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    public static int getMaxViewLine(RSyntaxTextArea area) {
        Container parent = area.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            int y = viewport.getViewSize().height - viewport.getExtentSize().height;
            int lineHeight = area.getLineHeight();
            return y >= lineHeight ? y / lineHeight : 0;
        }
        return 0;
    }

    public static int getViewLine(RSyntaxTextArea area) {
        Container parent = area.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Point point = viewport.getViewPosition();
            int lineHeight = area.getLineHeight();
            return point.y >= lineHeight ? point.y / lineHeight : 0;
        }
        return 0;
    }

    public static void setViewLine(RSyntaxTextArea area, int line) {
        Container parent = area.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            int maxLine = ClassViewer.getMaxViewLine(area);
            line = line < maxLine ? line : maxLine;
            viewport.setViewPosition(new Point(0, line * area.getLineHeight()));
        }
    }

    public static void setCaretLine(RSyntaxTextArea area, int line) {
        try {
            area.setCaretPosition(area.getLineStartOffset(line));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void search(int pane, String search, boolean next) {
        try {
            Component[] com;
            for (Component c : com = this.panels.get(pane).getComponents()) {
                if (!(c instanceof RTextScrollPane)) continue;
                RSyntaxTextArea area = (RSyntaxTextArea)((RTextScrollPane)c).getViewport().getComponent(0);
                if (search.isEmpty()) {
                    this.highlight(pane, (JTextComponent)area, "");
                    return;
                }
                int startLine = area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition()) + 1;
                int currentLine = 1;
                boolean canSearch = false;
                String[] test = null;
                test = area.getText().split("\n").length >= 2 ? area.getText().split("\n") : area.getText().split("\r");
                int lastGoodLine = -1;
                int firstPos = -1;
                boolean found = false;
                if (next) {
                    for (String s : test) {
                        if (pane == 0 && !this.exacts.get(0).isSelected() || pane == 1 && !this.exacts.get(1).isSelected()) {
                            s = s.toLowerCase();
                            search = search.toLowerCase();
                        }
                        if (currentLine == startLine) {
                            canSearch = true;
                        } else if (s.contains(search)) {
                            if (canSearch) {
                                area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(currentLine - 1).getStartOffset());
                                canSearch = false;
                                found = true;
                            }
                            if (firstPos == -1) {
                                firstPos = currentLine;
                            }
                        }
                        ++currentLine;
                    }
                    if (!found && firstPos != -1) {
                        area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(firstPos - 1).getStartOffset());
                    }
                } else {
                    canSearch = true;
                    for (String s : test) {
                        if (pane == 0 && !this.exacts.get(0).isSelected() || pane == 1 && !this.exacts.get(1).isSelected() || pane == 2 && !this.exacts.get(2).isSelected()) {
                            s = s.toLowerCase();
                            search = search.toLowerCase();
                        }
                        if (s.contains(search)) {
                            if (lastGoodLine != -1 && canSearch) {
                                area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(lastGoodLine - 1).getStartOffset());
                            }
                            lastGoodLine = currentLine;
                            if (currentLine >= startLine) {
                                canSearch = false;
                            }
                        }
                        ++currentLine;
                    }
                    if (lastGoodLine != -1 && area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition()) + 1 == startLine) {
                        area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(lastGoodLine - 1).getStartOffset());
                    }
                }
                this.highlight(pane, (JTextComponent)area, search);
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public void highlight(int pane, JTextComponent textComp, String pattern) {
        if (pattern.isEmpty()) {
            textComp.getHighlighter().removeAllHighlights();
            return;
        }
        try {
            Highlighter hilite = textComp.getHighlighter();
            hilite.removeAllHighlights();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            int pos = 0;
            if (pane == 0 && !this.exacts.get(0).isSelected() || pane == 1 && !this.exacts.get(1).isSelected() || pane == 2 && !this.exacts.get(2).isSelected()) {
                pattern = pattern.toLowerCase();
                text = text.toLowerCase();
            }
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                hilite.addHighlight(pos, pos + pattern.length(), this.painter);
                pos += pattern.length();
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public ClassViewer(String name, String container, ClassNode cn) {
        for (int i = 0; i < this.panels.size(); ++i) {
            final JTextField textField = this.fields.get(i);
            JPanel searchPanel = this.searches.get(i);
            JCheckBox checkBox = this.exacts.get(i);
            JButton byteSearchNext = new JButton();
            JButton byteSearchPrev = new JButton();
            JPanel byteButtonPane = new JPanel(new BorderLayout());
            byteButtonPane.add((Component)byteSearchNext, "West");
            byteButtonPane.add((Component)byteSearchPrev, "East");
            byteSearchNext.setIcon(Resources.nextIcon);
            byteSearchPrev.setIcon(Resources.prevIcon);
            searchPanel.add((Component)byteButtonPane, "West");
            searchPanel.add((Component)textField, "Center");
            searchPanel.add((Component)checkBox, "East");
            byteSearchNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ClassViewer.this.search(0, textField.getText(), true);
                }
            });
            byteSearchPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ClassViewer.this.search(0, textField.getText(), false);
                }
            });
            textField.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent arg0) {
                    if (arg0.getKeyCode() == 10) {
                        ClassViewer.this.search(0, textField.getText(), true);
                    }
                }

                @Override
                public void keyPressed(KeyEvent arg0) {
                }

                @Override
                public void keyTyped(KeyEvent arg0) {
                }
            });
        }
        this.name = name;
        this.container = container;
        this.cn = cn;
        this.updateName();
        this.setLayout(new BorderLayout());
        this.sp = new JSplitPane(1, this.panels.get(0), this.panels.get(1));
        JHexEditor hex = new JHexEditor(BytecodeViewer.getClassBytes(container, cn.name + ".class"));
        this.sp2 = new JSplitPane(1, this.sp, this.panels.get(2));
        this.add((Component)this.sp2, "Center");
        hex.setMaximumSize(new Dimension(0, Integer.MAX_VALUE));
        hex.setSize(0, Integer.MAX_VALUE);
        this.gui.setIcon(true);
        this.startPaneUpdater(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ClassViewer.this.resetDivider();
            }
        });
    }

    public void resetDivider() {
        this.sp.setResizeWeight(0.5);
        if (this.decompilers.get(1) != null && this.decompilers.get(0) != null) {
            this.sp = ClassViewer.setDividerLocation(this.sp, 0.5);
        } else if (this.decompilers.get(0) != null) {
            this.sp = ClassViewer.setDividerLocation(this.sp, 1.0);
        } else if (this.decompilers.get(1) != null) {
            this.sp.setResizeWeight(1.0);
            this.sp = ClassViewer.setDividerLocation(this.sp, 0.0);
        } else {
            this.sp = ClassViewer.setDividerLocation(this.sp, 0.0);
        }
        if (this.decompilers.get(2) != null) {
            this.sp2.setResizeWeight(0.7);
            this.sp2 = ClassViewer.setDividerLocation(this.sp2, 0.7);
            if (this.decompilers.get(1) == null && this.decompilers.get(0) != null || this.decompilers.get(0) == null && this.decompilers.get(1) != null) {
                this.sp2 = ClassViewer.setDividerLocation(this.sp2, 0.5);
            } else if (this.decompilers.get(0) == null && this.decompilers.get(1) == null) {
                this.sp2 = ClassViewer.setDividerLocation(this.sp2, 0.0);
            }
        } else {
            this.sp.setResizeWeight(1.0);
            this.sp2.setResizeWeight(0.0);
            this.sp2 = ClassViewer.setDividerLocation(this.sp2, 1.0);
        }
    }

    public void startPaneUpdater(JButton button) {
        int i;
        this.cn = BytecodeViewer.getClassNode(this.container, this.cn.name);
        this.setPanes();
        for (JPanel jpanel : this.panels) {
            jpanel.removeAll();
        }
        for (i = 0; i < this.javas.size(); ++i) {
            this.javas.set(i, null);
        }
        for (i = 0; i < this.smalis.size(); ++i) {
            this.smalis.set(i, null);
        }
        if (this.cn == null) {
            for (JPanel jpanel : this.panels) {
                jpanel.add(new JLabel("This file has been removed from the reload."));
            }
            return;
        }
        for (i = 0; i < this.decompilers.size(); ++i) {
            if (this.decompilers.get(i) == null) continue;
            if (this.decompilers.get(i) != Decompiler.HEXCODE) {
                this.panels.get(i).add((Component)this.searches.get(i), "North");
            }
            PaneUpdaterThread t = new PaneUpdaterThread(this, this.decompilers.get(i), i, this.panels.get(i), button);
            this.decompileThreads.add(t);
            t.start();
        }
    }

    public Object[] getSmali() {
        for (int i = 0; i < this.smalis.size(); ++i) {
            RSyntaxTextArea text = this.smalis.get(i);
            if (text == null) continue;
            return new Object[]{this.cn, text.getText()};
        }
        return null;
    }

    public Object[] getKrakatau() {
        for (int i = 0; i < this.krakataus.size(); ++i) {
            RSyntaxTextArea text = this.krakataus.get(i);
            if (text == null) continue;
            return new Object[]{this.cn, text.getText()};
        }
        return null;
    }

    public Object[] getJava() {
        for (int i = 0; i < this.javas.size(); ++i) {
            RSyntaxTextArea text = this.javas.get(i);
            if (text == null) continue;
            return new Object[]{this.cn, text.getText()};
        }
        return null;
    }

    public void reset() {
        for (Thread t : this.decompileThreads) {
            t.stop();
        }
    }

    static class SynchronizeActionListener
    implements ActionListener {
        private ClassViewer classViewer;
        private int activePaneId;

        public SynchronizeActionListener(ClassViewer classViewer, int paneId) {
            this.classViewer = classViewer;
            this.activePaneId = paneId;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int activeLine;
            int activeMethodLine;
            Methods activeMethods;
            RSyntaxTextArea activeArea;
            int activePanes = 0;
            for (int i = 0; i < this.classViewer.javas.size(); ++i) {
                if (this.classViewer.javas.get(i) == null) continue;
                ++activePanes;
            }
            if (activePanes > 1 && (activeArea = this.classViewer.javas.get(this.activePaneId)) != null && (activeMethods = this.classViewer.methods.get(this.activePaneId)) != null && (activeMethodLine = activeMethods.findActiveMethod(activeLine = this.classViewer.activeLines.get(this.activePaneId).intValue())) != -1) {
                ClassViewer.selectMethod(activeArea, activeMethodLine);
                Methods.Method activeMethod = activeMethods.getMethod(activeMethodLine);
                if (activeMethod != null) {
                    for (int i = 0; i < this.classViewer.javas.size(); ++i) {
                        int methodLine;
                        Methods methods;
                        RSyntaxTextArea area;
                        if (i == this.activePaneId || (area = this.classViewer.javas.get(i)) == null || (methods = this.classViewer.methods.get(i)) == null || (methodLine = methods.findMethod(activeMethod)) == -1) continue;
                        ClassViewer.selectMethod(area, methodLine);
                    }
                }
            }
        }
    }
}

