/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.Settings;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;

public class FileChooser {
    private Settings<String> target;
    private String message;

    public FileChooser(Settings<String> target, String message) {
        this.target = target;
        this.message = message;
    }

    public void run() {
        File currentFile = new File(this.target.get() == null || this.target.get().isEmpty() ? System.getProperty("user.home") : this.target.get());
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return FileChooser.this.message;
            }
        });
        if (currentFile.isDirectory()) {
            fc.setCurrentDirectory(currentFile);
        } else {
            fc.setSelectedFile(currentFile);
        }
        fc.setFileHidingEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showOpenDialog(BytecodeViewer.viewer);
        if (returnVal == 0) {
            try {
                this.target.set(fc.getSelectedFile().getAbsolutePath());
            }
            catch (Exception e1) {
                new ExceptionUI(e1);
            }
        }
    }
}

