/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.FileChangeNotifier;
import the.bytecode.club.bytecodeviewer.FileContainer;
import the.bytecode.club.bytecodeviewer.FileDrop;
import the.bytecode.club.bytecodeviewer.Resources;
import the.bytecode.club.bytecodeviewer.gui.VisibleComponent;

public class FileNavigationPane
extends VisibleComponent
implements FileDrop.Listener {
    private static final String quickSearchText = "Quick file search (no file extension)";
    FileChangeNotifier fcn;
    JCheckBox exact = new JCheckBox("Exact");
    JButton open = new JButton("+");
    JButton close = new JButton("-");
    MyTreeNode treeRoot = new MyTreeNode("Loaded Files:");
    MyTree tree = new MyTree(this.treeRoot);
    final JTextField quickSearch = new JTextField("Quick file search (no file extension)");
    public transient KeyAdapter search = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent ke) {
            block12: {
                if (ke.getKeyCode() == 10) {
                    int i;
                    String qt = FileNavigationPane.this.quickSearch.getText();
                    FileNavigationPane.this.quickSearch.setText("");
                    String[] path = null;
                    if (qt.contains(".")) {
                        path = qt.split("\\.");
                        String[] path2 = new String[path.length];
                        for (i = 0; i < path.length; ++i) {
                            path2[i] = path[i];
                            if (i + 2 != path.length) continue;
                            path2[i + 1] = "." + path[i + 1];
                        }
                    } else {
                        path = new String[]{qt};
                    }
                    MyTreeNode curNode = FileNavigationPane.this.treeRoot;
                    if (FileNavigationPane.this.exact.isSelected()) {
                        block1: for (i = 0; i < path.length; ++i) {
                            String pathName = path[i];
                            boolean isLast = i == path.length - 1;
                            for (int c = 0; c < curNode.getChildCount(); ++c) {
                                MyTreeNode child = (MyTreeNode)curNode.getChildAt(c);
                                System.out.println(pathName + ":" + (String)child.getUserObject());
                                if (!((String)child.getUserObject()).equals(pathName)) continue;
                                curNode = child;
                                if (!isLast) continue block1;
                                TreePath pathn = new TreePath(curNode.getPath());
                                FileNavigationPane.this.tree.setSelectionPath(pathn);
                                FileNavigationPane.this.tree.makeVisible(pathn);
                                FileNavigationPane.this.tree.scrollPathToVisible(pathn);
                                FileNavigationPane.this.openPath(pathn);
                                System.out.println("Found! " + curNode);
                                break block12;
                            }
                            System.out.println("Could not find " + pathName);
                            break;
                        }
                    } else {
                        Enumeration<TreeNode> enums = curNode.depthFirstEnumeration();
                        while (enums != null && enums.hasMoreElements()) {
                            MyTreeNode node = (MyTreeNode)enums.nextElement();
                            if (!node.isLeaf() || !((String)node.getUserObject()).contains(path[path.length - 1])) continue;
                            TreeNode[] pathArray = node.getPath();
                            int k = 0;
                            StringBuffer fullPath = new StringBuffer();
                            while (pathArray != null && k < pathArray.length) {
                                MyTreeNode n = (MyTreeNode)pathArray[k];
                                String s = (String)n.getUserObject();
                                fullPath.append(s);
                                if (k++ == pathArray.length - 1) continue;
                                fullPath.append(".");
                            }
                            String fullPathString = fullPath.toString();
                            if (fullPathString == null || !fullPathString.contains(qt)) continue;
                            System.out.println("Found! " + node);
                            TreePath pathn = new TreePath(node.getPath());
                            FileNavigationPane.this.tree.setSelectionPath(pathn.getParentPath());
                            FileNavigationPane.this.tree.setSelectionPath(pathn);
                            FileNavigationPane.this.tree.makeVisible(pathn);
                            FileNavigationPane.this.tree.scrollPathToVisible(pathn);
                        }
                    }
                } else if (ke.getKeyCode() == 27) {
                    FileNavigationPane.this.tree.grabFocus();
                }
            }
        }
    };

    public FileNavigationPane(FileChangeNotifier fcn) {
        super("ClassNavigation");
        this.fcn = fcn;
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.quickSearch.setForeground(Color.gray);
        this.setTitle("Files");
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode root = (TreeNode)FileNavigationPane.this.tree.getModel().getRoot();
                FileNavigationPane.this.expandAll(FileNavigationPane.this.tree, new TreePath(root), true);
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode root = (TreeNode)FileNavigationPane.this.tree.getModel().getRoot();
                FileNavigationPane.this.expandAll(FileNavigationPane.this.tree, new TreePath(root), false);
                FileNavigationPane.this.tree.expandPath(new TreePath(root));
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FileNavigationPane.this.openPath(FileNavigationPane.this.tree.getPathForLocation(e.getX(), e.getY()));
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    if (arg0.getSource() instanceof MyTree) {
                        MyTree tree = (MyTree)arg0.getSource();
                        FileNavigationPane.this.openPath(tree.getSelectionPath());
                    }
                } else if (arg0.getKeyCode() == 70 && arg0.isControlDown()) {
                    FileNavigationPane.this.quickSearch.grabFocus();
                }
            }
        });
        this.quickSearch.addKeyListener(this.search);
        this.quickSearch.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (FileNavigationPane.this.quickSearch.getText().equals(FileNavigationPane.quickSearchText)) {
                    FileNavigationPane.this.quickSearch.setText(null);
                    FileNavigationPane.this.quickSearch.setForeground(Color.black);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (FileNavigationPane.this.quickSearch.getText().isEmpty()) {
                    FileNavigationPane.this.quickSearch.setText(FileNavigationPane.quickSearchText);
                    FileNavigationPane.this.quickSearch.setForeground(Color.gray);
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.tree), "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)this.quickSearch, "North");
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)this.exact, "West");
        JPanel p4 = new JPanel(new BorderLayout());
        p4.add((Component)this.open, "East");
        p4.add((Component)this.close, "West");
        p3.add((Component)p4, "East");
        p2.add((Component)p3, "South");
        this.getContentPane().add((Component)p2, "South");
        this.setVisible(true);
        new FileDrop(this, this);
    }

    public void openClassFileToWorkSpace(String name, String container, ClassNode node) {
        this.fcn.openClassFile(name, container, node);
    }

    public void openFileToWorkSpace(String name, String container, byte[] contents) {
        this.fcn.openFile(name, container, contents);
    }

    @Override
    public void filesDropped(File[] files) {
        if (files.length < 1) {
            return;
        }
        BytecodeViewer.openFiles(files, true);
    }

    public void updateTree() {
        try {
            this.treeRoot.removeAllChildren();
            for (FileContainer container : BytecodeViewer.files) {
                MyTreeNode root = new MyTreeNode(container.name);
                this.treeRoot.add(root);
                ImageRenderer renderer = new ImageRenderer();
                this.tree.setCellRenderer(renderer);
                if (container.files.isEmpty()) continue;
                for (Map.Entry<String, byte[]> entry : container.files.entrySet()) {
                    String name = entry.getKey();
                    String[] spl = name.split("/");
                    if (spl.length < 2) {
                        root.add(new MyTreeNode(name));
                        continue;
                    }
                    MyTreeNode parent = root;
                    for (String s : spl) {
                        MyTreeNode child = null;
                        for (int i = 0; i < parent.getChildCount(); ++i) {
                            if (!((MyTreeNode)parent.getChildAt(i)).getUserObject().equals(s)) continue;
                            child = (MyTreeNode)parent.getChildAt(i);
                            break;
                        }
                        if (child == null) {
                            child = new MyTreeNode(s);
                            parent.add(child);
                        }
                        parent = child;
                    }
                }
            }
            this.treeRoot.sort();
            this.tree.expandPath(new TreePath(this.tree.getModel().getRoot()));
            this.tree.updateUI();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void resetWorkspace() {
        this.treeRoot.removeAllChildren();
        this.tree.repaint();
        this.tree.updateUI();
    }

    public void openPath(TreePath path) {
        if (path == null) {
            return;
        }
        StringBuffer nameBuffer = new StringBuffer();
        for (int i = 2; i < path.getPathCount(); ++i) {
            nameBuffer.append(path.getPathComponent(i));
            if (i >= path.getPathCount() - 1) continue;
            nameBuffer.append("/");
        }
        String name = nameBuffer.toString();
        String containerName = path.getPathComponent(1).toString();
        if (name.endsWith(".class")) {
            ClassNode cn = BytecodeViewer.getClassNode(containerName, name.substring(0, name.length() - ".class".length()));
            if (cn != null) {
                this.openClassFileToWorkSpace(nameBuffer.toString(), containerName, cn);
            }
        } else {
            this.openFileToWorkSpace(nameBuffer.toString(), containerName, BytecodeViewer.getFileContents(nameBuffer.toString()));
        }
    }

    public class ImageRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component ret = super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
            if (value != null && value instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)value;
                String name = node.toString();
                if (name.endsWith(".jar")) {
                    this.setIcon(Resources.jarIcon);
                } else if (name.endsWith(".zip")) {
                    this.setIcon(Resources.zipIcon);
                } else if (name.endsWith(".bat")) {
                    this.setIcon(Resources.batIcon);
                } else if (name.endsWith(".sh")) {
                    this.setIcon(Resources.shIcon);
                } else if (name.endsWith(".cs")) {
                    this.setIcon(Resources.csharpIcon);
                } else if (name.endsWith(".c") || name.endsWith(".cpp") || name.endsWith(".h")) {
                    this.setIcon(Resources.cplusplusIcon);
                } else if (name.endsWith(".apk") || name.endsWith(".dex")) {
                    this.setIcon(Resources.androidIcon);
                } else if (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".bmp") || name.endsWith(".gif")) {
                    this.setIcon(Resources.imageIcon);
                } else if (name.endsWith(".class")) {
                    this.setIcon(Resources.classIcon);
                } else if (name.endsWith(".java")) {
                    this.setIcon(Resources.javaIcon);
                } else if (name.endsWith(".txt") || name.endsWith(".md")) {
                    this.setIcon(Resources.textIcon);
                } else if (name.equals("decoded resources")) {
                    this.setIcon(Resources.decodedIcon);
                } else if (name.endsWith(".properties") || name.endsWith(".xml") || name.endsWith(".mf") || name.endsWith(".config") || name.endsWith(".cfg")) {
                    this.setIcon(Resources.configIcon);
                } else if (node.getChildCount() <= 0) {
                    this.setIcon(Resources.fileIcon);
                } else {
                    ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
                    ArrayList<TreeNode> totalNodes = new ArrayList<TreeNode>();
                    nodes.add(node);
                    totalNodes.add(node);
                    boolean isJava = false;
                    boolean finished = false;
                    while (!finished) {
                        if (nodes.isEmpty()) {
                            finished = true;
                            continue;
                        }
                        TreeNode treeNode = (TreeNode)nodes.get(0);
                        nodes.remove(treeNode);
                        int children = treeNode.getChildCount();
                        if (children >= 1) {
                            for (int i = 0; i < children; ++i) {
                                TreeNode child = treeNode.getChildAt(i);
                                if (!totalNodes.contains(child)) {
                                    nodes.add(child);
                                    totalNodes.add(child);
                                }
                                if (!child.toString().endsWith(".class")) continue;
                                isJava = true;
                            }
                        }
                        if (!isJava) continue;
                        nodes.clear();
                    }
                    if (isJava) {
                        this.setIcon(Resources.packagesIcon);
                    } else {
                        this.setIcon(Resources.folderIcon);
                    }
                }
            }
            return ret;
        }
    }

    class StringMetrics {
        Font font;
        FontRenderContext context;

        public StringMetrics(Graphics2D g2) {
            this.font = g2.getFont();
            this.context = g2.getFontRenderContext();
        }

        Rectangle2D getBounds(String message) {
            return this.font.getStringBounds(message, this.context);
        }

        double getWidth(String message) {
            Rectangle2D bounds = this.getBounds(message);
            return bounds.getWidth();
        }

        double getHeight(String message) {
            Rectangle2D bounds = this.getBounds(message);
            return bounds.getHeight();
        }
    }

    public class MyTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -8817777566176729571L;
        protected Comparator<MyTreeNode> nodeComparator;

        public MyTreeNode(Object o) {
            super(o);
            this.nodeComparator = new Comparator<MyTreeNode>(){

                @Override
                public int compare(MyTreeNode o1, MyTreeNode o2) {
                    int firstOffset = o1.getChildCount() > 0 ? -1000 : 0;
                    int secondOffset = o2.getChildCount() > 0 ? 1000 : 0;
                    return o1.toString().compareToIgnoreCase(o2.toString()) + firstOffset + secondOffset;
                }

                @Override
                public boolean equals(Object obj) {
                    return false;
                }

                public int hashCode() {
                    int hash = 7;
                    return 7;
                }
            };
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
        }

        public void sort() {
            this.recursiveSort(this);
        }

        private void recursiveSort(MyTreeNode node) {
            Collections.sort(node.children, this.nodeComparator);
            for (MyTreeNode nextNode : node.children) {
                if (nextNode.getChildCount() <= 0) continue;
                this.recursiveSort(nextNode);
            }
        }
    }

    public class MyTree
    extends JTree {
        private static final long serialVersionUID = -2355167326094772096L;
        DefaultMutableTreeNode treeRoot;
        StringMetrics m;

        public MyTree(DefaultMutableTreeNode treeRoot) {
            super(treeRoot);
            this.m = null;
            this.treeRoot = treeRoot;
        }

        @Override
        public void paint(Graphics g) {
            try {
                super.paint(g);
                if (this.m == null) {
                    this.m = new StringMetrics((Graphics2D)g);
                }
                if (this.treeRoot.getChildCount() < 1) {
                    g.setColor(new Color(0, 0, 0, 100));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.white);
                    String s = "Drag class/jar/zip/APK/DEX here";
                    g.drawString(s, (int)((double)(this.getWidth() / 2) - this.m.getWidth(s) / 2.0), this.getHeight() / 2);
                }
            }
            catch (InternalError | NullPointerException throwable) {
                // empty catch block
            }
        }
    }
}

