/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.DecompilerSettings;
import the.bytecode.club.bytecodeviewer.Dex2Jar;
import the.bytecode.club.bytecodeviewer.FileChangeNotifier;
import the.bytecode.club.bytecodeviewer.FileContainer;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.Resources;
import the.bytecode.club.bytecodeviewer.Settings;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.CFRDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.decompilers.FernFlowerDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.ProcyonDecompiler;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.ClassNodeDecompiler;
import the.bytecode.club.bytecodeviewer.gui.AboutWindow;
import the.bytecode.club.bytecodeviewer.gui.AllatoriStringDecrypterOptions;
import the.bytecode.club.bytecodeviewer.gui.ExportJar;
import the.bytecode.club.bytecodeviewer.gui.FileChooser;
import the.bytecode.club.bytecodeviewer.gui.FileNavigationPane;
import the.bytecode.club.bytecodeviewer.gui.MaliciousCodeScannerOptions;
import the.bytecode.club.bytecodeviewer.gui.ReplaceStringsOptions;
import the.bytecode.club.bytecodeviewer.gui.RunOptions;
import the.bytecode.club.bytecodeviewer.gui.SearchingPane;
import the.bytecode.club.bytecodeviewer.gui.TabbedPane;
import the.bytecode.club.bytecodeviewer.gui.Viewer;
import the.bytecode.club.bytecodeviewer.gui.VisibleComponent;
import the.bytecode.club.bytecodeviewer.gui.WorkPane;
import the.bytecode.club.bytecodeviewer.obfuscators.rename.RenameClasses;
import the.bytecode.club.bytecodeviewer.obfuscators.rename.RenameFields;
import the.bytecode.club.bytecodeviewer.obfuscators.rename.RenameMethods;
import the.bytecode.club.bytecodeviewer.plugin.PluginManager;
import the.bytecode.club.bytecodeviewer.plugin.preinstalled.CodeSequenceDiagram;
import the.bytecode.club.bytecodeviewer.plugin.preinstalled.ShowAllStrings;
import the.bytecode.club.bytecodeviewer.plugin.preinstalled.ShowMainMethods;
import the.bytecode.club.bytecodeviewer.plugin.preinstalled.ZKMStringDecrypter;
import the.bytecode.club.bytecodeviewer.plugin.preinstalled.ZStringArrayDecrypter;

public class MainViewerGUI
extends JFrame
implements FileChangeNotifier {
    public static final long serialVersionUID = 1851409230530948543L;
    private final ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MainViewerGUI.this.refreshOnChange.isSelected()) {
                if (MainViewerGUI.this.workPane.getCurrentViewer() == null) {
                    return;
                }
                MainViewerGUI.this.workPane.refreshClass.doClick();
            }
        }
    };
    public FileNavigationPane fileNavigationPane = new FileNavigationPane(this);
    public SearchingPane searchingPane = new SearchingPane(this);
    public boolean isMaximized = false;
    public JSplitPane sp1;
    public JSplitPane sp2;
    static ArrayList<VisibleComponent> rfComps = new ArrayList();
    public final JMenuItem mntmNewWorkspace = new JMenuItem("New Workspace");
    public JMenu mnRecentFiles = new JMenu("Recent Files");
    public final JMenuItem mntmNewMenuItem = new JMenuItem("Decompile & Save All Classes..");
    public final JMenuItem mntmAbout = new JMenuItem("About");
    public final JMenuItem mntmStartExternalPlugin = new JMenuItem("Open Plugin..");
    public JMenu mnRecentPlugins = new JMenu("Recent Plugins");
    public final JMenuItem mntmStartZkmString = new JMenuItem("ZKM String Decrypter");
    public final JMenuItem mntmNewMenuItem_1 = new JMenuItem("Malicious Code Scanner");
    public final JMenuItem mntmNewMenuItem_2 = new JMenuItem("Allatori String Decrypter");
    public final JMenuItem mntmShowAllStrings = new JMenuItem("Show All Strings");
    public final JMenuItem mntmShowMainMethods = new JMenuItem("Show Main Methods");
    public final JMenuItem mntmNewMenuItem_3 = new JMenuItem("Save As Runnable Jar..");
    public final JMenuItem mntmReplaceStrings = new JMenuItem("Replace Strings");
    public final JCheckBoxMenuItem updateCheck = new JCheckBoxMenuItem("Update Check");
    public final JMenuItem mntmNewMenuItem_6 = new JMenuItem("Rename Fields");
    public final JMenuItem mntmNewMenuItem_7 = new JMenuItem("Rename Methods");
    public final JMenuItem mntmNewMenuItem_8 = new JMenuItem("Move All Classes Into Root Package");
    public final JMenuItem mntmNewMenuItem_9 = new JMenuItem("Control Flow");
    public final JMenuItem mntmNewMenuItem_10 = new JMenuItem("Junk Code");
    public final ButtonGroup obfuscatorGroup = new ButtonGroup();
    public final JRadioButtonMenuItem strongObf = new JRadioButtonMenuItem("Strong Obfuscation");
    public final JRadioButtonMenuItem lightObf = new JRadioButtonMenuItem("Light Obfuscation");
    public final JMenuItem mntmNewMenuItem_11 = new JMenuItem("Rename Classes");
    public final JMenuItem mntmNewMenuItem_12 = new JMenuItem("Decompile & Save Opened Class..");
    public WorkPane workPane = new WorkPane(this);
    public final JCheckBoxMenuItem refreshOnChange = new JCheckBoxMenuItem("Refresh On View Change");
    public final JCheckBoxMenuItem synchronizeViewing = new JCheckBoxMenuItem("Synchronize Viewing");
    public final JCheckBoxMenuItem showMethodsList = new JCheckBoxMenuItem("Show Methods List");
    public AboutWindow aboutWindow = new AboutWindow();
    public final JMenuItem mntmSaveAsApk = new JMenuItem("Save As DEX..");
    public final JMenuItem mntmCodeSequenceDiagram = new JMenuItem("Code Sequence Diagram");
    public final JCheckBoxMenuItem compileOnSave = new JCheckBoxMenuItem("Compile On Save");
    public final JMenuItem mntmNewMenuItem_13 = new JMenuItem("Compile");
    public final JCheckBoxMenuItem compileOnRefresh = new JCheckBoxMenuItem("Compile On Refresh");
    public final JMenuItem mntmSetPythonDirectory = new JMenuItem("Set Python 2.7 Executable");
    public final JMenuItem mntmSetJreRt = new JMenuItem("Set JRE RT Library");
    public final JMenuItem mntmZstringarrayDecrypter = new JMenuItem("ZStringArray Decrypter");
    public final JMenuItem mntmRun = new JMenuItem("Run");
    public final JCheckBoxMenuItem decodeAPKResources = new JCheckBoxMenuItem("Decode APK Resources");
    public final ButtonGroup panelGroup1 = new ButtonGroup();
    public final ButtonGroup panelGroup2 = new ButtonGroup();
    public final ButtonGroup panelGroup3 = new ButtonGroup();
    public final JCheckBox mnShowContainer = new JCheckBox("Show Containing File's Name");
    private final JMenuItem mntmSetOpitonalLibrary = new JMenuItem("Set Optional Library Folder");
    private final JMenuItem mntmPingback = new JMenuItem("Pingback");
    private final JMenu mnFontSize = new JMenu("Font Size");
    private final JCheckBoxMenuItem deleteOutdatedLibs = new JCheckBoxMenuItem("Delete Foreign/Outdated Libs");
    private final JMenu mnApkConversion = new JMenu("APK Conversion");
    public final ButtonGroup apkConversionGroup = new ButtonGroup();
    public final JRadioButtonMenuItem apkConversionDex = new JRadioButtonMenuItem("Dex2Jar");
    public final JRadioButtonMenuItem apkConversionEnjarify = new JRadioButtonMenuItem("Enjarify");
    private final JMenuItem mntmSetPythonx = new JMenuItem("Set Python 3.X Executable");
    private final JMenuItem mntmReloadResources = new JMenuItem("Reload Resources");
    private final JMenuItem mntmSetJavacExecutable = new JMenuItem("Set Javac Executable");
    public List<ButtonGroup> allPanes = Collections.unmodifiableList(Arrays.asList(this.panelGroup1, this.panelGroup2, this.panelGroup3));
    public Map<ButtonGroup, Map<JRadioButtonMenuItem, Decompiler>> allDecompilers = new HashMap<ButtonGroup, Map<JRadioButtonMenuItem, Decompiler>>();
    public Map<ButtonGroup, Map<Decompiler, JRadioButtonMenuItem>> allDecompilersRev = new HashMap<ButtonGroup, Map<Decompiler, JRadioButtonMenuItem>>();
    public Map<ButtonGroup, Map<Decompiler, JCheckBoxMenuItem>> editButtons = new HashMap<ButtonGroup, Map<Decompiler, JCheckBoxMenuItem>>();
    public JSpinner fontSpinner = new JSpinner();
    private JMenuItem spinnerMenu = new JMenuItem("");

    public void pythonC() {
        new FileChooser(Settings.PYTHON2_LOCATION, "Python (Or PyPy for speed) 2.7 Executable").run();
    }

    public void javac() {
        new FileChooser(Settings.JAVAC_LOCATION, "javac executable (Requires JDK 'C:/Program Files/Java/jdk_xx/bin/javac.exe')").run();
    }

    public void java() {
        new FileChooser(Settings.JAVA_LOCATION, "Java Executable (Requires JRE/JDK 'C:/Program Files/Java/jre_xx/bin/java.exe')").run();
    }

    public void pythonC3() {
        new FileChooser(Settings.PYTHON3_LOCATION, "Python (Or PyPy for speed) 3.x Executable").run();
    }

    public void rtC() {
        new FileChooser(Settings.RT_LOCATION, "Java rt.jar").run();
    }

    public void library() {
        final JTextField text = new JTextField();
        text.setText(Settings.PATH.get());
        JDialog dialog = new JDialog();
        dialog.setModal(true);
        dialog.add(text);
        dialog.setSize(500, 100);
        dialog.setLocationRelativeTo(BytecodeViewer.viewer);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.PATH.set(text.getText());
            }
        });
        dialog.setVisible(true);
    }

    private JMenu generateDecompilerMenu(Decompiler decompiler, int panelId) {
        ButtonGroup group = this.allPanes.get(panelId);
        JMenu menu = new JMenu(decompiler.getName());
        JRadioButtonMenuItem java = new JRadioButtonMenuItem(decompiler == Decompiler.SMALI ? "Smali" : "Java");
        java.addActionListener(this.listener);
        JRadioButtonMenuItem bytecode = new JRadioButtonMenuItem("Bytecode");
        JCheckBoxMenuItem editable = new JCheckBoxMenuItem("Editable");
        JSeparator separator = new JSeparator();
        menu.add(java);
        group.add(java);
        this.allDecompilers.get(group).put(java, decompiler);
        this.allDecompilersRev.get(group).put(decompiler, java);
        if (decompiler == Decompiler.KRAKATAU) {
            menu.add(bytecode);
            group.add(bytecode);
            bytecode.addActionListener(this.listener);
            this.allDecompilers.get(group).put(bytecode, Decompiler.KRAKATAU_DA);
        }
        menu.add(separator);
        menu.add(editable);
        this.editButtons.get(group).put(decompiler, editable);
        return menu;
    }

    private JMenu generatePane(int id) {
        JMenu menu = new JMenu("Pane " + (id + 1));
        JRadioButtonMenuItem none = new JRadioButtonMenuItem("None");
        JRadioButtonMenuItem bytecode = new JRadioButtonMenuItem("Bytecode");
        JRadioButtonMenuItem hexcode = new JRadioButtonMenuItem("Hexcode");
        ButtonGroup group = this.allPanes.get(id);
        group.add(none);
        group.add(bytecode);
        group.add(hexcode);
        this.allDecompilers.get(group).put(none, null);
        this.allDecompilersRev.get(group).put(null, none);
        this.allDecompilers.get(group).put(bytecode, Decompiler.BYTECODE);
        this.allDecompilersRev.get(group).put(Decompiler.BYTECODE, bytecode);
        this.allDecompilers.get(group).put(hexcode, Decompiler.HEXCODE);
        this.allDecompilersRev.get(group).put(Decompiler.HEXCODE, hexcode);
        menu.add(none);
        menu.add(new JSeparator());
        menu.add(this.generateDecompilerMenu(Decompiler.PROCYON, id));
        menu.add(this.generateDecompilerMenu(Decompiler.CFR, id));
        menu.add(this.generateDecompilerMenu(Decompiler.JDGUI, id));
        menu.add(this.generateDecompilerMenu(Decompiler.FERNFLOWER, id));
        menu.add(this.generateDecompilerMenu(Decompiler.KRAKATAU, id));
        menu.add(new JSeparator());
        menu.add(this.generateDecompilerMenu(Decompiler.SMALI, id));
        menu.add(new JSeparator());
        menu.add(bytecode);
        menu.add(hexcode);
        return menu;
    }

    private static void addSettingsMenuItem(JMenu menu, final JCheckBoxMenuItem menuItem, final Settings<Boolean> settings) {
        menuItem.setSelected(settings.get());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                settings.set(menuItem.isSelected());
            }
        });
        menu.add(menuItem);
    }

    private static void setUISize(Component component, final Settings<Integer> width, final Settings<Integer> height) {
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component component = (Component)e.getSource();
                width.set(component.getWidth());
                height.set(component.getHeight());
            }
        });
        if (width.get() != null && height.get() != null) {
            Dimension dimension = new Dimension(width.get(), height.get());
            if (component.getParent() == null) {
                component.setSize(dimension);
            } else {
                component.setPreferredSize(dimension);
            }
        }
    }

    public MainViewerGUI() {
        Decompiler.ensureInitted();
        this.allDecompilers.put(this.panelGroup1, new HashMap());
        this.allDecompilers.put(this.panelGroup2, new HashMap());
        this.allDecompilers.put(this.panelGroup3, new HashMap());
        this.allDecompilersRev.put(this.panelGroup1, new HashMap());
        this.allDecompilersRev.put(this.panelGroup2, new HashMap());
        this.allDecompilersRev.put(this.panelGroup3, new HashMap());
        this.editButtons.put(this.panelGroup1, new HashMap());
        this.editButtons.put(this.panelGroup2, new HashMap());
        this.editButtons.put(this.panelGroup3, new HashMap());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new Test());
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent evt) {
                int oldState = evt.getOldState();
                int newState = evt.getNewState();
                if ((oldState & 1) == 0 && (newState & 1) != 0 || (oldState & 1) == 0 || (newState & 1) == 0) {
                    // empty if block
                }
                if ((oldState & 6) == 0 && (newState & 6) != 0) {
                    MainViewerGUI.this.isMaximized = true;
                } else if ((oldState & 6) != 0 && (newState & 6) == 0) {
                    MainViewerGUI.this.isMaximized = false;
                }
            }
        });
        this.setIconImages(Resources.iconList);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenu viewMenu = new JMenu("View");
        JMenu settingsMenu = new JMenu("Settings");
        JMenu obfuscateMenu = new JMenu("Obfuscate");
        JMenu pluginsMenu = new JMenu("Plugins");
        obfuscateMenu.setVisible(false);
        this.setJMenuBar(menuBar);
        this.obfuscatorGroup.add(this.strongObf);
        this.obfuscatorGroup.add(this.lightObf);
        this.obfuscatorGroup.setSelected(this.strongObf.getModel(), true);
        this.setDefaultCloseOperation(3);
        menuBar.add(fileMenu);
        this.mntmNewWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BytecodeViewer.resetWorkSpace(true);
            }
        });
        JMenuItem mntmLoadJar = new JMenuItem("Add..");
        mntmLoadJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                try {
                    File f = new File(BytecodeViewer.lastDirectory);
                    if (f.exists()) {
                        fc.setSelectedFile(f);
                    }
                }
                catch (Exception f) {
                    // empty catch block
                }
                fc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String extension = MiscUtils.extension(f.getAbsolutePath());
                        return extension != null && (extension.equals("jar") || extension.equals("zip") || extension.equals("class") || extension.equals("apk") || extension.equals("dex"));
                    }

                    @Override
                    public String getDescription() {
                        return "APKs, DEX, Class Files or Zip/Jar Archives";
                    }
                });
                fc.setFileHidingEnabled(false);
                fc.setAcceptAllFileFilterUsed(false);
                int returnVal = fc.showOpenDialog(BytecodeViewer.viewer);
                if (returnVal == 0) {
                    BytecodeViewer.lastDirectory = fc.getSelectedFile().getAbsolutePath();
                    try {
                        BytecodeViewer.viewer.setIcon(true);
                        BytecodeViewer.openFiles(new File[]{fc.getSelectedFile()}, true);
                        BytecodeViewer.viewer.setIcon(false);
                    }
                    catch (Exception e1) {
                        new ExceptionUI(e1);
                    }
                }
            }
        });
        fileMenu.add(mntmLoadJar);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.mntmNewWorkspace);
        JMenuItem mntmSave = new JMenuItem("Save As Zip..");
        mntmSave.setActionCommand("");
        mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.getLoadedBytes().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (MainViewerGUI.this.compileOnSave.isSelected() && !BytecodeViewer.compile(false)) {
                            return;
                        }
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("zip");
                            }

                            @Override
                            public String getDescription() {
                                return "Zip Archives";
                            }
                        });
                        fc.setFileHidingEnabled(false);
                        fc.setAcceptAllFileFilterUsed(false);
                        int returnVal = fc.showSaveDialog(MainViewerGUI.this);
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            if (!file.getAbsolutePath().endsWith(".zip")) {
                                file = new File(file.getAbsolutePath() + ".zip");
                            }
                            if (file.exists()) {
                                JOptionPane pane = new JOptionPane("Are you sure you wish to overwrite this existing file?");
                                Object[] options = new String[]{"Yes", "No"};
                                pane.setOptions(options);
                                JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Overwrite File");
                                dialog.setVisible(true);
                                Object obj = pane.getValue();
                                int result = -1;
                                for (int k = 0; k < options.length; ++k) {
                                    if (!options[k].equals(obj)) continue;
                                    result = k;
                                }
                                if (result == 0) {
                                    file.delete();
                                } else {
                                    return;
                                }
                            }
                            final File file2 = file;
                            BytecodeViewer.viewer.setIcon(true);
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), file2.getAbsolutePath());
                                    BytecodeViewer.viewer.setIcon(false);
                                }
                            };
                            t.start();
                        }
                    }
                };
                t.start();
            }
        });
        fileMenu.add(new JSeparator());
        this.mntmReloadResources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane pane = new JOptionPane("Are you sure you wish to reload the resources?");
                Object[] options = new String[]{"Yes", "No"};
                pane.setOptions(options);
                JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Reload Resources");
                dialog.setVisible(true);
                Object obj = pane.getValue();
                int result = -1;
                for (int k = 0; k < options.length; ++k) {
                    if (!options[k].equals(obj)) continue;
                    result = k;
                }
                if (result == 0) {
                    ArrayList<File> reopen = new ArrayList<File>();
                    for (FileContainer container : BytecodeViewer.files) {
                        reopen.add(container.file);
                    }
                    BytecodeViewer.files.clear();
                    BytecodeViewer.openFiles(reopen.toArray(new File[reopen.size()]), false);
                }
            }
        });
        fileMenu.add(this.mntmReloadResources);
        fileMenu.add(new JSeparator());
        this.mntmNewMenuItem_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BytecodeViewer.getLoadedBytes().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (MainViewerGUI.this.compileOnSave.isSelected() && !BytecodeViewer.compile(false)) {
                            return;
                        }
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("zip");
                            }

                            @Override
                            public String getDescription() {
                                return "Zip Archives";
                            }
                        });
                        fc.setFileHidingEnabled(false);
                        fc.setAcceptAllFileFilterUsed(false);
                        int returnVal = fc.showSaveDialog(MainViewerGUI.this);
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            String path = file.getAbsolutePath();
                            if (!path.endsWith(".jar")) {
                                path = path + ".jar";
                            }
                            if (new File(path).exists()) {
                                JOptionPane pane = new JOptionPane("Are you sure you wish to overwrite this existing file?");
                                Object[] options = new String[]{"Yes", "No"};
                                pane.setOptions(options);
                                JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Overwrite File");
                                dialog.setVisible(true);
                                Object obj = pane.getValue();
                                int result = -1;
                                for (int k = 0; k < options.length; ++k) {
                                    if (!options[k].equals(obj)) continue;
                                    result = k;
                                }
                                if (result == 0) {
                                    file.delete();
                                } else {
                                    return;
                                }
                            }
                            new ExportJar(path).setVisible(true);
                        }
                    }
                };
                t.start();
            }
        });
        this.mntmNewMenuItem_13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        BytecodeViewer.compile(true);
                    }
                };
                t.start();
            }
        });
        this.mntmRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BytecodeViewer.getLoadedBytes().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                new RunOptions().setVisible(true);
            }
        });
        fileMenu.add(this.mntmRun);
        fileMenu.add(this.mntmNewMenuItem_13);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.mntmNewMenuItem_3);
        this.mntmSaveAsApk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.getLoadedBytes().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (MainViewerGUI.this.compileOnSave.isSelected() && !BytecodeViewer.compile(false)) {
                            return;
                        }
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("dex");
                            }

                            @Override
                            public String getDescription() {
                                return "Android DEX Files";
                            }
                        });
                        fc.setFileHidingEnabled(false);
                        fc.setAcceptAllFileFilterUsed(false);
                        int returnVal = fc.showSaveDialog(MainViewerGUI.this);
                        if (returnVal == 0) {
                            File file2;
                            File file = fc.getSelectedFile();
                            String output = file.getAbsolutePath();
                            if (!output.endsWith(".dex")) {
                                output = output + ".dex";
                            }
                            if ((file2 = new File(output)).exists()) {
                                JOptionPane pane = new JOptionPane("Are you sure you wish to overwrite this existing file?");
                                Object[] options = new String[]{"Yes", "No"};
                                pane.setOptions(options);
                                JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Overwrite File");
                                dialog.setVisible(true);
                                Object obj = pane.getValue();
                                int result = -1;
                                for (int k = 0; k < options.length; ++k) {
                                    if (!options[k].equals(obj)) continue;
                                    result = k;
                                }
                                if (result == 0) {
                                    file.delete();
                                } else {
                                    return;
                                }
                            }
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    BytecodeViewer.viewer.setIcon(true);
                                    final String input = BytecodeViewer.tempDir.getAbsolutePath() + BytecodeViewer.fs + BytecodeViewer.getRandomizedName() + ".jar";
                                    JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), input);
                                    Thread t = new Thread(){

                                        @Override
                                        public void run() {
                                            Dex2Jar.saveAsDex(new File(input), file2);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                    };
                                    t.start();
                                }
                            };
                            t.start();
                        }
                    }
                };
                t.start();
            }
        });
        fileMenu.add(this.mntmSaveAsApk);
        fileMenu.add(mntmSave);
        this.mntmNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.files.isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (MainViewerGUI.this.compileOnSave.isSelected() && !BytecodeViewer.compile(false)) {
                            return;
                        }
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("zip");
                            }

                            @Override
                            public String getDescription() {
                                return "Zip Archives";
                            }
                        });
                        fc.setFileHidingEnabled(false);
                        fc.setAcceptAllFileFilterUsed(false);
                        int returnVal = fc.showSaveDialog(MainViewerGUI.this);
                        if (returnVal == 0) {
                            File file = fc.getSelectedFile();
                            if (!file.getAbsolutePath().endsWith(".zip")) {
                                file = new File(file.getAbsolutePath() + ".zip");
                            }
                            if (file.exists()) {
                                JOptionPane pane = new JOptionPane("Are you sure you wish to overwrite this existing file?");
                                Object[] options = new String[]{"Yes", "No"};
                                pane.setOptions(options);
                                JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Overwrite File");
                                dialog.setVisible(true);
                                Object obj = pane.getValue();
                                int result = -1;
                                for (int k = 0; k < options.length; ++k) {
                                    if (!options[k].equals(obj)) continue;
                                    result = k;
                                }
                                if (result == 0) {
                                    file.delete();
                                } else {
                                    return;
                                }
                            }
                            BytecodeViewer.viewer.setIcon(true);
                            final String path = MiscUtils.append(file, ".zip");
                            JOptionPane pane = new JOptionPane("What decompiler will you use?");
                            Object[] options = new String[]{"Procyon", "CFR", "Fernflower", "Krakatau", "JD-GUI", "Cancel"};
                            pane.setOptions(options);
                            JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Select Decompiler");
                            dialog.setVisible(true);
                            Object obj = pane.getValue();
                            int result = -1;
                            for (int k = 0; k < options.length; ++k) {
                                if (!options[k].equals(obj)) continue;
                                result = k;
                            }
                            if (result == 0) {
                                Thread t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Decompiler.PROCYON.decompileToZip(path);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 1) {
                                Thread t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Decompiler.CFR.decompileToZip(path);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 2) {
                                Thread t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Decompiler.FERNFLOWER.decompileToZip(path);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 3) {
                                Thread t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Decompiler.KRAKATAU.decompileToZip(path);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            } else if (result == 4) {
                                new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Decompiler.JDGUI.decompileToZip(path);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                }.start();
                            } else {
                                BytecodeViewer.viewer.setIcon(false);
                            }
                        }
                    }
                };
                t.start();
            }
        });
        this.mntmNewMenuItem_12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainViewerGUI.this.workPane.getCurrentViewer() == null) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (MainViewerGUI.this.compileOnSave.isSelected() && !BytecodeViewer.compile(false)) {
                            return;
                        }
                        final String s = MainViewerGUI.this.workPane.getCurrentViewer().name;
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("java");
                            }

                            @Override
                            public String getDescription() {
                                return "Java Source Files";
                            }
                        });
                        fc.setFileHidingEnabled(false);
                        fc.setAcceptAllFileFilterUsed(false);
                        int returnVal = fc.showSaveDialog(MainViewerGUI.this);
                        if (returnVal == 0) {
                            Thread t;
                            int k;
                            int result;
                            Object obj;
                            JDialog dialog;
                            Object[] options;
                            JOptionPane pane;
                            File file = fc.getSelectedFile();
                            BytecodeViewer.viewer.setIcon(true);
                            final String path = MiscUtils.append(file, ".java");
                            if (new File(path).exists()) {
                                pane = new JOptionPane("Are you sure you wish to overwrite this existing file?");
                                options = new String[]{"Yes", "No"};
                                pane.setOptions(options);
                                dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Overwrite File");
                                dialog.setVisible(true);
                                obj = pane.getValue();
                                result = -1;
                                for (k = 0; k < options.length; ++k) {
                                    if (!options[k].equals(obj)) continue;
                                    result = k;
                                }
                                if (result == 0) {
                                    file.delete();
                                } else {
                                    return;
                                }
                            }
                            pane = new JOptionPane("What decompiler will you use?");
                            options = new String[]{"Procyon", "CFR", "Fernflower", "Krakatau", "Cancel"};
                            pane.setOptions(options);
                            dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Select Decompiler");
                            dialog.setVisible(true);
                            obj = pane.getValue();
                            result = -1;
                            for (k = 0; k < options.length; ++k) {
                                if (!options[k].equals(obj)) continue;
                                result = k;
                            }
                            final String containerName = BytecodeViewer.files.get((int)0).name;
                            if (result == 0) {
                                t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            ClassNode cn = BytecodeViewer.getClassNode(containerName, s);
                                            byte[] bytes = BytecodeViewer.getClassBytes(containerName, s);
                                            String contents = Decompiler.PROCYON.decompileClassNode(cn, bytes);
                                            FileUtils.write((File)new File(path), (CharSequence)contents, (String)"UTF-8", (boolean)false);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 1) {
                                t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            ClassNode cn = BytecodeViewer.getClassNode(containerName, s);
                                            byte[] bytes = BytecodeViewer.getClassBytes(containerName, s);
                                            String contents = Decompiler.CFR.decompileClassNode(cn, bytes);
                                            FileUtils.write((File)new File(path), (CharSequence)contents, (String)"UTF-8", (boolean)false);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 2) {
                                t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            ClassNode cn = BytecodeViewer.getClassNode(containerName, s);
                                            byte[] bytes = BytecodeViewer.getClassBytes(containerName, s);
                                            String contents = Decompiler.FERNFLOWER.decompileClassNode(cn, bytes);
                                            FileUtils.write((File)new File(path), (CharSequence)contents, (String)"UTF-8", (boolean)false);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 3) {
                                t = new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            ClassNode cn = BytecodeViewer.getClassNode(containerName, s);
                                            byte[] bytes = BytecodeViewer.getClassBytes(containerName, s);
                                            String contents = Decompiler.KRAKATAU.decompileClassNode(cn, bytes);
                                            FileUtils.write((File)new File(path), (CharSequence)contents, (String)"UTF-8", (boolean)false);
                                            BytecodeViewer.viewer.setIcon(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                        }
                                    }
                                };
                                t.start();
                            }
                            if (result == 4) {
                                BytecodeViewer.viewer.setIcon(false);
                            }
                        }
                    }
                };
                t.start();
            }
        });
        fileMenu.add(this.mntmNewMenuItem_12);
        fileMenu.add(this.mntmNewMenuItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.mnRecentFiles);
        fileMenu.add(new JSeparator());
        this.mntmAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainViewerGUI.this.aboutWindow.setVisible(true);
            }
        });
        fileMenu.add(this.mntmAbout);
        JMenuItem mntmExit = new JMenuItem("Exit");
        mntmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane pane = new JOptionPane("Are you sure you want to exit?");
                Object[] options = new String[]{"Yes", "No"};
                pane.setOptions(options);
                JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - Exit");
                dialog.setVisible(true);
                Object obj = pane.getValue();
                int result = -1;
                for (int k = 0; k < options.length; ++k) {
                    if (!options[k].equals(obj)) continue;
                    result = k;
                }
                if (result == 0) {
                    System.exit(0);
                }
            }
        });
        this.mntmPingback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BytecodeViewer.pingback();
            }
        });
        fileMenu.add(this.mntmPingback);
        fileMenu.add(mntmExit);
        menuBar.add(viewMenu);
        viewMenu.add(this.generatePane(0));
        viewMenu.add(this.generatePane(1));
        viewMenu.add(this.generatePane(2));
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.compileOnSave, Settings.COMPILE_ON_SAVE);
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.compileOnRefresh, Settings.COMPILE_ON_REFRESH);
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.refreshOnChange, Settings.REFRESH_ON_CHANGE);
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.synchronizeViewing, Settings.SYNCHRONIZE_VIEWING);
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.showMethodsList, Settings.SHOW_METHODS_LIST);
        settingsMenu.add(new JSeparator());
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.decodeAPKResources, Settings.DECODE_APK_RESOURCES);
        settingsMenu.add(this.mnApkConversion);
        this.mnApkConversion.add(this.apkConversionDex);
        this.mnApkConversion.add(this.apkConversionEnjarify);
        settingsMenu.add(new JSeparator());
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.updateCheck, Settings.UPDATE_CHECK);
        MainViewerGUI.addSettingsMenuItem(settingsMenu, this.deleteOutdatedLibs, Settings.DELETE_OUTDATED_LIBS);
        this.deleteOutdatedLibs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!MainViewerGUI.this.deleteOutdatedLibs.isSelected()) {
                    BytecodeViewer.showMessage("WARNING: With this being toggled off outdated libraries will NOT be removed. It's also a security issue. ONLY TURN IT OFF IF YOU KNOW WHAT YOU'RE DOING.");
                }
            }
        });
        settingsMenu.add(new JSeparator());
        this.mntmSetPythonDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainViewerGUI.this.pythonC();
            }
        });
        settingsMenu.add(this.mntmSetPythonDirectory);
        this.mntmSetJreRt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainViewerGUI.this.rtC();
            }
        });
        this.mntmSetPythonx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainViewerGUI.this.pythonC3();
            }
        });
        settingsMenu.add(this.mntmSetPythonx);
        settingsMenu.add(this.mntmSetJreRt);
        this.mntmSetOpitonalLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainViewerGUI.this.library();
            }
        });
        settingsMenu.add(this.mntmSetOpitonalLibrary);
        this.mntmSetJavacExecutable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainViewerGUI.this.javac();
            }
        });
        settingsMenu.add(this.mntmSetJavacExecutable);
        settingsMenu.add(new JSeparator());
        JMenu cfrSettingsMenu = new JMenu("CFR");
        DecompilerSettings cfrSettings = Decompiler.CFR.getSettings();
        for (CFRDecompiler.Settings setting : CFRDecompiler.Settings.values()) {
            cfrSettingsMenu.add(cfrSettings.getMenuItem(setting));
        }
        settingsMenu.add(cfrSettingsMenu);
        JMenu fernflowerSettingMenu = new JMenu("FernFlower");
        DecompilerSettings fernflowerSettings = Decompiler.FERNFLOWER.getSettings();
        for (FernFlowerDecompiler.Settings setting : FernFlowerDecompiler.Settings.values()) {
            fernflowerSettingMenu.add(fernflowerSettings.getMenuItem(setting));
        }
        settingsMenu.add(fernflowerSettingMenu);
        JMenu procyonSettingsMenu = new JMenu("Procyon");
        DecompilerSettings procyonSettings = Decompiler.PROCYON.getSettings();
        for (ProcyonDecompiler.Settings setting : ProcyonDecompiler.Settings.values()) {
            procyonSettingsMenu.add(procyonSettings.getMenuItem(setting));
        }
        settingsMenu.add(procyonSettingsMenu);
        JMenu bytecodeSettingsMenu = new JMenu("Bytecode Decompiler");
        DecompilerSettings bytecodeSettings = Decompiler.BYTECODE.getSettings();
        for (ClassNodeDecompiler.Settings setting : ClassNodeDecompiler.Settings.values()) {
            bytecodeSettingsMenu.add(bytecodeSettings.getMenuItem(setting));
        }
        settingsMenu.add(bytecodeSettingsMenu);
        menuBar.add(settingsMenu);
        menuBar.add(obfuscateMenu);
        this.mntmNewMenuItem_6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.runningObfuscation) {
                    BytecodeViewer.showMessage("You're currently running an obfuscation task, wait for this to finish.");
                    return;
                }
                new RenameFields().start();
                MainViewerGUI.this.workPane.refreshClass.doClick();
                MainViewerGUI.this.fileNavigationPane.tree.updateUI();
            }
        });
        obfuscateMenu.add(this.strongObf);
        obfuscateMenu.add(this.lightObf);
        obfuscateMenu.add(new JSeparator());
        this.mntmNewMenuItem_8.setEnabled(false);
        obfuscateMenu.add(this.mntmNewMenuItem_8);
        obfuscateMenu.add(this.mntmNewMenuItem_6);
        this.mntmNewMenuItem_7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.runningObfuscation) {
                    BytecodeViewer.showMessage("You're currently running an obfuscation task, wait for this to finish.");
                    return;
                }
                new RenameMethods().start();
                MainViewerGUI.this.workPane.refreshClass.doClick();
                MainViewerGUI.this.fileNavigationPane.tree.updateUI();
            }
        });
        obfuscateMenu.add(this.mntmNewMenuItem_7);
        this.mntmNewMenuItem_11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.runningObfuscation) {
                    BytecodeViewer.showMessage("You're currently running an obfuscation task, wait for this to finish.");
                    return;
                }
                new RenameClasses().start();
                MainViewerGUI.this.workPane.refreshClass.doClick();
                MainViewerGUI.this.fileNavigationPane.tree.updateUI();
            }
        });
        obfuscateMenu.add(this.mntmNewMenuItem_11);
        this.mntmNewMenuItem_9.setEnabled(false);
        obfuscateMenu.add(this.mntmNewMenuItem_9);
        this.mntmNewMenuItem_10.setEnabled(false);
        obfuscateMenu.add(this.mntmNewMenuItem_10);
        menuBar.add(pluginsMenu);
        pluginsMenu.add(this.mntmStartExternalPlugin);
        pluginsMenu.add(new JSeparator());
        pluginsMenu.add(this.mnRecentPlugins);
        pluginsMenu.add(new JSeparator());
        this.mntmCodeSequenceDiagram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.getLoadedClasses().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                PluginManager.runPlugin(new CodeSequenceDiagram());
            }
        });
        pluginsMenu.add(this.mntmCodeSequenceDiagram);
        pluginsMenu.add(this.mntmNewMenuItem_1);
        pluginsMenu.add(this.mntmShowMainMethods);
        pluginsMenu.add(this.mntmShowAllStrings);
        this.mntmReplaceStrings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.getLoadedClasses().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                new ReplaceStringsOptions().setVisible(true);
            }
        });
        pluginsMenu.add(this.mntmReplaceStrings);
        pluginsMenu.add(this.mntmNewMenuItem_2);
        pluginsMenu.add(this.mntmStartZkmString);
        this.mntmZstringarrayDecrypter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PluginManager.runPlugin(new ZStringArrayDecrypter());
            }
        });
        pluginsMenu.add(this.mntmZstringarrayDecrypter);
        menuBar.add(this.spinnerMenu);
        this.mntmStartExternalPlugin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(PluginManager.fileFilter());
                fc.setFileHidingEnabled(false);
                fc.setAcceptAllFileFilterUsed(false);
                int returnVal = fc.showOpenDialog(BytecodeViewer.viewer);
                if (returnVal == 0) {
                    try {
                        BytecodeViewer.viewer.setIcon(true);
                        BytecodeViewer.startPlugin(fc.getSelectedFile());
                        BytecodeViewer.viewer.setIcon(false);
                    }
                    catch (Exception e1) {
                        new ExceptionUI(e1);
                    }
                }
            }
        });
        this.mntmStartZkmString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManager.runPlugin(new ZKMStringDecrypter());
            }
        });
        this.mntmNewMenuItem_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (BytecodeViewer.getLoadedClasses().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                new AllatoriStringDecrypterOptions().setVisible(true);
            }
        });
        this.mntmNewMenuItem_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BytecodeViewer.getLoadedClasses().isEmpty()) {
                    BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                    return;
                }
                new MaliciousCodeScannerOptions().setVisible(true);
            }
        });
        this.mntmShowAllStrings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManager.runPlugin(new ShowAllStrings());
            }
        });
        this.mntmShowMainMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManager.runPlugin(new ShowMainMethods());
            }
        });
        MainViewerGUI.setUISize(this, Settings.GUI_WIDTH, Settings.GUI_HEIGHT);
        this.setTitle("Bytecode Viewer 3.0.0 - https://bytecodeviewer.com | https://the.bytecode.club - @Konloch");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        MainViewerGUI.setUISize(this.fileNavigationPane, Settings.FILE_NAVIGATION_PANE_WIDTH, Settings.FILE_NAVIGATION_PANE_HEIGHT);
        this.fileNavigationPane.setMinimumSize(new Dimension(200, 50));
        this.fileNavigationPane.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        MainViewerGUI.setUISize(this.searchingPane, Settings.SEARCHING_PANE_WIDTH, Settings.SEARCHING_PANE_HEIGHT);
        this.searchingPane.setMinimumSize(new Dimension(200, 50));
        this.searchingPane.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.sp1 = new JSplitPane(0, this.fileNavigationPane, this.searchingPane);
        this.sp2 = new JSplitPane(1, this.sp1, this.workPane);
        this.getContentPane().add(this.sp2);
        this.sp2.setResizeWeight(0.05);
        this.sp1.setResizeWeight(0.5);
        rfComps.add(this.fileNavigationPane);
        rfComps.add(this.searchingPane);
        rfComps.add(this.workPane);
        this.apkConversionGroup.add(this.apkConversionDex);
        this.apkConversionGroup.add(this.apkConversionEnjarify);
        this.apkConversionGroup.setSelected(this.apkConversionDex.getModel(), true);
        this.fontSpinner.setPreferredSize(new Dimension(42, 20));
        this.fontSpinner.setSize(new Dimension(42, 20));
        this.fontSpinner.setModel(new SpinnerNumberModel((Number)12, Integer.valueOf(1), null, (Number)1));
        viewMenu.add(this.mnFontSize);
        this.mnFontSize.add(this.fontSpinner);
        viewMenu.add(this.mnShowContainer);
        this.mnShowContainer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JTabbedPane tabs = MainViewerGUI.this.workPane.tabs;
                Component[] components = tabs.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    Component c = components[i];
                    if (!(c instanceof Viewer)) continue;
                    ((Viewer)c).updateName();
                    int idx = tabs.indexOfComponent(c);
                    tabs.setTabComponentAt(idx, new TabbedPane(c.getName(), tabs));
                    MainViewerGUI.this.workPane.tabs.setTitleAt(idx, c.getName());
                }
            }
        });
        for (int i = 0; i < this.allPanes.size(); ++i) {
            ButtonGroup pane = this.allPanes.get(i);
            Decompiler decompiler = null;
            try {
                decompiler = Settings.PANES.get().get(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pane.setSelected(this.allDecompilersRev.get(pane).get(decompiler).getModel(), true);
        }
        this.setLocationRelativeTo(null);
    }

    public void setIcon(final boolean busy) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (busy) {
                    try {
                        MainViewerGUI.this.spinnerMenu.setIcon(Resources.busyIcon);
                    }
                    catch (NullPointerException e) {
                        MainViewerGUI.this.spinnerMenu.setIcon(Resources.busyB64Icon);
                    }
                } else {
                    MainViewerGUI.this.spinnerMenu.setIcon(null);
                }
                MainViewerGUI.this.spinnerMenu.updateUI();
            }
        });
    }

    public void calledAfterLoad() {
    }

    @Override
    public void openClassFile(String name, String container, ClassNode cn) {
        for (VisibleComponent vc : rfComps) {
            vc.openClassFile(name, container, cn);
        }
    }

    @Override
    public void openFile(String name, String container, byte[] content) {
        for (VisibleComponent vc : rfComps) {
            vc.openFile(name, container, content);
        }
    }

    public static <T> T getComponent(Class<T> clazz) {
        for (VisibleComponent vc : rfComps) {
            if (vc.getClass() != clazz) continue;
            return clazz.cast(vc);
        }
        return null;
    }

    public class Test
    implements KeyEventDispatcher {
        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            BytecodeViewer.checkHotKey(e);
            return false;
        }
    }
}

