/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import com.jhe.hexed.JHexEditor;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.gui.ClassViewer;
import the.bytecode.club.bytecodeviewer.gui.Methods;

public class PaneUpdaterThread
extends Thread {
    private Decompiler decompiler;
    private int paneId;
    private JPanel target;
    private ClassViewer viewer;
    private RSyntaxTextArea panelArea;
    private JComboBox<Integer> methodsList;
    private JButton button;
    private final CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            int methodLine;
            Methods methods = ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.methods.get(PaneUpdaterThread.this.paneId);
            if (methods != null && (methodLine = methods.findActiveMethod(PaneUpdaterThread.this.panelArea.getCaretLineNumber())) != -1) {
                if (BytecodeViewer.viewer.showMethodsList.isSelected() && PaneUpdaterThread.this.methodsList != null && methodLine != (Integer)PaneUpdaterThread.this.methodsList.getSelectedItem()) {
                    PaneUpdaterThread.this.methodsList.setSelectedItem(methodLine);
                }
                if (BytecodeViewer.viewer.synchronizeViewing.isSelected()) {
                    for (int i = 0; i < ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.javas.size(); ++i) {
                        if (i == PaneUpdaterThread.this.paneId) continue;
                        ClassViewer.selectMethod(PaneUpdaterThread.this.viewer, i, methods.getMethod(methodLine));
                    }
                }
            }
        }
    };
    private final ChangeListener viewportListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (BytecodeViewer.viewer.synchronizeViewing.isSelected() && PaneUpdaterThread.this.panelArea.isShowing() && (PaneUpdaterThread.this.panelArea.hasFocus() || PaneUpdaterThread.this.panelArea.getMousePosition() != null)) {
                int activeMethodLine;
                int caretLine = PaneUpdaterThread.this.panelArea.getCaretLineNumber();
                int maxViewLine = ClassViewer.getMaxViewLine(PaneUpdaterThread.this.panelArea);
                int activeViewLine = ClassViewer.getViewLine(PaneUpdaterThread.this.panelArea);
                int activeLine = activeViewLine == maxViewLine && caretLine > maxViewLine ? caretLine : activeViewLine;
                int activeLineDelta = -1;
                Methods.Method activeMethod = null;
                Methods activeMethods = ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.methods.get(PaneUpdaterThread.this.paneId);
                if (activeMethods != null && (activeMethodLine = activeMethods.findActiveMethod(activeLine)) != -1) {
                    activeLineDelta = activeLine - activeMethodLine;
                    activeMethod = activeMethods.getMethod(activeMethodLine);
                    ClassViewer.selectMethod(PaneUpdaterThread.this.panelArea, activeMethodLine);
                }
                for (int i = 0; i < ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.javas.size(); ++i) {
                    if (i == PaneUpdaterThread.this.paneId) continue;
                    int setLine = -1;
                    RSyntaxTextArea area = ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.javas.get(i);
                    if (area == null) continue;
                    if (activeMethod != null && activeLineDelta >= 0) {
                        int viewLine;
                        int methodLine;
                        Methods methods = ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.methods.get(i);
                        if (methods != null && (methodLine = methods.findMethod(activeMethod)) != -1 && activeLineDelta != (viewLine = ClassViewer.getViewLine(area)) - methodLine) {
                            setLine = methodLine + activeLineDelta;
                        }
                    } else if (activeLine != ClassViewer.getViewLine(area)) {
                        setLine = activeLine;
                    }
                    if (setLine < 0) continue;
                    ClassViewer.setViewLine(area, setLine);
                }
            }
        }
    };

    public PaneUpdaterThread(ClassViewer viewer, Decompiler decompiler, int paneId, JPanel target, JButton button) {
        this.decompiler = decompiler;
        this.paneId = paneId;
        this.target = target;
        this.viewer = viewer;
        this.button = button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] b = BytecodeViewer.getClassBytes(this.viewer.container, this.viewer.cn.name + ".class");
            if (this.decompiler != Decompiler.HEXCODE) {
                this.panelArea = new RSyntaxTextArea();
                this.panelArea.setSyntaxEditingStyle("text/java");
                this.panelArea.setCodeFoldingEnabled(true);
                this.panelArea.setAntiAliasingEnabled(true);
                final RTextScrollPane scrollPane = new RTextScrollPane((Component)this.panelArea);
                JViewport viewport = scrollPane.getViewport();
                viewport.addChangeListener(this.viewportListener);
                this.panelArea.addCaretListener(this.caretListener);
                this.panelArea.setText(this.decompiler.decompileClassNode(this.viewer.cn, b));
                Methods methods = this.viewer.methods.get(this.paneId);
                for (int i = 0; i < this.panelArea.getLineCount(); ++i) {
                    String lineText = ClassViewer.getLineText(this.panelArea, i);
                    Serializable[] regexMatcher = Methods.regex.matcher(lineText);
                    if (!regexMatcher.find()) continue;
                    String methodName = regexMatcher.group("name");
                    String methodParams = regexMatcher.group("params");
                    methods.addMethod(i, methodName, methodParams);
                }
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem synchronize = new JMenuItem("Synchronize");
                synchronize.addActionListener(new ClassViewer.SynchronizeActionListener(this.viewer, this.paneId));
                popupMenu.add(synchronize);
                popupMenu.addSeparator();
                for (Component component : this.panelArea.getPopupMenu().getComponents()) {
                    popupMenu.add(component);
                }
                this.panelArea.setPopupMenu(popupMenu);
                this.panelArea.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            int line = e.getY() > PaneUpdaterThread.this.panelArea.getLineHeight() ? e.getY() / PaneUpdaterThread.this.panelArea.getLineHeight() : 0;
                            ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.activeLines.set(PaneUpdaterThread.this.paneId, line);
                        }
                    }
                });
                this.panelArea.setCaretPosition(0);
                this.panelArea.setEditable(this.viewer.isPaneEditable(this.paneId));
                this.panelArea.addKeyListener(new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 70 && (e.getModifiers() & 2) != 0) {
                            PaneUpdaterThread.this.viewer.requestFocus(PaneUpdaterThread.this.paneId);
                        }
                        BytecodeViewer.checkHotKey(e);
                    }

                    @Override
                    public void keyReleased(KeyEvent arg0) {
                    }

                    @Override
                    public void keyTyped(KeyEvent arg0) {
                    }
                });
                scrollPane.setColumnHeaderView((Component)new JLabel(this.decompiler.getName() + " Decompiler - Editable: " + this.panelArea.isEditable()));
                this.panelArea.setFont(new Font("Monospaced", 0, (Integer)BytecodeViewer.viewer.fontSpinner.getValue()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaneUpdaterThread.this.target.add((Component)scrollPane);
                    }
                });
                this.viewer.updatePane(this.paneId, this.panelArea, this.decompiler);
                if (BytecodeViewer.viewer.showMethodsList.isSelected() && !methods.isEmpty()) {
                    this.methodsList = new JComboBox();
                    for (Serializable serializable : methods.getMethodsLines()) {
                        this.methodsList.addItem((Integer)serializable);
                    }
                    this.methodsList.setRenderer(new MethodsRenderer());
                    this.methodsList.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int line = (Integer)PaneUpdaterThread.this.methodsList.getSelectedItem();
                            ClassViewer.selectMethod(((PaneUpdaterThread)PaneUpdaterThread.this).viewer.javas.get(PaneUpdaterThread.this.paneId), line);
                        }
                    });
                    JPanel searchPanel = this.viewer.searches.get(this.paneId);
                    searchPanel.add(this.methodsList, "South");
                }
            } else {
                final JHexEditor hex = new JHexEditor(b);
                hex.setFont(new Font("Monospaced", 0, (Integer)BytecodeViewer.viewer.fontSpinner.getValue()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaneUpdaterThread.this.target.add(hex);
                    }
                });
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        finally {
            this.viewer.resetDivider();
            BytecodeViewer.viewer.setIcon(false);
            if (this.button != null) {
                this.button.setEnabled(true);
            }
        }
    }

    class MethodsRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public MethodsRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Methods methods = ((PaneUpdaterThread)PaneUpdaterThread.this).viewer.methods.get(PaneUpdaterThread.this.paneId);
            Methods.Method method = methods.getMethod((Integer)value);
            this.setText(method.toString());
            return this;
        }
    }
}

