/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.FileChangeNotifier;
import the.bytecode.club.bytecodeviewer.gui.FileNavigationPane;
import the.bytecode.club.bytecodeviewer.gui.MainViewerGUI;
import the.bytecode.club.bytecodeviewer.gui.Viewer;
import the.bytecode.club.bytecodeviewer.gui.VisibleComponent;
import the.bytecode.club.bytecodeviewer.gui.WorkPane;
import the.bytecode.club.bytecodeviewer.searching.BackgroundSearchThread;
import the.bytecode.club.bytecodeviewer.searching.FieldCallSearch;
import the.bytecode.club.bytecodeviewer.searching.LDCSearch;
import the.bytecode.club.bytecodeviewer.searching.MethodCallSearch;
import the.bytecode.club.bytecodeviewer.searching.RegexInsnFinder;
import the.bytecode.club.bytecodeviewer.searching.RegexSearch;
import the.bytecode.club.bytecodeviewer.searching.SearchResultNotifier;
import the.bytecode.club.bytecodeviewer.searching.SearchTypeDetails;

public class SearchingPane
extends VisibleComponent {
    private static final long serialVersionUID = -1098524689236993932L;
    FileChangeNotifier fcn;
    JCheckBox exact = new JCheckBox("Exact");
    DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("Root");
    JTree tree;
    SearchType searchType = null;
    JComboBox searchRadiusBox;
    public JButton search = new JButton("Search");
    transient BackgroundSearchThread t = new BackgroundSearchThread(true){

        @Override
        public void doSearch() {
        }
    };

    public SearchingPane(FileChangeNotifier fcn) {
        super("Search");
        this.fcn = fcn;
        JPanel optionPanel = new JPanel(new BorderLayout());
        JPanel searchRadiusOpt = new JPanel(new BorderLayout());
        JPanel searchOpts = new JPanel(new GridLayout(2, 1));
        searchRadiusOpt.add((Component)new JLabel("Search from "), "West");
        DefaultComboBoxModel<Enum> model = new DefaultComboBoxModel<Enum>();
        for (SearchRadius searchRadius : SearchRadius.values()) {
            model.addElement(searchRadius);
        }
        this.searchRadiusBox = new JComboBox(model);
        searchRadiusOpt.add((Component)this.searchRadiusBox, "Center");
        searchOpts.add(searchRadiusOpt);
        model = new DefaultComboBoxModel();
        for (Enum enum_ : SearchType.values()) {
            model.addElement(enum_);
        }
        final JComboBox typeBox = new JComboBox(model);
        final JPanel searchOptPanel = new JPanel();
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                searchOptPanel.removeAll();
                SearchingPane.this.searchType = (SearchType)((Object)typeBox.getSelectedItem());
                searchOptPanel.add(SearchingPane.this.searchType.details.getPanel());
                searchOptPanel.revalidate();
                searchOptPanel.repaint();
            }
        };
        typeBox.addItemListener(il);
        typeBox.setSelectedItem((Object)SearchType.LDC);
        il.itemStateChanged(null);
        searchOpts.add(typeBox);
        optionPanel.add((Component)searchOpts, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)searchOptPanel, "North");
        jPanel.add((Component)this.exact, "South");
        optionPanel.add((Component)jPanel, "Center");
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Viewer cv;
                SearchingPane.this.treeRoot.removeAllChildren();
                SearchingPane.this.searchType = (SearchType)((Object)typeBox.getSelectedItem());
                SearchRadius radius = (SearchRadius)((Object)SearchingPane.this.searchRadiusBox.getSelectedItem());
                final SearchResultNotifier srn = new SearchResultNotifier(){

                    @Override
                    public void notifyOfResult(String debug) {
                        SearchingPane.this.treeRoot.add(new DefaultMutableTreeNode(debug));
                    }
                };
                if (radius == SearchRadius.All_Classes) {
                    if (SearchingPane.this.t.finished) {
                        SearchingPane.this.t = new BackgroundSearchThread(){

                            @Override
                            public void doSearch() {
                                try {
                                    Pattern.compile(RegexInsnFinder.processRegex(RegexSearch.searchText.getText()), 8);
                                }
                                catch (PatternSyntaxException ex) {
                                    BytecodeViewer.showMessage("You have an error in your regex syntax.");
                                }
                                for (ClassNode cln : BytecodeViewer.getLoadedClasses()) {
                                    SearchingPane.this.searchType.details.search(cln, srn, SearchingPane.this.exact.isSelected());
                                }
                                MainViewerGUI.getComponent(SearchingPane.class).search.setEnabled(true);
                                MainViewerGUI.getComponent(SearchingPane.class).search.setText("Search");
                                SearchingPane.this.tree.expandPath(new TreePath(SearchingPane.this.tree.getModel().getRoot()));
                                SearchingPane.this.tree.updateUI();
                            }
                        };
                        MainViewerGUI.getComponent(SearchingPane.class).search.setEnabled(false);
                        MainViewerGUI.getComponent(SearchingPane.class).search.setText("Searching, please wait..");
                        SearchingPane.this.t.start();
                    } else {
                        BytecodeViewer.showMessage("You currently have a search performing in the background, please wait for that to finish.");
                    }
                } else if (radius == SearchRadius.Current_Class && (cv = MainViewerGUI.getComponent(WorkPane.class).getCurrentViewer()) != null) {
                    SearchingPane.this.searchType.details.search(cv.cn, srn, SearchingPane.this.exact.isSelected());
                }
            }
        });
        optionPanel.add((Component)this.search, "South");
        this.tree = new JTree(this.treeRoot);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(optionPanel), "North");
        this.getContentPane().add((Component)new JScrollPane(this.tree), "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                String className;
                String path = arg0.getPath().toString();
                String containerName = arg0.getPath().getPathComponent(1).toString();
                ClassNode fN = BytecodeViewer.getClassNode(containerName, className = path.split(", ")[1].split("\\.")[0]);
                if (fN != null) {
                    MainViewerGUI.getComponent(FileNavigationPane.class).openClassFileToWorkSpace(className + ".class", containerName, fN);
                }
                System.out.println(className);
            }
        });
        this.setVisible(true);
    }

    public void resetWorkspace() {
        this.treeRoot.removeAllChildren();
        this.tree.updateUI();
    }

    @Override
    public void openFile(String name, String container, byte[] contents) {
    }

    public static enum SearchRadius {
        All_Classes,
        Current_Class;

    }

    public static enum SearchType {
        LDC(new LDCSearch()),
        Regex(new RegexSearch()),
        MethodCall(new MethodCallSearch()),
        FieldCall(new FieldCallSearch());

        public final SearchTypeDetails details;

        private SearchType(SearchTypeDetails details) {
            this.details = details;
        }
    }
}

