/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.Resources;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;

public class SystemErrConsole
extends JFrame {
    JTextArea textArea = new JTextArea();
    JPanel panel = new JPanel(new BorderLayout());
    JScrollPane scrollPane = new JScrollPane();
    public JCheckBox check = new JCheckBox("Exact");
    final JTextField field = new JTextField();
    private PrintStream originalOut;
    CustomOutputStream s;
    private DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 62, 150));
    private static final long serialVersionUID = -6556940545421437508L;

    public SystemErrConsole(String title) {
        this.setIconImages(Resources.iconList);
        this.setTitle(title);
        this.setSize(new Dimension(542, 316));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.setViewportView(this.textArea);
        this.textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && (e.getModifiers() & 2) != 0) {
                    SystemErrConsole.this.field.requestFocus();
                }
                BytecodeViewer.checkHotKey(e);
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        JButton searchNext = new JButton();
        JButton searchPrev = new JButton();
        JPanel buttonPane = new JPanel(new BorderLayout());
        buttonPane.add((Component)searchNext, "West");
        buttonPane.add((Component)searchPrev, "East");
        searchNext.setIcon(Resources.nextIcon);
        searchPrev.setIcon(Resources.prevIcon);
        this.panel.add((Component)buttonPane, "West");
        this.panel.add((Component)this.field, "Center");
        this.panel.add((Component)this.check, "East");
        searchNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SystemErrConsole.this.search(SystemErrConsole.this.field.getText(), true);
            }
        });
        searchPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SystemErrConsole.this.search(SystemErrConsole.this.field.getText(), false);
            }
        });
        this.field.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    SystemErrConsole.this.search(SystemErrConsole.this.field.getText(), true);
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.scrollPane.setColumnHeaderView(this.panel);
        this.setLocationRelativeTo(null);
        this.s = new CustomOutputStream(this.textArea);
        PrintStream printStream = new PrintStream(this.s);
        this.originalOut = System.err;
        System.setErr(printStream);
    }

    public void finished() {
        if (this.originalOut != null) {
            System.setErr(this.originalOut);
        }
    }

    public void pretty() {
        this.s.update();
        String[] test = null;
        test = this.textArea.getText().split("\n").length >= 2 ? this.textArea.getText().split("\n") : this.textArea.getText().split("\r");
        String replace = "";
        for (String s : test) {
            if (s.startsWith("File '")) {
                String[] split = s.split("'");
                String start = split[0] + "'" + split[1] + "', ";
                s = s.substring(start.length(), s.length());
            }
            replace = replace + s + BytecodeViewer.nl;
        }
        this.setText(replace);
    }

    public void search(String search, boolean next) {
        try {
            JTextArea area = this.textArea;
            if (search.isEmpty()) {
                this.highlight(area, "");
                return;
            }
            int startLine = area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition()) + 1;
            int currentLine = 1;
            boolean canSearch = false;
            String[] test = null;
            test = area.getText().split("\n").length >= 2 ? area.getText().split("\n") : area.getText().split("\r");
            int lastGoodLine = -1;
            int firstPos = -1;
            boolean found = false;
            if (next) {
                for (String s : test) {
                    if (!this.check.isSelected()) {
                        s = s.toLowerCase();
                        search = search.toLowerCase();
                    }
                    if (currentLine == startLine) {
                        canSearch = true;
                    } else if (s.contains(search)) {
                        if (canSearch) {
                            area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(currentLine - 1).getStartOffset());
                            canSearch = false;
                            found = true;
                        }
                        if (firstPos == -1) {
                            firstPos = currentLine;
                        }
                    }
                    ++currentLine;
                }
                if (!found && firstPos != -1) {
                    area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(firstPos - 1).getStartOffset());
                }
            } else {
                canSearch = true;
                for (String s : test) {
                    if (!this.check.isSelected()) {
                        s = s.toLowerCase();
                        search = search.toLowerCase();
                    }
                    if (s.contains(search)) {
                        if (lastGoodLine != -1 && canSearch) {
                            area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(lastGoodLine - 1).getStartOffset());
                        }
                        lastGoodLine = currentLine;
                        if (currentLine >= startLine) {
                            canSearch = false;
                        }
                    }
                    ++currentLine;
                }
                if (lastGoodLine != -1 && area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition()) + 1 == startLine) {
                    area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(lastGoodLine - 1).getStartOffset());
                }
            }
            this.highlight(area, search);
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public void highlight(JTextComponent textComp, String pattern) {
        if (pattern.isEmpty()) {
            textComp.getHighlighter().removeAllHighlights();
            return;
        }
        try {
            Highlighter hilite = textComp.getHighlighter();
            hilite.removeAllHighlights();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            int pos = 0;
            if (!this.check.isSelected()) {
                pattern = pattern.toLowerCase();
                text = text.toLowerCase();
            }
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                hilite.addHighlight(pos, pos + pattern.length(), this.painter);
                pos += pattern.length();
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public void appendText(String t) {
        this.textArea.setText((this.textArea.getText().isEmpty() ? "" : this.textArea.getText() + "\r\n") + t);
        this.textArea.setCaretPosition(0);
    }

    public void setText(String t) {
        this.textArea.setText(t);
        this.textArea.setCaretPosition(0);
    }

    class CustomOutputStream
    extends OutputStream {
        private StringBuffer sb = new StringBuffer();
        private JTextArea textArea;

        public CustomOutputStream(JTextArea textArea) {
            this.textArea = textArea;
        }

        public void update() {
            this.textArea.append(this.sb.toString());
        }

        @Override
        public void write(int b) throws IOException {
            this.sb.append(String.valueOf((char)b));
        }
    }
}

