/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabbedPane
extends JPanel {
    private static final long serialVersionUID = -4774885688297538774L;
    private final JTabbedPane pane;
    final JButton button = new TabButton();
    private static long zero = System.currentTimeMillis();
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public TabbedPane(String name, final JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        JLabel label = new JLabel(){
            private static final long serialVersionUID = -5511025206527893360L;

            @Override
            public String getText() {
                int i = pane.indexOfTabComponent(TabbedPane.this);
                if (i != -1) {
                    return pane.getTitleAt(i);
                }
                return null;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension realDimension = super.getPreferredSize();
                if (realDimension.getWidth() >= 400.0) {
                    return new Dimension(400, 20);
                }
                return realDimension;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(this.button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        JPopupMenu pop_up = new JPopupMenu();
        JMenuItem closealltab = new JMenuItem("Close All But This: " + name);
        JMenuItem closetab = new JMenuItem("Close Tab: " + name);
        closetab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = e.getActionCommand().split(": ")[1];
                int i = pane.indexOfTab(name);
                if (i != -1) {
                    pane.remove(i);
                }
            }
        });
        closealltab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = e.getActionCommand().split(": ")[1];
                System.out.println(name);
                boolean removedAll = false;
                while (!removedAll) {
                    int thisID = pane.indexOfTab(name);
                    if (pane.getTabCount() <= 1) {
                        removedAll = true;
                        return;
                    }
                    if (thisID != 0) {
                        pane.remove(0);
                        continue;
                    }
                    pane.remove(1);
                }
            }
        });
        pop_up.add(closealltab);
        pop_up.add(closetab);
        this.button.setComponentPopupMenu(pop_up);
        this.button.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 8 && System.currentTimeMillis() - zero >= 100L) {
                    zero = System.currentTimeMillis();
                    int i = pane.indexOfTabComponent(TabbedPane.this);
                    if (i != -1) {
                        pane.remove(i);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -4492967978286454159L;

        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(17, 17));
            this.setToolTipText("Close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = TabbedPane.this.pane.indexOfTabComponent(TabbedPane.this);
            if (i != -1) {
                TabbedPane.this.pane.remove(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            int delta = 6;
            g2.drawLine(6, 6, this.getWidth() - 6 - 1, this.getHeight() - 6 - 1);
            g2.drawLine(this.getWidth() - 6 - 1, 6, 6, this.getHeight() - 6 - 1);
            g2.dispose();
        }
    }
}

