/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.FileChangeNotifier;
import the.bytecode.club.bytecodeviewer.gui.ClassViewer;
import the.bytecode.club.bytecodeviewer.gui.FileViewer;
import the.bytecode.club.bytecodeviewer.gui.TabbedPane;
import the.bytecode.club.bytecodeviewer.gui.Viewer;
import the.bytecode.club.bytecodeviewer.gui.VisibleComponent;

public class WorkPane
extends VisibleComponent
implements ActionListener {
    private static final long serialVersionUID = 6542337997679487946L;
    FileChangeNotifier fcn;
    public JTabbedPane tabs;
    JPanel buttonPanel;
    JButton refreshClass;
    HashMap<String, Integer> workingOn = new HashMap();
    public static int SyntaxFontHeight = 12;
    int tabCount = 0;

    public WorkPane(FileChangeNotifier fcn) {
        super("WorkPanel");
        this.setTitle("Work Space");
        this.tabs = new JTabbedPane();
        this.fcn = fcn;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabs, "Center");
        this.buttonPanel = new JPanel(new FlowLayout());
        this.refreshClass = new JButton("Refresh");
        this.refreshClass.addActionListener(this);
        this.buttonPanel.add(this.refreshClass);
        this.buttonPanel.setVisible(false);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.tabs.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c instanceof ClassViewer) {
                    ClassViewer cv = (ClassViewer)c;
                    WorkPane.this.workingOn.remove(cv.container + "$" + cv.name);
                }
                if (c instanceof FileViewer) {
                    FileViewer fv = (FileViewer)c;
                    WorkPane.this.workingOn.remove(fv.container + "$" + fv.name);
                }
            }
        });
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                WorkPane.this.buttonPanel.setVisible(WorkPane.this.tabs.getSelectedIndex() != -1);
            }
        });
        this.setVisible(true);
    }

    public void addWorkingFile(String name, String container, ClassNode cn) {
        String key = container + "$" + name;
        if (!this.workingOn.containsKey(key)) {
            ClassViewer tabComp = new ClassViewer(name, container, cn);
            this.tabs.add(tabComp);
            int tabCount = this.tabs.indexOfComponent(tabComp);
            this.workingOn.put(key, tabCount);
            this.tabs.setTabComponentAt(tabCount, new TabbedPane(name, this.tabs));
            this.tabs.setSelectedIndex(tabCount);
        } else {
            this.tabs.setSelectedIndex(this.workingOn.get(key));
        }
    }

    public void addFile(String name, String container, byte[] contents) {
        if (contents == null) {
            return;
        }
        String key = container + "$" + name;
        if (!this.workingOn.containsKey(key)) {
            FileViewer tabComp = new FileViewer(name, container, contents);
            this.tabs.add(tabComp);
            int tabCount = this.tabs.indexOfComponent(tabComp);
            this.workingOn.put(key, tabCount);
            this.tabs.setTabComponentAt(tabCount, new TabbedPane(name, this.tabs));
            this.tabs.setSelectedIndex(tabCount);
        } else {
            this.tabs.setSelectedIndex(this.workingOn.get(key));
        }
    }

    @Override
    public void openClassFile(String name, String container, ClassNode cn) {
        this.addWorkingFile(name, container, cn);
    }

    @Override
    public void openFile(String name, String container, byte[] content) {
        this.addFile(name, container, content);
    }

    public Viewer getCurrentViewer() {
        return (Viewer)this.tabs.getSelectedComponent();
    }

    public Component[] getLoadedViewers() {
        return this.tabs.getComponents();
    }

    @Override
    public void actionPerformed(final ActionEvent arg0) {
        Thread t = new Thread(){

            @Override
            public void run() {
                Component tabComp;
                JButton src;
                if (BytecodeViewer.viewer.compileOnRefresh.isSelected()) {
                    try {
                        if (!BytecodeViewer.compile(false)) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if ((src = (JButton)arg0.getSource()) == WorkPane.this.refreshClass && (tabComp = WorkPane.this.tabs.getSelectedComponent()) != null) {
                    if (tabComp instanceof ClassViewer) {
                        src.setEnabled(false);
                        BytecodeViewer.viewer.setIcon(true);
                        ((ClassViewer)tabComp).startPaneUpdater(src);
                        BytecodeViewer.viewer.setIcon(false);
                    } else if (tabComp instanceof FileViewer) {
                        src.setEnabled(false);
                        BytecodeViewer.viewer.setIcon(true);
                        ((FileViewer)tabComp).refresh(src);
                        BytecodeViewer.viewer.setIcon(false);
                    }
                }
            }
        };
        t.start();
    }

    public void resetWorkspace() {
        for (Component component : this.tabs.getComponents()) {
            ((ClassViewer)component).reset();
        }
        this.tabs.removeAll();
        this.tabs.updateUI();
    }
}

