/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.obfuscators.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.commons.Remapper;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.HookMap;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.data.FieldMappingData;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.data.MappingData;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.data.MethodMappingData;

public class RefactorMapper
extends Remapper {
    protected final Map<String, MappingData> sortedClasses = new HashMap<String, MappingData>();
    protected final Map<String, MethodMappingData> sortedMethods = new HashMap<String, MethodMappingData>();
    protected final Map<String, FieldMappingData> sortedFields = new HashMap<String, FieldMappingData>();
    protected final List<String> mappingList = new ArrayList<String>();
    private StringBuilder builder = new StringBuilder();

    public RefactorMapper(HookMap hookMap) {
        String obfuscatedCname;
        String obfuscatedDesc;
        String obfuscatedName;
        for (MappingData mappingData : hookMap.getClasses()) {
            if (mappingData.getObfuscatedName().contains("$")) continue;
            obfuscatedName = mappingData.getObfuscatedName();
            String refactoredName = mappingData.getRefactoredName();
            this.sortedClasses.put(obfuscatedName, mappingData);
            this.sortedClasses.put(refactoredName, mappingData);
        }
        for (MethodMappingData methodMappingData : hookMap.getMethods()) {
            obfuscatedName = methodMappingData.getMethodName().getObfuscatedName();
            obfuscatedDesc = methodMappingData.getMethodDesc();
            obfuscatedCname = methodMappingData.getMethodOwner();
            this.sortedMethods.put(obfuscatedCname + "$$$$" + obfuscatedName + "$$$$" + obfuscatedDesc, methodMappingData);
        }
        for (FieldMappingData fieldMappingData : hookMap.getFields()) {
            obfuscatedName = fieldMappingData.getName().getObfuscatedName();
            obfuscatedDesc = fieldMappingData.getDesc();
            obfuscatedCname = fieldMappingData.getFieldOwner();
            this.sortedFields.put(obfuscatedCname + "$$$$" + obfuscatedName + "$$$$" + obfuscatedDesc, fieldMappingData);
        }
    }

    @Override
    public String map(String type) {
        if (this.sortedClasses.containsKey(type)) {
            String map = type + " --> " + this.sortedClasses.get(type).getRefactoredName() + "\n";
            if (!this.mappingList.contains(map)) {
                this.mappingList.add(map);
            }
            return this.sortedClasses.get(type).getRefactoredName();
        }
        return type;
    }

    @Override
    public String mapFieldName(String owner, String name, String desc) {
        String obfKey = owner + "$$$$" + name + "$$$$" + desc;
        if (this.sortedFields.containsKey(obfKey)) {
            String map = owner + "." + name + " --> " + owner + this.sortedFields.get(obfKey).getName().getRefactoredName() + "\n";
            if (!this.mappingList.contains(map)) {
                this.mappingList.add(map);
            }
            name = this.sortedFields.get(obfKey).getName().getRefactoredName();
        }
        return name;
    }

    @Override
    public String mapMethodName(String owner, String name, String desc) {
        String obfKey = owner + "$$$$" + name + "$$$$" + desc;
        if (this.sortedMethods.containsKey(obfKey)) {
            String map = owner + "." + name + " --> " + owner + this.sortedMethods.get(obfKey).getMethodName().getRefactoredName() + "\n";
            if (!this.mappingList.contains(map)) {
                this.mappingList.add(map);
            }
            name = this.sortedMethods.get(obfKey).getMethodName().getRefactoredName();
        }
        return name;
    }

    public void printMap() {
        for (String map : this.mappingList) {
            this.builder.append(map);
        }
        System.out.println(this.builder.toString());
    }
}

