/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.obfuscators.mapping;

import java.util.HashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.HookMap;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.RefactorMapper;

public class Refactorer {
    protected HookMap hooks = new HookMap();

    public HookMap getHooks() {
        return this.hooks;
    }

    public void run() {
        if (this.getHooks() == null) {
            return;
        }
        RefactorMapper mapper = new RefactorMapper(this.getHooks());
        HashMap<String, ClassNode> refactored = new HashMap<String, ClassNode>();
        for (ClassNode cn : BytecodeViewer.getLoadedClasses()) {
            String oldName = cn.name;
            ClassReader cr = new ClassReader(this.getClassNodeBytes(cn));
            ClassWriter cw = new ClassWriter(cr, 0);
            RemappingClassAdapter rca = new RemappingClassAdapter(cw, mapper);
            cr.accept(rca, 8);
            cr = new ClassReader(cw.toByteArray());
            cn = new ClassNode();
            cr.accept(cn, 0);
            refactored.put(oldName, cn);
        }
        mapper.printMap();
    }

    private byte[] getClassNodeBytes(ClassNode cn) {
        ClassWriter cw = new ClassWriter(0);
        cn.accept(cw);
        byte[] b = cw.toByteArray();
        return b;
    }
}

