/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin.preinstalled;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.api.PluginConsole;

public class AllatoriStringDecrypter
extends Plugin {
    PluginConsole frame = new PluginConsole("Allatori decrypter");
    StringBuilder out = new StringBuilder();
    private String className;

    public AllatoriStringDecrypter(String className) {
        this.className = className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ArrayList<ClassNode> classNodeList) {
        JOptionPane pane = new JOptionPane("WARNING: This will load the classes into the JVM and execute allatori decrypter function" + BytecodeViewer.nl + "for each class. IF THE FILE YOU'RE LOADING IS MALICIOUS, DO NOT CONTINUE.");
        Object[] options = new String[]{"Continue", "Cancel"};
        pane.setOptions(options);
        JDialog dialog = pane.createDialog(BytecodeViewer.viewer, "Bytecode Viewer - WARNING");
        dialog.setVisible(true);
        Object obj = pane.getValue();
        int result = -1;
        for (int k = 0; k < options.length; ++k) {
            if (!options[k].equals(obj)) continue;
            result = k;
        }
        if (result == 0) {
            try {
                if (!this.className.equals("*")) {
                    for (ClassNode classNode : classNodeList) {
                        if (!classNode.name.equals(this.className)) continue;
                        this.scanClassNode(classNode);
                    }
                } else {
                    for (ClassNode classNode : classNodeList) {
                        this.scanClassNode(classNode);
                    }
                }
            }
            catch (Exception e) {
                new ExceptionUI(e, "github.com/Szperak");
            }
            finally {
                this.frame.appendText(this.out.toString());
                this.frame.setVisible(true);
            }
        }
    }

    private void log(String msg) {
        this.out.append(msg);
        this.out.append(BytecodeViewer.nl);
    }

    public void scanClassNode(ClassNode classNode) throws Exception {
        for (MethodNode method : classNode.methods) {
            this.scanMethodNode(classNode, method);
        }
    }

    public int readUnsignedShort(byte[] b, int index) {
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    private int getConstantPoolSize(String className) {
        byte[] fileContents = BytecodeViewer.getFileContents(className + ".class");
        return this.readUnsignedShort(fileContents, 8);
    }

    public void scanMethodNode(ClassNode classNode, MethodNode methodNode) throws Exception {
        InsnList iList = methodNode.instructions;
        this.log("Scanning method " + methodNode.name + " of " + classNode.name);
        LdcInsnNode laststringldconstack = null;
        for (AbstractInsnNode i : iList.toArray()) {
            AbstractInsnNode methodi;
            if (i instanceof LdcInsnNode) {
                LdcInsnNode ldci = (LdcInsnNode)i;
                if (!(ldci.cst instanceof String)) continue;
                laststringldconstack = ldci;
                continue;
            }
            if (i instanceof MethodInsnNode) {
                methodi = (MethodInsnNode)i;
                if (laststringldconstack != null && methodi.opcode() == 184) {
                    String decrypterclassname = ((MethodInsnNode)methodi).owner;
                    String decryptermethodname = ((MethodInsnNode)methodi).name;
                    if (decrypterclassname.contains("$")) {
                        byte[] decrypterFileContents = BytecodeViewer.getFileContents(decrypterclassname + ".class");
                        ClassNode decrypterclassnode = JarUtils.getNode(decrypterFileContents);
                        if (decrypterclassnode != null) {
                            MethodNode decryptermethodnode = null;
                            for (MethodNode uncasted : decrypterclassnode.methods) {
                                if (!uncasted.name.equals(decryptermethodname)) continue;
                                decryptermethodnode = uncasted;
                            }
                            if (decryptermethodnode != null) {
                                String keyString = this.getConstantPoolSize(classNode.name) + classNode.name + methodNode.name + this.getConstantPoolSize(classNode.name);
                                int newHashCode = keyString.hashCode();
                                this.scanDecrypter(decryptermethodnode, newHashCode);
                                try {
                                    System.out.println("loading " + decrypterclassname);
                                    List<Class<?>> decrypterclasslist = the.bytecode.club.bytecodeviewer.api.BytecodeViewer.loadClassesIntoClassLoader(new ArrayList<ClassNode>(Arrays.asList(decrypterclassnode)));
                                    String decrypted = this.invokeDecrypter(decrypterclasslist.get(0), decryptermethodname, (String)laststringldconstack.cst);
                                    if (decrypted != null) {
                                        this.log("Succesfully invoked decrypter method: " + decrypted);
                                        laststringldconstack.cst = decrypted;
                                        iList.remove(methodi);
                                    }
                                }
                                catch (IOException | ClassNotFoundException | IndexOutOfBoundsException e) {
                                    e.printStackTrace();
                                    this.log("Could not load decrypter class: " + decrypterclassname);
                                }
                            } else {
                                this.log("Could not find decrypter method (" + decryptermethodname + ") of class " + decrypterclassname);
                            }
                        } else {
                            this.log("Could not find decrypter ClassNode of class " + decrypterclassname);
                        }
                    }
                }
            } else if (!(i instanceof InvokeDynamicInsnNode) || (methodi = (InvokeDynamicInsnNode)i).opcode() == 186) {
                // empty if block
            }
            laststringldconstack = null;
        }
    }

    private boolean scanDecrypter(MethodNode decryptermethodnode, int newHashCode) {
        InsnList iList = decryptermethodnode.instructions;
        AbstractInsnNode insn = null;
        AbstractInsnNode removeInsn = null;
        for (AbstractInsnNode i : iList.toArray()) {
            if (!(i instanceof MethodInsnNode)) continue;
            MethodInsnNode methodi = (MethodInsnNode)i;
            if (!"currentThread".equals(methodi.name)) continue;
            insn = i;
            break;
        }
        if (insn == null) {
            return false;
        }
        while (insn != null) {
            if (insn instanceof MethodInsnNode) {
                MethodInsnNode methodi = (MethodInsnNode)insn;
                if ("hashCode".equals(methodi.name)) break;
            }
            removeInsn = insn;
            insn = insn.getNext();
            iList.remove(removeInsn);
        }
        if (insn == null) {
            return false;
        }
        iList.set(insn, new LdcInsnNode((Object)newHashCode));
        return true;
    }

    private String invokeDecrypter(Class<?> decrypterclass, String name, String arg) throws Exception {
        try {
            Method decryptermethod = decrypterclass.getDeclaredMethod(name, String.class);
            decryptermethod.setAccessible(true);
            return (String)decryptermethod.invoke(null, arg);
        }
        catch (Exception e) {
            this.log("Could not invoke decrypter method: " + name + " of class " + decrypterclass.getName());
            throw e;
        }
    }
}

