/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin.preinstalled;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.api.BytecodeHook;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.api.PluginConsole;
import the.bytecode.club.bytecodeviewer.gui.GraphicialReflectionKit;

public class EZInjection
extends Plugin {
    public static ArrayList<BytecodeHook> hookArray = new ArrayList();
    private static String version = "1.0";
    private static PluginConsole gui = new PluginConsole("EZ Injection v" + version);
    private boolean accessModifiers;
    private boolean injectHooks;
    private boolean invokeMethod;
    private boolean useProxy;
    private boolean launchKit;
    private boolean console;
    public static boolean sandboxSystem;
    public static boolean sandboxRuntime;
    public static boolean printCmdL;
    private static boolean debugHooks;
    private static boolean all;
    private String invokeMethodInformation;
    private String proxy;
    private static String[] debugClasses;
    private static String lastMessage;

    public EZInjection(boolean accessModifiers, boolean injectHooks, boolean debugHooks, boolean invokeMethod, String invokeMethodInformation, boolean sandboxRuntime, boolean sandboxSystem, String debugClasses, String proxy, boolean useProxy, boolean launchKit, boolean console, boolean printCmdL) {
        the.bytecode.club.bytecodeviewer.api.BytecodeViewer.createNewClassNodeLoaderInstance();
        this.accessModifiers = accessModifiers;
        this.injectHooks = injectHooks;
        EZInjection.debugHooks = debugHooks;
        this.invokeMethod = invokeMethod;
        this.invokeMethodInformation = invokeMethodInformation + "([Ljava/lang/String;)V";
        EZInjection.sandboxRuntime = sandboxRuntime;
        EZInjection.sandboxSystem = sandboxSystem;
        if (debugClasses.equals("*")) {
            all = true;
        } else {
            EZInjection.debugClasses = debugClasses.split(",");
        }
        this.proxy = proxy;
        this.useProxy = useProxy;
        this.launchKit = launchKit;
        this.console = console;
        EZInjection.printCmdL = printCmdL;
    }

    public static void setProxy(String host, String port) {
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("socksProxyHost", host);
        System.setProperty("socksProxyPort", port);
    }

    public static void hook(String info) {
        for (BytecodeHook hook : hookArray) {
            hook.callHook(info);
        }
        if (debugHooks) {
            if (lastMessage.equals(info)) {
                return;
            }
            lastMessage = info;
            boolean print = all;
            if (!all && debugClasses.length >= 1) {
                for (String s : debugClasses) {
                    if (!info.split("\\.")[0].equals(s.replaceAll("\\.", "/"))) continue;
                    print = true;
                }
            }
            if (print) {
                EZInjection.print("Method call: " + info);
            }
        }
    }

    public static void print(String message) {
        if (printCmdL) {
            System.out.println(message);
        }
        if (gui.isVisible()) {
            gui.appendText(message);
        }
    }

    @Override
    public void execute(ArrayList<ClassNode> classNodeList) {
        MethodNode m;
        BytecodeViewer.viewer.setIcon(true);
        gui.setText("");
        if (this.console) {
            gui.setVisible(true);
        }
        if (this.accessModifiers) {
            EZInjection.print("Setting all of the access modifiers to public/public static.");
        }
        if (this.injectHooks) {
            EZInjection.print("Injecting hook...");
        }
        if (debugHooks) {
            EZInjection.print("Hooks are debugging.");
        } else if (this.injectHooks) {
            EZInjection.print("Hooks are not debugging.");
        } else {
            EZInjection.print("Hooks are disabled completely.");
        }
        if (this.useProxy) {
            EZInjection.print("Forcing proxy as '" + this.proxy + "'.");
        }
        if (this.launchKit) {
            EZInjection.print("Launching the Graphicial Reflection Kit upon a succcessful invoke of the main method.");
        }
        for (ClassNode classNode : classNodeList) {
            for (Object o : classNode.fields.toArray()) {
                FieldNode f = (FieldNode)o;
                if (!this.accessModifiers) continue;
                if (f.access == 2 || f.access == 4) {
                    f.access = 1;
                }
                if (f.access == 10 || f.access == 12) {
                    f.access = 9;
                }
                if (f.access == 18 || f.access == 20) {
                    f.access = 17;
                }
                if (f.access != 26 && f.access != 28) continue;
                f.access = 25;
            }
            for (Object o : classNode.methods.toArray()) {
                m = (MethodNode)o;
                if (this.accessModifiers) {
                    if (m.access == 2 || m.access == 4) {
                        m.access = 1;
                    }
                    if (m.access == 10 || m.access == 12) {
                        m.access = 9;
                    }
                    if (m.access == 18 || m.access == 20) {
                        m.access = 17;
                    }
                    if (m.access == 26 || m.access == 28) {
                        m.access = 25;
                    }
                }
                if (!this.injectHooks || m.access == 1024 || m.access == 1025 || m.access == 1026 || m.access == 1028 || m.access == 1040 || m.access == 1041 || m.access == 1042 || m.access == 1044 || m.access == 1049 || m.access == 1050 || m.access == 1052) continue;
                boolean inject = true;
                if (m.instructions.size() >= 2 && m.instructions.get(1) instanceof MethodInsnNode) {
                    MethodInsnNode mn = (MethodInsnNode)m.instructions.get(1);
                    if (mn.owner.equals("the/bytecode/club/bytecodeviewer/plugins/EZInjection")) {
                        inject = false;
                    }
                }
                if (!inject) continue;
                m.instructions.insert(new MethodInsnNode(184, "the/bytecode/club/bytecodeviewer/plugins/EZInjection", "hook", "(Ljava/lang/String;)V"));
                m.instructions.insert(new LdcInsnNode(classNode.name + "." + m.name + m.desc));
            }
        }
        if (this.useProxy) {
            try {
                String[] split = this.proxy.split(":");
                EZInjection.setProxy(split[0], split[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        EZInjection.print("Done setting up.");
        this.setFinished();
        if (this.invokeMethod) {
            for (ClassNode cn : BytecodeViewer.getLoadedClasses()) {
                the.bytecode.club.bytecodeviewer.api.BytecodeViewer.getClassNodeLoader().addClass(cn);
            }
            EZInjection.print("Invoking " + this.invokeMethodInformation + ":" + BytecodeViewer.nl + BytecodeViewer.nl);
            for (ClassNode classNode : classNodeList) {
                for (Object o : classNode.methods.toArray()) {
                    m = (MethodNode)o;
                    String methodInformation = classNode.name + "." + m.name + m.desc;
                    if (!this.invokeMethodInformation.equals(methodInformation)) continue;
                    for (Method m2 : the.bytecode.club.bytecodeviewer.api.BytecodeViewer.getClassNodeLoader().nodeToClass(classNode).getMethods()) {
                        if (!m2.getName().equals(m.name)) continue;
                        try {
                            m2.invoke(classNode.getClass().newInstance(), (Object[])new String[1]);
                            if (!this.launchKit) continue;
                            new GraphicialReflectionKit().setVisible(true);
                        }
                        catch (Exception e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            e.printStackTrace();
                            EZInjection.print(sw.toString());
                        }
                    }
                }
            }
        }
        BytecodeViewer.viewer.setIcon(false);
    }

    static {
        all = false;
        lastMessage = "";
    }
}

