/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin.preinstalled;

import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.api.PluginConsole;

public class MaliciousCodeScanner
extends Plugin {
    public boolean ORE;
    public boolean ONE;
    public boolean ORU;
    public boolean OIO;
    public boolean LWW;
    public boolean LHT;
    public boolean LHS;
    public boolean LIP;
    public boolean NSM;
    public boolean ROB;

    public MaliciousCodeScanner(boolean reflect, boolean runtime, boolean net, boolean io, boolean www, boolean http, boolean https, boolean ip, boolean nullSecMan, boolean robot) {
        this.ORE = reflect;
        this.ONE = net;
        this.ORU = runtime;
        this.OIO = io;
        this.LWW = www;
        this.LHT = http;
        this.LHS = https;
        this.LIP = ip;
        this.NSM = nullSecMan;
        this.ROB = robot;
    }

    @Override
    public void execute(ArrayList<ClassNode> classNodeList) {
        PluginConsole frame = new PluginConsole("Malicious Code Scanner");
        StringBuilder sb = new StringBuilder();
        for (ClassNode classNode : classNodeList) {
            for (Object o : classNode.fields.toArray()) {
                FieldNode f = (FieldNode)o;
                Object v = f.value;
                if (v instanceof String) {
                    String s = (String)v;
                    if (this.LWW && s.contains("www.") || this.LHT && s.contains("http://") || this.LHS && s.contains("https://") || this.ORE && s.contains("java/lang/Runtime") || this.ORE && s.contains("java.lang.Runtime") || this.ROB && s.contains("java.awt.Robot") || this.ROB && s.contains("java/awt/Robot") || this.LIP && s.matches("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b")) {
                        sb.append("Found LDC \"" + s + "\" at field " + classNode.name + "." + f.name + "(" + f.desc + ")" + BytecodeViewer.nl);
                    }
                }
                if (!(v instanceof String[])) continue;
                for (int i = 0; i < ((String[])v).length; ++i) {
                    String s = ((String[])v)[i];
                    if (!(this.LWW && s.contains("www.") || this.LHT && s.contains("http://") || this.LHS && s.contains("https://") || this.ORE && s.contains("java/lang/Runtime") || this.ORE && s.contains("java.lang.Runtime") || this.ROB && s.contains("java.awt.Robot") || this.ROB && s.contains("java/awt/Robot")) && (!this.LIP || !s.matches("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b"))) continue;
                    sb.append("Found LDC \"" + s + "\" at field " + classNode.name + "." + f.name + "(" + f.desc + ")" + BytecodeViewer.nl);
                }
            }
            boolean prevInsn_aconst_null = false;
            for (Object o : classNode.methods.toArray()) {
                MethodNode m = (MethodNode)o;
                InsnList iList = m.instructions;
                for (AbstractInsnNode a : iList.toArray()) {
                    if (a instanceof MethodInsnNode) {
                        MethodInsnNode min = (MethodInsnNode)a;
                        if (this.ORE && min.owner.startsWith("java/lang/reflect") || this.ONE && min.owner.startsWith("java/net") || this.ORU && min.owner.equals("java/lang/Runtime") || this.ROB && min.owner.equals("java/awt/Robot") || this.OIO && min.owner.startsWith("java/io")) {
                            sb.append("Found Method call to " + min.owner + "." + min.name + "(" + min.desc + ") at " + classNode.name + "." + m.name + "(" + m.desc + ")" + BytecodeViewer.nl);
                        }
                    }
                    if (a instanceof LdcInsnNode && ((LdcInsnNode)a).cst instanceof String) {
                        String s = (String)((LdcInsnNode)a).cst;
                        if (this.LWW && s.contains("www.") || this.LHT && s.contains("http://") || this.LHS && s.contains("https://") || this.ORE && s.contains("java/lang/Runtime") || this.ORE && s.contains("java.lang.Runtime") || this.ROB && s.contains("java.awt.Robot") || this.ROB && s.contains("java/awt/Robot") || this.LIP && s.matches("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b")) {
                            sb.append("Found LDC \"" + s + "\" at method " + classNode.name + "." + m.name + "(" + m.desc + ")" + BytecodeViewer.nl);
                        }
                    }
                    if (a instanceof InsnNode && a.opcode() == 1) {
                        prevInsn_aconst_null = true;
                        continue;
                    }
                    if (a instanceof MethodInsnNode && a.opcode() == 184) {
                        String owner = ((MethodInsnNode)a).owner;
                        String name = ((MethodInsnNode)a).name;
                        if (!this.NSM || !prevInsn_aconst_null || !owner.equals("java/lang/System") || !name.equals("setSecurityManager")) continue;
                        sb.append("Found Security Manager set to null at method " + classNode.name + "." + m.name + "(" + m.desc + ")" + BytecodeViewer.nl);
                        prevInsn_aconst_null = false;
                        continue;
                    }
                    prevInsn_aconst_null = false;
                }
            }
        }
        frame.appendText(sb.toString());
        frame.setVisible(true);
    }
}

