/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin.preinstalled;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.api.PluginConsole;

public class ShowAllStrings
extends Plugin {
    @Override
    public void execute(final ArrayList<ClassNode> classNodeList) {
        final PluginConsole frame = new PluginConsole("Show All Strings");
        final AtomicBoolean complete = new AtomicBoolean(false);
        final Thread backgroundThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (ClassNode classNode : classNodeList) {
                        for (Object o : classNode.fields.toArray()) {
                            String s;
                            FieldNode f = (FieldNode)o;
                            Object v = f.value;
                            if (v instanceof String && !(s = (String)v).isEmpty()) {
                                frame.appendText(String.format("%s.%s%s -> \"%s\"", classNode.name, f.name, f.desc, s.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r")));
                            }
                            if (!(v instanceof String[])) continue;
                            for (int i = 0; i < ((String[])v).length; ++i) {
                                String s2 = ((String[])v)[i];
                                if (s2.isEmpty()) continue;
                                frame.appendText(String.format("%s.%s%s[%s] -> \"%s\"", classNode.name, f.name, f.desc, i, s2.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r")));
                            }
                        }
                        for (Object o : classNode.methods.toArray()) {
                            MethodNode m = (MethodNode)o;
                            InsnList iList = m.instructions;
                            for (AbstractInsnNode a : iList.toArray()) {
                                String s;
                                if (!(a instanceof LdcInsnNode) || !(((LdcInsnNode)a).cst instanceof String) || (s = (String)((LdcInsnNode)a).cst).isEmpty()) continue;
                                frame.appendText(String.format("%s.%s%s -> \"%s\"", classNode.name, m.name, m.desc, s.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r")));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    new ExceptionUI(e, "konloch@gmail.com");
                }
                finally {
                    complete.set(true);
                }
            }
        };
        frame.setVisible(true);
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                backgroundThread.stop();
                complete.set(true);
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        backgroundThread.start();
        while (!complete.get()) {
        }
    }
}

