/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.commons.IOUtils;

class ZipEntryUtil {
    private ZipEntryUtil() {
    }

    static ZipEntry copy(ZipEntry original) {
        return ZipEntryUtil.copy(original, null);
    }

    static ZipEntry copy(ZipEntry original, String newName) {
        ZipEntry copy = new ZipEntry(newName == null ? original.getName() : newName);
        if (original.getCrc() != -1L) {
            copy.setCrc(original.getCrc());
        }
        if (original.getMethod() != -1) {
            copy.setMethod(original.getMethod());
        }
        if (original.getSize() >= 0L) {
            copy.setSize(original.getSize());
        }
        if (original.getExtra() != null) {
            copy.setExtra(original.getExtra());
        }
        copy.setComment(original.getComment());
        copy.setTime(original.getTime());
        return copy;
    }

    static void copyEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntryUtil.copyEntry(zipEntry, in, out, true);
    }

    static void copyEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out, boolean preserveTimestamps) throws IOException {
        ZipEntry copy = ZipEntryUtil.copy(zipEntry);
        copy.setTime(preserveTimestamps ? zipEntry.getTime() : System.currentTimeMillis());
        ZipEntryUtil.addEntry(copy, new BufferedInputStream(in), out);
    }

    static void addEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        out.putNextEntry(zipEntry);
        if (in != null) {
            IOUtils.copy(in, out);
        }
        out.closeEntry();
    }
}

