/*
 * Decompiled with CFR 0.152.
 */
package p.rn.owner;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

public class ReOwner {
    private Map<String, String> mz = new HashMap<String, String>();
    private Set<String> ignores = new HashSet<String>();
    private Map<String, String> clz = new HashMap<String, String>();

    public byte[] reOwnerOne(String className, InputStream is) throws IOException {
        return this.reOwnerOne(className, IOUtils.toByteArray((InputStream)is));
    }

    public byte[] reOwnerOne(String className, byte[] data) throws IOException {
        if (this.ignores.contains(className)) {
            return data;
        }
        ClassWriter cw = new ClassWriter(0);
        new ClassReader(data).accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)new ClassAdapter((ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (mv == null) {
                    return null;
                }
                return new MethodAdapter(mv){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        String nOwner = (String)ReOwner.this.mz.get(String.valueOf(owner) + "." + name);
                        String nName = name;
                        if (nOwner == null) {
                            nOwner = (String)ReOwner.this.mz.get(String.valueOf(owner) + "." + name + desc.substring(0, desc.lastIndexOf(41) + 1));
                        }
                        if (nOwner == null) {
                            nOwner = owner;
                        } else {
                            int index = nOwner.indexOf(46);
                            if (index > 0) {
                                nName = nOwner.substring(index + 1);
                                nOwner = nOwner.substring(0, index);
                            }
                        }
                        super.visitMethodInsn(opcode, nOwner, nName, desc);
                    }
                };
            }
        }, (Remapper)new SimpleRemapper(this.clz)), 8);
        return cw.toByteArray();
    }

    public void reOwner(File from, File to) throws IOException {
        final FileOut.OutHandler zo = FileOut.create(to);
        try {
            new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

                @Override
                public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                    if (!isDir) {
                        if (name.endsWith(".class")) {
                            String clzName = name.substring(0, name.length() - ".class".length());
                            if (ReOwner.this.ignores.contains(clzName)) {
                                zo.write(isDir, name, current.get(), nameObject);
                            } else {
                                zo.write(isDir, name, ReOwner.this.reOwnerOne(clzName, current.get()), nameObject);
                            }
                        } else if (name.startsWith("META-INF/")) {
                            if (name.equals("META-INF/MANIFEST.MF")) {
                                Manifest mf = new Manifest(current.get());
                                mf.getMainAttributes().put(new Attributes.Name("X-NOTICE"), "Modified");
                                mf.getEntries().clear();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                mf.write(baos);
                                baos.flush();
                                zo.write(isDir, name, baos.toByteArray(), nameObject);
                            } else if (!(name.endsWith(".DSA") || name.endsWith(".RSA") || name.endsWith(".SF"))) {
                                zo.write(isDir, name, current.get(), nameObject);
                            }
                        } else {
                            zo.write(isDir, name, current.get(), nameObject);
                        }
                    }
                }
            }).walk(from);
        }
        finally {
            IOUtils.closeQuietly((Closeable)zo);
        }
    }

    public ReOwner withConfig(File config) throws IOException {
        if (config != null) {
            FileInputStream is = null;
            try {
                is = FileUtils.openInputStream((File)config);
                ReOwner reOwner = this.withConfig(is);
                return reOwner;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return this;
    }

    public ReOwner withConfig(InputStream is) throws IOException {
        if (is != null) {
            for (String ln : IOUtils.readLines((InputStream)is, (String)"UTF-8")) {
                if ("".equals(ln) || ln.startsWith("#")) continue;
                switch (ln.charAt(0)) {
                    case 'I': 
                    case 'i': {
                        this.ignores.add(ln.substring(2));
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        int index = ln.lastIndexOf(61);
                        if (index <= 0) break;
                        String key = ln.substring(2, index);
                        String value = ln.substring(index + 1);
                        this.clz.put(key, value);
                        this.ignores.add(value);
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        int index = ln.lastIndexOf(61);
                        if (index <= 0) break;
                        String key = ln.substring(2, index);
                        String value = ln.substring(index + 1);
                        index = key.lastIndexOf(41);
                        if (index > 0) {
                            this.mz.put(key.substring(0, index + 1), value);
                        } else {
                            this.mz.put(key, value);
                        }
                        index = value.indexOf(46);
                        if (index > 0) {
                            this.ignores.add(value.substring(0, index - 1));
                            break;
                        }
                        this.ignores.add(value);
                    }
                }
            }
        }
        return this;
    }
}

