/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;

public class Tree<E extends Tree<E>>
extends CopyOnWriteArrayList<E> {
    protected Tree<E> parent;

    public Tree() {
    }

    public Tree(Collection<? extends E> collection) {
        super(collection);
    }

    @Override
    public void addFirst(E e) {
        ArrayList<Tree> list = new ArrayList<Tree>();
        for (Tree element : this) {
            list.add(element);
        }
        this.clear();
        ((Tree)e).parent = this;
        this.add(e);
        this.addAll(list);
    }

    public void set(E predecessor, E successor) {
        Iterator it = this.parent.iterator();
        LinkedList<E> es = new LinkedList<E>();
        while (it.hasNext()) {
            Tree e = (Tree)it.next();
            if (e.equals(predecessor)) {
                es.add(successor);
                continue;
            }
            es.add(e);
        }
        this.parent.clear();
        this.parent.addAll(es);
    }

    public E parent() {
        return (E)this.parent;
    }

    public boolean hasParent() {
        return this.parent() != null;
    }

    public E previous() {
        Tree<E> p = this.parent;
        if (p == null) {
            return null;
        }
        Iterator it = this.parent.iterator();
        Tree prev = null;
        while (it.hasNext()) {
            Tree e = (Tree)it.next();
            if (e.equals(this)) {
                return (E)prev;
            }
            prev = e;
        }
        return null;
    }

    public boolean hasPrevious() {
        return this.previous() != null;
    }

    public E next() {
        Tree<E> p = this.parent;
        if (p == null) {
            return null;
        }
        Iterator it = this.parent.iterator();
        while (it.hasNext()) {
            Tree e = (Tree)it.next();
            if (!e.equals(this)) continue;
            return (E)(it.hasNext() ? (Tree)it.next() : null);
        }
        return null;
    }

    public boolean hasNext() {
        return this.next() != null;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Tree e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

