/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.tree.util;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.cfg.Block;
import org.objectweb.asm.commons.cfg.tree.NodeTree;
import org.objectweb.asm.commons.cfg.tree.node.AbstractNode;
import org.objectweb.asm.commons.cfg.tree.node.ArithmeticNode;
import org.objectweb.asm.commons.cfg.tree.node.ConstantNode;
import org.objectweb.asm.commons.cfg.tree.node.ConversionNode;
import org.objectweb.asm.commons.cfg.tree.node.FieldMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.IincNode;
import org.objectweb.asm.commons.cfg.tree.node.JumpNode;
import org.objectweb.asm.commons.cfg.tree.node.MethodMemberNode;
import org.objectweb.asm.commons.cfg.tree.node.NumberNode;
import org.objectweb.asm.commons.cfg.tree.node.TypeNode;
import org.objectweb.asm.commons.cfg.tree.node.VariableNode;
import org.objectweb.asm.commons.cfg.tree.util.TreeSize;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TreeBuilder {
    public static final int[] CDS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 4, 3, 4, 3, 3, 3, 3, 1, 2, 1, 2, 3, 2, 3, 4, 2, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 1, 2, 1, 2, 2, 3, 2, 3, 2, 3, 2, 4, 2, 4, 2, 4, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 4, 2, 2, 4, 4, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0};
    public static final int[] PDS = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 0, 0, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 4, 5, 6, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    private int treeIndex = -1;
    public long create = 0L;
    public long iterate = 0L;

    public static TreeSize getTreeSize(AbstractInsnNode ain) {
        int c = 0;
        int p = 0;
        if (ain instanceof InsnNode || ain instanceof IntInsnNode || ain instanceof VarInsnNode || ain instanceof JumpInsnNode || ain instanceof TableSwitchInsnNode || ain instanceof LookupSwitchInsnNode) {
            c = CDS[ain.opcode()];
            p = PDS[ain.opcode()];
        } else if (ain instanceof FieldInsnNode) {
            FieldInsnNode fin = (FieldInsnNode)ain;
            char d = fin.desc.charAt(0);
            switch (fin.opcode()) {
                case 180: {
                    c = 1;
                    p = d == 'D' || d == 'J' ? 2 : 1;
                    break;
                }
                case 178: {
                    c = 0;
                    p = d == 'D' || d == 'J' ? 2 : 1;
                    break;
                }
                case 181: {
                    c = d == 'D' || d == 'J' ? 3 : 2;
                    p = 0;
                    break;
                }
                case 179: {
                    c = d == 'D' || d == 'J' ? 2 : 1;
                    p = 0;
                    break;
                }
                default: {
                    c = 0;
                    p = 0;
                    break;
                }
            }
        } else if (ain instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)ain;
            int as = Type.getArgumentsAndReturnSizes(min.desc);
            c = (as >> 2) - (min.opcode() == 186 || min.opcode() == 184 ? 1 : 0);
            p = as & 3;
        } else if (ain instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)ain).cst;
            p = cst instanceof Double || cst instanceof Long ? 2 : 1;
        } else if (ain instanceof MultiANewArrayInsnNode) {
            c = ((MultiANewArrayInsnNode)ain).dims;
            p = 1;
        }
        return new TreeSize(c, p);
    }

    private static AbstractNode createNode(AbstractInsnNode ain, NodeTree tree, TreeSize size) {
        int opcode = ain.opcode();
        if (ain instanceof IntInsnNode) {
            return new NumberNode(tree, ain, size.collapsing, size.producing);
        }
        if (ain instanceof VarInsnNode) {
            return new VariableNode(tree, ain, size.collapsing, size.producing);
        }
        if (ain instanceof JumpInsnNode) {
            return new JumpNode(tree, (JumpInsnNode)ain, size.collapsing, size.producing);
        }
        if (ain instanceof FieldInsnNode) {
            return new FieldMemberNode(tree, ain, size.collapsing, size.producing);
        }
        if (ain instanceof MethodInsnNode) {
            return new MethodMemberNode(tree, ain, size.collapsing, size.producing);
        }
        if (ain instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)ain).cst;
            if (cst instanceof Number) {
                return new NumberNode(tree, ain, size.collapsing, size.producing);
            }
            return new ConstantNode(tree, ain, size.collapsing, size.producing);
        }
        if (ain instanceof IincInsnNode) {
            return new IincNode(tree, ain, size.collapsing, size.producing);
        }
        if (ain instanceof TypeInsnNode) {
            return new TypeNode(tree, ain, size.collapsing, size.producing);
        }
        if (opcode >= 2 && opcode <= 15) {
            return new NumberNode(tree, ain, size.collapsing, size.producing);
        }
        if (opcode >= 133 && opcode <= 147) {
            return new ConversionNode(tree, ain, size.collapsing, size.producing);
        }
        if (opcode >= 96 && opcode <= 131) {
            return new ArithmeticNode(tree, ain, size.collapsing, size.producing);
        }
        return new AbstractNode(tree, ain, size.collapsing, size.producing);
    }

    private AbstractNode iterate(List<AbstractNode> nodes) {
        AbstractNode n;
        if (this.treeIndex < 0) {
            return null;
        }
        AbstractNode node = nodes.get(this.treeIndex--);
        if (node.collapsed == 0) {
            return node;
        }
        for (int c = node.collapsed; c != 0 && (n = this.iterate(nodes)) != null; c -= n.producing) {
            int op = n.opcode();
            if (op == 195 && node.opcode() == 191) {
                n.producing = 1;
            }
            node.addFirst(n);
            int cr = c - n.producing;
            if (cr < 0) {
                node.producing += -cr;
                n.producing = 0;
                break;
            }
            n.producing = 0;
        }
        return node;
    }

    public NodeTree build(MethodNode mn) {
        AbstractNode node;
        NodeTree tree = new NodeTree(mn);
        ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
        long start = System.nanoTime();
        for (AbstractInsnNode ain : mn.instructions.toArray()) {
            nodes.add(TreeBuilder.createNode(ain, tree, TreeBuilder.getTreeSize(ain)));
        }
        long end = System.nanoTime();
        this.create += end - start;
        this.treeIndex = nodes.size() - 1;
        start = System.nanoTime();
        while ((node = this.iterate(nodes)) != null) {
            tree.addFirst(node);
        }
        end = System.nanoTime();
        this.iterate += end - start;
        return tree;
    }

    public NodeTree build(Block block) {
        AbstractNode node;
        NodeTree tree = new NodeTree(block);
        ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
        long start = System.nanoTime();
        for (AbstractInsnNode ain : block.instructions) {
            nodes.add(TreeBuilder.createNode(ain, tree, TreeBuilder.getTreeSize(ain)));
        }
        long end = System.nanoTime();
        this.create += end - start;
        this.treeIndex = nodes.size() - 1;
        start = System.nanoTime();
        while ((node = this.iterate(nodes)) != null) {
            tree.addFirst(node);
        }
        end = System.nanoTime();
        this.iterate += end - start;
        return tree;
    }
}

