/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class JarArchive {
    private final Map<String, ClassNode> nodes = new HashMap<String, ClassNode>();
    private final File file;
    private Manifest manifest;

    public JarArchive(File file) {
        this.file = file;
    }

    public Map<String, ClassNode> build() {
        if (!this.nodes.isEmpty()) {
            return this.nodes;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(this.file);
            this.manifest = jar.getManifest();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                ClassNode cn = new ClassNode();
                ClassReader reader = new ClassReader(jar.getInputStream(entry));
                reader.accept(cn, 6);
                this.nodes.put(name.replace(".class", ""), cn);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error building classes (" + this.file.getName() + "): ", e.getCause());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
        return this.nodes;
    }

    public void write(File target) {
        try (JarOutputStream output = this.manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(target), this.manifest) : new JarOutputStream(new FileOutputStream(target));){
            for (Map.Entry<String, ClassNode> entry : this.build().entrySet()) {
                output.putNextEntry(new JarEntry(entry.getKey().replaceAll("\\.", "/") + ".class"));
                ClassWriter writer = new ClassWriter(0);
                entry.getValue().accept(writer);
                output.write(writer.toByteArray());
                output.closeEntry();
            }
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write() {
        this.write(this.file);
    }
}

